#!/bin/sh -xvf
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
FIND=/usr/bin/find
MKDIR=/bin/mkdir
XARGS=/usr/bin/xargs
SORT=/bin/sort
RM=/bin/rm
TR=/usr/bin/tr
CP=/bin/cp
LS=/bin/ls
CHMOD=/bin/chmod

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
dateSelect=
force=
forDriftScan=

while [ $# -gt 0 ]
  do
  case "$1" in
      -src)  sourceRadio=$2; shift;;
      -date) dateSelect=$2; shift;;
      -force) force="-force";;
      -drift) forDriftScan="-drift";;
       -h)
            echo >&2 \
	    "usage: $0 -src source -date YYYYMMDD [-force] [-drift]"
	    exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"


#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null

#Path of the utility scripts
scriptpath=${SCRIPTPATH}

#JEC 1/10/11 Use generic baodaqstatus name 
#the daq current irod status
#tag=`${DATE} +%F`
#OUT1=${publicpath}/baodaqstatus-${tag}.txt
OUT1=${publicpath}/baodaqstatus-current.txt

if [ ! -e ${OUT1}  -o ! -r ${OUT1} ]; then
    $ECHO "FATAL (${scriptName}): ${OUT1} has a problem"
    exit 1
fi

jobBatchName="scaMaker-$sourceRadio"
jobLogName="${jobBatchName}.log.$$"

qsub -P P_baoradio -l sps=1,irods=1,ct=100,vmem=256M,fsize=70M -o ${PWD}/${jobLogName} -j yes -N $jobBatchName -m be -M ${LOGNAME}@lal.in2p3.fr -V <<EOF

${SCRIPTPATH}/scaextractor.sh  -src ${sourceRadio} -date ${dateSelect} ${force} ${forDriftScan}
EOF
