#!/bin/sh
#Get SCA file and summary + transformed date file
#
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
TR=/usr/bin/tr
MKDIR=/bin/mkdir
CAT=/bin/cat
PRINTF=/usr/bin/printf
RM=/bin/rm
LS=/bin/ls
DefaultIFS=$' \t\n'
IFS=$DefaultIFS

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"


if [ ! $# = 2 ]; then
  $ECHO "usage: ${script
Name} <source:ex. Abell85> <date:YYYYMMDD>"
  exit 0
fi

# Irods environment settings
#export PATH=$PATH:/home/bao/irods2.5_LinuxSL5
. /usr/local/shared/bin/irods_env.sh -noverbose


sourceRadio=$1
srclower=`${ECHO} ${sourceRadio} | ${TR} "[:upper:]" "[:lower:]" `
dateDAQ=$2


#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null


#Path where the job will do temporary IO
. ${SCRIPTPATH}/set_iojobpath.sh
iojobpath=$(set_iojobpath)
cd ${iojobpath}

localpath="${sourceRadio}/${dateDAQ}${srclower}"
$MKDIR -p ./${localpath}
cd ./${localpath}


#Path of the utility scripts
scriptpath=${SCRIPTPATH}

#JEC 1/10/11 Use generic baodaqstatus name 
#look if the run exists
#tag=`${DATE} +%F`
#OUT1=${publicpath}/baodaqstatus-${tag}.txt
OUT1=${publicpath}/baodaqstatus-current.txt

if [ ! -e ${OUT1} -o ! -r ${OUT1} ]; then
#    $ECHO "We should bring the DAQ status more up to date, this take 1 or 2sec..."
#    $RM -f ${tmppublicpath}/statusdaq.finished
#    ${scriptpath}/statusdaq.sh > ${OUT1}
#    while [ ! -f "${tmppublicpath}/statusdaq.finished" ]; do
# 	$ECHO "INFO (${scriptName}); waiting for ${tmppublicpath}/statusdaq.finished"
# 	date +%T
# 	sleep 30
#     done
#     $RM ${tmppublicpath}/statusdaq.finished
    $ECHO "FATAL (${scriptName}): ${OUT1} is missing or not readable..."
    exit 1
fi

nfiles=`${GREP} "${sourceRadio}.*${dateDAQ}" ${OUT1} | ${AWK} '(NF==4){print $4}'` 

if [ "<${nfiles}>" = "<>" ]; then
    $ECHO "FATAL (${scriptName}): No run found for <${sourceRadio}> and date <${dateDAQ}>"
    exit 1
fi


#Look if the run should/can be prepared wrt SCA file transformation 
OUT2=./scaStatus.$$
#JEC 29/9/11 avoid finished stuff
#$RM -f ${tmppublicpath}/scaextractor.finished
${scriptpath}/scaextractor.sh $sourceRadio > ${OUT2} 2>&1
#while [ ! -f "${tmppublicpath}/scaextractor.finished" ]; do
#    $ECHO "INFO (${scriptName}); waiting for ${tmppublicpath}/scaextractor.finished"
#    date +%T
#    sleep 30
#done
#$RM ${tmppublicpath}/scaextractor.finished


status=`$GREP "^FATAL.*${sourceRadio}.*${dateDAQ}" ${OUT2}`

if [ "<$status>" != "<>" ]; then
    $ECHO "FATAL (${scriptName}): connot proceed further with $sourceRadio $dateDAQ"
    exit 1
fi
$RM $OUT2

#dowload sca files...
dirIrod="/baoradio/data/AmasNancay/${sourceRadio}/${dateDAQ}${srclower}"
dirLocal="."

if [ ! -e $dirLocal ]; then
 $MKDIR -p $dirLocal
fi

cd $dirLocal

OUT3=./scaFiles.$$
ils $dirIrod | $GREP -i "sca" > ${OUT3}
tableau=( `$CAT ${OUT3}`  )
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS
$RM $OUT3

OUT4=./igetStatus.$$
for i in ${tableau[@]}
do
  if [ ! -e $i ]; then
    iget -r -f -v -K ${dirIrod}/$i ${dirLocal} > ${OUT4} 2>&1
  fi
done

igetStatus=`$GREP "^ERROR" ${OUT4}`
if [ "<$igetStatus>" != "<>" ]; then
  $ECHO "FATAL (${scriptName}): error while iget:"
  $ECHO $igetStatus
  exit 1
fi

$RM -f $OUT4

exit 0
