#!/bin/sh -xvf
#download SCA file, proceed to introspection, and upload results
DATE=/bin/date
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
WC=/usr/bin/wc
CAT=/bin/cat
PRINTF=/usr/bin/printf
MKDIR=/bin/mkdir
RM=/bin/rm
LS=/bin/ls
TR=/usr/bin/tr
DefaultIFS=$' \t\n'
IFS=$DefaultIFS


#set Irods environment    
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
dateSelected=
#force recomputation force=Yes
force="No"
#use Drift Scan script=Yes
is4DriftScan="No"
while [ $# -gt 0 ]
  do
  case "$1" in
      -src)  sourceRadio=$2; shift;;
      -date) dateSelected=$2;     shift;;
      -force) force="Yes";;
      -drift) is4DriftScan="Yes";;
      -h)
      echo >&2 \
	  "usage: $0 -src souce -date YYYYMMDD [-force] [-drift]"
          exit 1;;
      *)  break;;	# terminate while loop
  esac
  shift
done


#which source to analyse
srclower=`${ECHO} ${sourceRadio} | ${TR} "[:upper:]" "[:lower:]" `


#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null


#Path where the job will do temporary IO
. ${SCRIPTPATH}/set_iojobpath.sh
iojobpath=$(set_iojobpath)
cd ${iojobpath}


localpath="${sourceRadio}"
$MKDIR -p ./${localpath}
cd ./${localpath}


#Path of the utility scripts
scriptpath=${SCRIPTPATH}


#JEC 1/10/11 Use generic baodaqstatus name 
OUT1=${publicpath}/baodaqstatus-current.txt


if [ ! -e ${OUT1} -o ! -r ${OUT1} ]; then
    $ECHO "FATAL (${scriptName}): ${OUT1} has a problem"
    exit 1
fi

if [ ! "<${sourceRadio}>" = "<>" ]; then
    $ECHO "You have selected sourceRadio = $sourceRadio[date = ${dateSelected}]"
#JEC 14/12/11 One should take care of DR extension for Drift Scan
#tableau=( `$GREP -i "${dateSelected}${srclower}" ${OUT1} | $AWK '( NF==4 ) { print $2 }' ` )
    tableau=( `$GREP -i "${sourceRadio}/${dateSelected}${srclower}" ${OUT1} | $AWK '( NF==4 ) { print $2 }' ` )
else
    tableau=( `$CAT ${OUT1} | $AWK'( NF==4 ) { print $2 }'`  )
fi
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

for i in ${tableau[@]}
do
OUT2=./baodir.$$
#scrutinize irods directory
#Nb: we do not care here if ILS returns non unique instance of a file
  ils -l $i 2>&1 | $GREP -i "sca" > ${OUT2}
  $CAT ${OUT2}
#test if the SCA file has been already processed
  scatrans=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $NF}'`
#test if the file is empty due to previous processing dysfunction
  emptyfile=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $4}'`
#  echo "scrutinize directory <$i>: [$nblines] [$scatrans]" 
  if [ "<${scatrans}>" = "<>" -o "<${emptyfile}>" = "<0>" -o "<${force}>" = "<Yes>" ]; then
      $ECHO "$i may be non prepared for analysis..."
      scafile=`$GREP -i "sca[0-9][0-9]*\.[0-9][0-9]*" ${OUT2} | $AWK '{print $NF}'`
      if [ "<${scafile}>" = "<>" ]; then
	  $ECHO "WARNING (${scriptName}): Cannot download a SCA file for $i"
      else
#get sca file
        iget -r -f -v -K ${i}/${scafile} ${iojobpath}
#extract summary (sum extension)
#JEC 7/12/11 START
	if [ "<${is4DriftScan}>" != "<Yes>" ]; then
	    ${scriptpath}/sca.sh ${scafile}
	    $ECHO "INFO (${scriptName}): sca.sh has finished"
	else
	    ${scriptpath}/sca_ds.sh ${scafile}
	    $ECHO "INFO (${scriptName}): sca_ds.sh has finished"
	fi
#
#TODO see if there is errors...
        scaFileName=$(basename $scafile)
	scaFileName=${scaFileName%.*}
#transform the date (sum.trans extension)
        ${scriptpath}/transdate.sh ${scaFileName}.sum
	$ECHO "INFO (${scriptName}): transdate.sh  has finished"
	iput -f -v -K ${iojobpath}/${scaFileName}.sum $i
	iput -f -v -K ${iojobpath}/${scaFileName}.sum.trans $i
      fi
  fi
$RM ${OUT2}
done

exit 0
