#!/bin/sh
#liste des "sources" enregistrees sous Amas
AWK=/bin/awk
SED=/bin/sed
GREP=/bin/grep
WC=/usr/bin/wc
RM=/bin/rm
CAT=/bin/cat
TOUCH=/bin/touch
DATE=/bin/date
ECHO=/bin/echo
LS=/bin/ls
MKDIR=/bin/mkdir
TR=/usr/bin/tr
FIND=/usr/bin/find
PRINTF=/usr/bin/printf
XARGS=/usr/bin/xargs
SORT=/bin/sort
QSUB=qsub

DefaultIFS=$' \t\n'
IFS=$DefaultIFS

trim() { echo $1; }


# Irods environment settings
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"


#temporary files to synchronize scripts
tmppublicpath=${TMPPUBLICPATH}
$LS -l ${tmppublicpath} > /dev/null


#Path where the job will do temporary IO
. ${SCRIPTPATH}/set_iojobpath.sh
iojobpath=$(set_iojobpath) 
cd ${iojobpath}


OUT1=./baoils.$$
ils /baoradio/data/AmasNancay/ > ${OUT1}
OUT2=./baoawk1.$$
$AWK '($1=="C-") {print $2}' ${OUT1} > ${OUT2}
$RM $OUT1
#Sequence 
tableau=( `$CAT $OUT2 | $AWK '{print $1}'` )
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

$RM $OUT2

for i in ${tableau[@]}
do
  OUT2=./baodir.$$
  $ECHO "source $i"
  listedate=( `ils $i | $AWK '($1=="C-"){print $2}'`)
  IFS='
'
  listedate=( $( $PRINTF "%s\n" "${listedate[@]}" | $AWK 'x[$0]++ == 0' ) )
  IFS=$DefaultIFS

  for j in ${listedate[@]}
  do
    ils -l $j 2>&1 | $GREP -i "sca" > ${OUT2}
#test if the SCA file has been already processed
    scatrans=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $NF}'`
#test if the file is empty due to previous processing dysfunction
    emptyfile=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $4}'`
#  echo "scrutinize directory <$i>: [$nblines] [$scatrans]" 
    if [ "<${scatrans}>" != "<>" ]; then
	scafile=`$GREP -i "sca.*\.sum\.trans" ${OUT2} | $AWK '{print $NF}'`
	if [ "<${scafile}>" = "<>" ]; then
	    $ECHO "WARNING (${scriptName}): Cannot download a SCA file for $j"
	else
#get sca file
	    iget -r -f -K ${j}/${scafile}
	    ncycle=`$CAT ${scafile} | $WC -l`
	    $RM ${scafile}
	    $ECHO ">>> $j ---> ${ncycle} cycles"
	fi
    else
	$ECHO ">>> $j ---> NO SCA summary"
    fi
  done 
  $RM ${OUT2}
done



