#!/bin/sh
#liste des "sources" enregistrees sous Amas
GREP=/bin/grep
AWK=/bin/awk
ECHO=/bin/echo
MKDIR=/bin/mkdir
CAT=/bin/cat
PRINTF=/usr/bin/printf
RM=/bin/rm
SORT=/bin/sort
XARGS=/usr/bin/xargs
WC=/usr/bin/wc
DefaultIFS=$' \t\n'
IFS=$DefaultIFS

# Irods environment settings
. /usr/local/shared/bin/irods_env.sh -noverbose

scriptName="`basename $0`"
$ECHO "Processing script ${scriptName} at `date`"

#Path to public backupable path
publicpath="/afs/in2p3.fr/home/c/campagne/public"

#Path where the job will do temporary IO
. ${SCRIPTPATH}/set_iojobpath.sh
iojobpath=$(set_iojobpath)
cd ${iojobpath}


OUT1=./baoils.$$
ils /baoradio/data/AmasNancay/ > ${OUT1}
OUT2=./baoawk1.$$
$AWK '($1=="C-") {print $2}' ${OUT1} > ${OUT2}
$RM $OUT1
#Sequence 
tableau=( `$CAT $OUT2 | $AWK '{print $1}'` )
IFS='
'
tableau=( $( $PRINTF "%s\n" "${tableau[@]}" | $AWK 'x[$0]++ == 0' ) )
IFS=$DefaultIFS

$RM $OUT2

for i in ${tableau[@]}
do
  $ECHO "source $i"
  listedate=( `ils $i | $AWK '($1=="C-"){print $2}'`)
  IFS='
'
  listedate=( $( $PRINTF "%s\n" "${listedate[@]}" | $AWK 'x[$0]++ == 0' ) )

  ntotfiles=0
  for j in ${listedate[@]}
  do
#Fiber 1
    listOfsig1=( `ils ${j}/Fiber1 | $GREP -i "signal" | $XARGS -i basename {} | $SORT -k1.7n` )
    IFS='
  '
    listOfsig1=( $( $PRINTF "%s\n" "${listOfsig1[@]}" | $AWK 'x[$0]++ == 0' ) )
    nblinesSIG1=${#listOfsig1[@]}
    listOfhdr1=( `ils ${j}/Fiber1 | $GREP -i "header" | $XARGS -i basename {} | $SORT -k1.7n` )
    IFS='
    '
    listOfhdr1=( $( $PRINTF "%s\n" "${listOfhdr1[@]}" | $AWK 'x[$0]++ == 0' ) )
    nblinesHDR1=${#listOfhdr1[@]}

#Fiber 2
    listOfsig2=( `ils ${j}/Fiber2 | $GREP -i "signal" | $XARGS -i basename {} | $SORT -k1.7n` )
    IFS='
  '
    listOfsig2=( $( $PRINTF "%s\n" "${listOfsig2[@]}" | $AWK 'x[$0]++ == 0' ) )
    nblinesSIG2=${#listOfsig2[@]}
    listOfhdr2=( `ils ${j}/Fiber2 | $GREP -i "header" | $XARGS -i basename {} | $SORT -k1.7n` )
    IFS='
    '
    listOfhdr2=( $( $PRINTF "%s\n" "${listOfhdr2[@]}" | $AWK 'x[$0]++ == 0' ) )
    nblinesHDR2=${#listOfhdr2[@]}



    $ECHO ">>> $j --->  Fib1: $nblinesHDR1 / $nblinesSIG1 Fib2: $nblinesHDR2 / $nblinesSIG2"
    let "ntotfiles=ntotfiles+$nblinesSIG1"
  done 
  $ECHO "total signal Fiber1 files = $ntotfiles"

done
