#include "machdefs.h"

//---- System et stdc++ include files
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <iostream>
#include <fstream>
#include <complex>

#include <typeinfo>
#include <string>
#include <vector>
#include <map>
#include <functional>
#include <list>

//---- Sophya include files
#include "sopnamsp.h"
#include "basetools.h"
#include "systools.h"
#include "sutils.h"
#include "ntools.h"
#include "array.h"
#include "histats.h"

//---- Spiapp include files
#include "nobjmgr.h"
#include "servnobjm.h"

//---- Include files from additionnal modules

//---- function to compare bits on double 
int_8 BitCmp64(double v,int_8 flg) 
{return ((int_8)((v<0.) ? v-0.1 : v+0.1))&flg;} 

//---- function for Adding and displaying Objects  
void Keep_Object(AnyDataObj & obj, string const & nom) 
{ 
  string name = nom; 
  NamedObjMgr om; 
  if (om.GetObj(name)) 
    cerr << "KeepObj()/Warning Already kept object " << endl; 
  else om.AddObj(obj, name); 
} 

void Display_Object(AnyDataObj & obj, string const & opt, string const & nom) 
 { 
  string name = nom; 
  NamedObjMgr om; 
  if (!om.GetObj(name)) 
    om.AddObj(obj, name); 
  om.DisplayObj(name, opt); 
} 

//---- function for getting and setting ObjectManager variables  
void Set_ObjMgrVar(MuTyV v, string const & nom) 
{ 
  NamedObjMgr om; 
  om.SetVar(nom, (string)v); 
} 

MuTyV Get_ObjMgrVar(const char * nom) 
{ 
  string name = nom; NamedObjMgr om; 
  MuTyV v = om.GetVar(name); 
  return v; 
} 

//---- Macro for Objects and variables saving
#define KeepObj(obj) Keep_Object(obj, #obj)
#define GetOMVar(var) Get_ObjMgrVar( #var )
#define SetOMVar(var) Set_ObjMgrVar(var, #var )

//---- Macro Displaying objects and command execution
#define DispObj(obj, att) Display_Object(obj, att, #obj); 

#define ExecCmd(cmd) srvo.ExecuteCommand(cmd); 



//-------------------------------------------------//
//----------------- User Functions ----------------//
//-------------------------------------------------//

extern "C" {
  int meanSigSum( vector<string>& args );
}

int meanSigSum( vector<string>& args )
{
// Some definitions to help using spiapp;
NamedObjMgr omg;
Services2NObjMgr& srvo = *omg.GetServiceObj();

//-------------- Object List --------------
//Number of objects = 2
string ___nomobj;

___nomobj = "invec";
TVector< r_4 > * ___invec = dynamic_cast< TVector< r_4 >  * >(omg.GetObj(___nomobj));

___nomobj = "inmat";
TMatrix< r_4 > * ___inmat = dynamic_cast< TMatrix< r_4 >  * >(omg.GetObj(___nomobj));




//--------------------------------------------//
//----------------- User Code ----------------//
//--------------------------------------------//
 
 sa_size_t NUMBER_OF_FREQ = 8192;
 sa_size_t bandWidth = 250;
 r_4 lowestFreq = 1250.;

 r_4 lowFreq = atof(args[0].c_str());
 sa_size_t lowBin= (sa_size_t)(((lowFreq-lowestFreq)/bandWidth)*NUMBER_OF_FREQ);
 r_4 highFreq = atof(args[1].c_str());
 sa_size_t highBin= (sa_size_t)(((highFreq-lowestFreq)/bandWidth)*NUMBER_OF_FREQ);

 cout << "Results for Freq Range: [" << lowFreq << ", " 
      << highFreq << "]" << endl;

 if (___inmat!=NULL) {
   TMatrix< r_4 > & inmat = (*___inmat);
   for (sa_size_t iCh=0;iCh<inmat.NRows(); ++iCh){
     TMatrix<r_4> tmp = inmat.SubMatrix(Range(iCh),Range(lowBin,highBin));
     double mean; 
     double sigma;
     MeanSigma(tmp,mean,sigma);
     double sum = tmp.Sum();
     cout << "Ch [" << iCh <<"]: " 
	  << " mean/sigma: " << mean << " +/- " << sigma
	  << " sum: " << sum
	  << endl;
   }
 }

 if (___invec!=NULL) {
   TVector< r_4 > & invec = (*___invec);
   TVector<r_4> tmp = invec.SubVector(Range(lowBin,highBin));
   double mean; 
   double sigma;
   MeanSigma(tmp,mean,sigma);
   double sum = tmp.Sum();
   cout << " mean/sigma: " << mean << " +/- " << sigma
	<< " sum: " << sum
	<< endl;
 }


 
 return 0;
}
