#!/bin/sh -xv

scriptName="`basename $0`"
echo "Processing script ${scriptName} at `date`"

#Process cmd line args: the -src option is mandatory (source name as Abell85)
sourceRadio=
dateSelected=
#use -sim option to simulate processing (debug the script as if...)
simulationMode=""
while [ $# -gt 0 ]
do
  case "$1" in
      -src)  sourceRadio="$2"; shift;;
      -date) dateSelected="-date $2"; dateJob="$2";     shift;;
      -sim) 
      simulationMode="-sim On"
      $ECHO "INFO ${scriptName} running in SIMUL mode";;
	-h)
	echo >&2 \
	    "usage: $0 -src source -date YYYYMMDD"
	exit 1;;
	*)  break;;	# terminate while loop
    esac
    shift
done


if [ "<${sourceRadio}>" = "<>" ]; then
    $ECHO "FATAL: You have forgotten to select the source option (-src)"
    exit 1
fi


jobBatchName="anadrift-${sourceRadio}${dateJob}"

jobLogName="${jobBatchName}.log.$$"

qsub -P P_baoradio -l sps=1,irods=1,ct=1200,vmem=1000M,fsize=1000M -o ${PWD}/${jobLogName} -j yes -N $jobBatchName -m be -M ${LOGNAME}@lal.in2p3.fr -V <<EOF

${SCRIPTPATH}/anadriftmaker.sh  -src ${sourceRadio} ${dateSelected} ${simulationMode}
EOF
