#ifndef Const_h
#define Const_h

#include "math.h"

//////////////////////////////////////////
// Paramètres utilisés dans le logiciel //
//////////////////////////////////////////


// dimensions des tableaux

#define MAXLOG 100000
#define MAXOBJETS 1000
#define MAXETOILES 250
#define MAXANTENNES 50
#define MAXALIGNEMENTANTENNE 40
#define TAILLEMAXLOGS 3000000


// Taille maximale des chaines de caractères

#define MAXCARACTERES 1024


// Si une commande ne recoit pas d'acknowledge. Alors refaire 80 tentatives en renvoyant la commande

#define MAXATTENTE 80

// Si pas de réponse au bout de 80 tentatives -> erreur critique -> socket perdu ?

#define MAXANOMALIES 2

// attendre plus de 2 mn pour considérer qu'une antenne n'est pas en mesure de faire un goto

#define MAXANOMALIESGOTO 1500




#define NBREPASCODEURSAZ  4000


#define MINUTE_ARC 0.000290888

// valeurs des angles (exprimés en radian) ajoutés à ad et dec lorsque
// l'utilisateur agit sur les touches fléchées pendant la procédure
// d'alignement des antennes

#define PasDeltaAD 2.0 * MINUTE_ARC
#define PasDeltaDe 2.0 * MINUTE_ARC





// Hauteur minimale au-dessus de l'horizon d'un objet accessible à l'antenne
#define HAUTMIN 30.0


#define MAGNITUDEMAXETOILESCALIBRATION 3.5

// dimensions de la fenêtre graphique

#define haut_fenetre 10+22*10
#define larg_fenetre 605

//distance minimale entre deux étoiles de référence ppour les méthodes d'alignement
//AFFINE et TAKI

#define MIN_DISTANCE_ALIGNEMENT 0.3

#define NONE 0
#define SIMPLE 1
#define AFFINE 2
#define TAKI 3


//////////////////////////////
// Constantes Mathématiques //
//////////////////////////////

#define Pi		3.14159265358979323846264338327
#define Pidiv180	0.01745329251994329576923690768
#define N180divPi	57.2957795130823208767981548141
#define Pi2          	6.28318530717958647692528676655
#define Pidiv2		1.57079632679489661923132169163

#define gmax(A,B) ((A)>(B)?(A):(B))

#define gmin(A,B) ((A)<(B)?(A):(B))

/////////////////////////////////////////
// couleurs utilisées dans le terminal //
/////////////////////////////////////////


#define red1 "\033[0;31m"
#define blue1 "\033[0;34m"
#define green1 "\033[0;32m"
#define black1 "\033[0;30m"
#define grey1 "\033[1;30m"
#define red2 "\033[1;31m"
#define blue2 "\033[1;34m"
#define green2 "\033[1;32m"
#define black2 "\033[1;30m"
#define grey2 "\033[1;37m"


////////////
// Macros //
////////////

#define SAFEDELETE(pointer) if ((pointer)) { delete ((pointer)); pointer = NULL; }

#define SAFEDELETE_TAB(pointer) if ((pointer)) { delete [] ((pointer)); pointer = NULL; }


#endif
