////////////////////////////////
// Classe Logs               //
// Franck RICHARD             //
// BAORadio                   //
// franckrichard033@gmail.com //
// février 2012               //
////////////////////////////////

#include "logs.h"


Logs::Logs()
{
    ChoixCouleurs = 1;
}

Logs::~Logs()
{
}


/**************************************************************************************
** Reprise de la fonction IDLog présente dans le code d'Indi
**
***************************************************************************************/

void Logs::IDLog (const char *fmt, ...)
{
    va_list ap;
    va_start (ap, fmt);
    vfprintf (stderr, fmt, ap);
    va_end (ap);
}


/**************************************************************************************
** Retourne la longueur du fichier file
**
***************************************************************************************/

long int Logs::Taille( const std::string & file )
{
    std::ifstream fichier( file.c_str() );

    if (fichier.fail()) return 0;

    return  fichier.tellg();
}


/**************************************************************************************
** Affiche le message à l'écran (si AfficheEcran==true) et le sauvegarde dans le fichier
** BAOControl.log
***************************************************************************************/

void Logs::AfficherLog(string Message, bool AfficheEcran)
{
    static bool avertissement = false;

    FILE *pFile = NULL;

    string fichier;

    // On affiche éventuellement le message à l'écran

    if (AfficheEcran) IDLog(Message.c_str());

    fichier = "/home/" + (string)getenv("USER") + "/BAOcontrol.log";

    //Si le fichier log a une taille > 3M -> on efface le fichier

    if ( Taille(fichier) > TAILLEMAXLOGS ) remove(fichier.c_str());

    if ( (pFile = fopen(fichier.c_str(), "a")) != NULL)
    {
        time_t rawtime;
        struct tm * timeinfo;

	char buffer[80];
	
	// On sauvegarde la date et l'heure
	
        time ( &rawtime );
        timeinfo = localtime ( &rawtime );
        strftime (buffer,80,"%c    ",timeinfo);
        fprintf(pFile, buffer);
        
	// On le sauvegarde dans le fichier log

        fprintf(pFile, Message.c_str());

        fclose(pFile);
    }
    else
    {
        if (!avertissement)
        {
            ChoixCouleurs==1 ? IDLog(red1) : IDLog(red2);

            string chaine = "Impossible d'écrire dans le fichier " + fichier +"\nMerci de vérifier les permissions\n";
	    chaine += "ou exécutez le programme en mode superutilisateur.\n\n";

            IDLog(chaine.c_str());

            ChoixCouleurs==1 ? IDLog(grey1) : IDLog(grey2);

            avertissement = true;
        }
    }
}


void Logs::AfficherLog(stringstream *Message, bool AfficheEcran)
{
    AfficherLog(Message->str(), AfficheEcran);

    // on efface le buffer

    Message->str("");
}


/**************************************************************************************
** Affiche les messages d'erreur en rouge
***************************************************************************************/

void Logs::ErreurLog(string chaine)
{
    ChoixCouleurs==1 ? IDLog(red1) : IDLog(red2);

    AfficherLog(chaine, true);

    ChoixCouleurs==1 ? IDLog(grey1) : IDLog(grey2);
}

void Logs::ErreurLog(stringstream *Message)
{
    ErreurLog(Message->str());

    // on efface le buffer

    Message->str("");
}

