
// Geant4:
#include "G4ios.hh"
#include "G4RunManager.hh"
#include "G4UImanager.hh"

//AIDA :
#include <AIDA/IAnalysisFactory.h>

// std::
#include <iostream>

// Lib :
#include <Lib/Interfaces/IManager.h>
#include <Lib/System.h>
#include <Lib/Cast.h>

// G4Lab :
#include <G4Lab/UIOnX.h>
#include <G4Lab/TrackingAction.h>
#include <G4Lab/Helpers.h>
#include <G4Lab/DigitsCollectionType.h>

//MEMPHYS:
#include "MEMPHYS/MEMPHYSAnalysis.hh"
#include "MEMPHYS/MEMPHYSDetectorConstruction.hh"
#include "MEMPHYS/MEMPHYSPhysicsList.hh"
#include "MEMPHYS/MEMPHYSPhysicsMessenger.hh"
#include "MEMPHYS/MEMPHYSPrimaryGeneratorAction.hh"
#include "MEMPHYS/MEMPHYSEventAction.hh"
#include "MEMPHYS/MEMPHYSRunAction.hh"
#include "MEMPHYS/MEMPHYSStackingAction.hh"
#include "MEMPHYS/MEMPHYSTrackingAction.hh"
#include "MEMPHYS/MEMPHYSSteppingAction.hh"
#include "MEMPHYS/MEMPHYSWCDigi.hh"

// Create a manager to access the MEMPHYSAnalysis from the callbacks :

class MEMPHYSAnalysisManager 
  :public virtual IManager
  ,public MEMPHYSAnalysis  {
 public: //IManager
  virtual const std::string& name() const { return fName;}
  virtual void* cast(const std::string& aTo) const {
    if(aTo=="MEMPHYSAnalysisManager") {
      return Lib_SCast(MEMPHYSAnalysisManager);
    } else if(aTo=="MEMPHYSIAnalysis") {
      return Lib_SCast(MEMPHYSIAnalysis);
    } else if(aTo=="MEMPHYSAnalysis") {
      return Lib_SCast(MEMPHYSAnalysis);
    } else if(aTo=="IManager") {
      return Lib_SCast(IManager);
    } else {
      return 0;
    }
  }
 public:
  MEMPHYSAnalysisManager(AIDA::IAnalysisFactory& aAIDA,bool aBatch)
    :MEMPHYSAnalysis(aAIDA,aBatch),fName("MEMPHYSAnalysisManager") {}
  virtual ~MEMPHYSAnalysisManager(){}
 private:
  std::string fName;
};


//////////////////////////////////////////////////////////////////////////////
int main(
	 int aArgc
	 ,char** aArgv
	 ) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //Lib::Debug::checkByClass(true);

  G4RunManager* runManager = new G4RunManager;

  // Need to pass the G4RunManager at UIOnX creation
  std::string gui = "$MEMPHYSROOT/scripts/OnX/MEMPHYS_session.onx";
  G4Lab::UIOnX* session = new G4Lab::UIOnX(*runManager,gui,aArgc,aArgv);

  MEMPHYSAnalysisManager* analysisManager = 0;

  AIDA::IAnalysisFactory* aida = G4Lab::UIOnX_aida(*session);
  if(!aida) {
    std::cout << "MEMPHYS_session : AIDA not found." << std::endl;
  } else {
    analysisManager = new MEMPHYSAnalysisManager(*aida,false);
    session->addManager(analysisManager);
  }
  if(session->session()) {
    //GB 07/12/2005 : declare DigitsCollections types.
    //FIXME : Why can't we be generic as for hits collection ?
    //FIXME : From G4VDigiCollection, we can't loop on G4VDigi !
    session->addType
      (new G4Lab::DigitsCollectionType<MEMPHYSWCDigi>
        (*(session->session()),"WCDigitizedCollection"));
  }

  G4UImanager* UI = G4UImanager::GetUIpointer();
  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/jobOptions.mac";
    UI->ApplyCommand("/control/execute "+file);  
  }

  
  //JEC 18/11/05 give the "analysis" to fill geometry ITuple
  MEMPHYSDetectorConstruction* MEMPHYSdetector = 
    new MEMPHYSDetectorConstruction(*analysisManager); 

  runManager->SetUserInitialization(MEMPHYSdetector);

  runManager->SetUserInitialization(new MEMPHYSPhysicsList);

  // Set user action classes
  MEMPHYSPrimaryGeneratorAction* myGeneratorAction = 
    new MEMPHYSPrimaryGeneratorAction(MEMPHYSdetector);
  runManager->SetUserAction(myGeneratorAction);

  MEMPHYSRunAction* myRunAction = new MEMPHYSRunAction();

  runManager->SetUserAction(myRunAction);


  runManager->SetUserAction(new MEMPHYSEventAction(*analysisManager,
						   myRunAction, 
						   MEMPHYSdetector,
						   myGeneratorAction));
  runManager->SetUserAction(new MEMPHYSTrackingAction);

  runManager->SetUserAction(new MEMPHYSStackingAction);

  runManager->SetUserAction(new MEMPHYSSteppingAction); //JEC 15/12/05 Add user SteppingAction

  // Initialize G4 kernel
  runManager->Initialize();

  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/init.g4m";
    UI->ApplyCommand("/control/execute "+file);  
  }


  // Main UI loop :
  session->SessionStart();

  delete session; //It will delete the analysisManager.

  delete runManager;

  return 0;
}

