#ifndef MEMPHYS_Analysis_h
#define MEMPHYS_Analysis_h

// Inheritance :
#include <MEMPHYS/MEMPHYSIAnalysis.hh>

namespace AIDA {
 class IAnalysisFactory;
 class ITree;
}

#define CAST(aObject,aClass) (aClass*)(aObject)->cast(#aClass)


class MEMPHYSAnalysis  : public virtual MEMPHYSIAnalysis {
  public: //MEMPHYSIAnalysis
    virtual void closeTree();         
  public:        
    MEMPHYSAnalysis(AIDA::IAnalysisFactory&,bool aBatch = true);
    virtual ~MEMPHYSAnalysis();

    //Get tree pointer
    AIDA::ITree* tree() const {return fTree;}

  private:
    AIDA::IAnalysisFactory& fAIDA;
    bool fBatch;
    AIDA::ITree* fTree;
};


#endif
