(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     55662,       1097]
NotebookOptionsPosition[     54666,       1058]
NotebookOutlinePosition[     55008,       1073]
CellTagsIndexPosition[     54965,       1070]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", ":=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"1", "+", 
        RowBox[{"0.005", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"3", "*", 
           RowBox[{"(", 
            RowBox[{"x", "-", "1414.5"}], ")"}]}], "]"}]}], "+", 
        RowBox[{"0.001", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"20", "*", 
           RowBox[{"(", 
            RowBox[{"x", "-", "1414.5"}], ")"}]}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1400", ",", "1420", ",", "0.03"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5376197697212934`*^9, 3.5376198777046833`*^9}, {
  3.5376199279835715`*^9, 3.5376200384473658`*^9}, {3.5376343828736877`*^9, 
  3.5376343934349065`*^9}, {3.5376365165957327`*^9, 3.537636550806593*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"data2", " ", ":=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"1", "+", 
         RowBox[{"0.001", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"20", "*", 
            RowBox[{"(", 
             RowBox[{"x", "-", "1414.5"}], ")"}]}], "]"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1400", ",", "1420", ",", "0.03"}], "}"}]}], "]"}]}],
    ";"}]}]], "Input",
 CellChangeTimes->{{3.5376200630330086`*^9, 3.5376201071810865`*^9}, {
  3.5376343967733126`*^9, 3.5376344008137197`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"data", ",", "data2"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.5376198813706894`*^9, 3.537619894895913*^9}, {
  3.5376200820494423`*^9, 3.5376201180075054`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw92mVYlPnDBeCRobtBFDEwsGttYew1/oIFCoqNhbEu6FqIYoJgIGMnrLIK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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxF2nlczGv7B/CZZiwhJEviyJJDOLJFUqeRYy9EISWkkFAcW9ailFCoGSF7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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1400., 0.994},
  PlotRange->{{1400., 1419.98}, {0.9940182799292159, 1.0059853336798443`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5376198955823145`*^9, {3.5376199394183917`*^9, 3.5376200413489704`*^9}, {
   3.5376200886638536`*^9, 3.537620118647106*^9}, 3.537634404573326*^9, {
   3.537636539886574*^9, 3.5376365539421988`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Mean", ",", 
   RowBox[{"{", 
    RowBox[{"data", ",", "data2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.537620150346362*^9, 3.537620194182439*^9}, {
  3.5376202348829107`*^9, 3.537620237254115*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1414.99`", ",", "1.0000416770750562`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1414.99`", ",", "0.9999824324794178`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5376201552915707`*^9, 3.537620195056041*^9}, 
   3.5376202382525167`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Map", "[", 
   RowBox[{"Skewness", ",", 
    RowBox[{"{", 
     RowBox[{"data", ",", "data2"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5376203241930676`*^9, 3.5376204269972477`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.090680565577134`*^-14"}], ",", 
     RowBox[{"-", "0.056768481597168886`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.090680565577134`*^-14"}], ",", "0.02995609546848659`"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.537620330604679*^9, 3.5376203532715187`*^9}, 
   3.537620391725586*^9, 3.5376204276368494`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"QuartileSkewness", ",", 
   RowBox[{"{", 
    RowBox[{"data", ",", "data2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.537620569472298*^9, 3.5376205736999054`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "0.0019594049179106243`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.12381052683115445`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5376205744955072`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Moment", "[", 
  RowBox[{"data", ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.537620616662381*^9, 3.5376206419188256`*^9}, {
  3.537620796405897*^9, 3.537620834095563*^9}, {3.537620869991226*^9, 
  3.5376208978216753`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.8330897375314007`*^9", ",", "1.0001264701349102`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.5376206425428267`*^9, 3.537620834657164*^9, {3.537620889850061*^9, 
   3.5376208982740755`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5376339299845085`*^9, 3.537633930452509*^9}, {
  3.5376339622141647`*^9, 3.537633962806966*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"Fourier", "[", 
        RowBox[{"data", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}], "]"}], "^", "2"}], 
     ",", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"Fourier", "[", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}], "]"}], "^", "2"}]}],
     "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "100"}], "}"}], ",", "All"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5376340100242467`*^9, 3.5376340477467117`*^9}, {
  3.537634252387062*^9, 3.537634356166441*^9}, {3.5376346008402443`*^9, 
  3.537634613632267*^9}, {3.5376348926421256`*^9, 3.537634920003373*^9}, {
  3.5376350898846464`*^9, 3.53763510915308*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdWnlUU+f2jVqVWpXoE0TUNqIoDkicERWPijJLAAcUxAAyT0lIyJzcDCgi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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxdWnl4jGf7HbQV+1BLkNRYQqjUoKnYjyUSaSKDiCSyTPZVMslMkplJZvLO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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -21.589665385393605`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  FrameTicks->{{{{-20.72326583694641, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-16.11809565095832, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-6.907755278982137, 
       FormBox["0.001`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {-18.238359187158412`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.58777162101726, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.196905312330248`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.916603347176093`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.69791414621126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.518573217555446`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.36655701025682, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.234629467214273`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.633189001170319`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.98260143502917, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.591735126342158`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.311433161188, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.09274396022317, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.913403031567354`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.761386824268728`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.62945928122618, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.028018815182229, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.377431249041079, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.986564940354067, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.706262975199909, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.487573774235079, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.308232845579262, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.156216638280637, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.024289095238088, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.422848629194137, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.7722610630529876`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.3813947543659757`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.101092789211817, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.882403588246988, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.703062659591171, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.551046452292545, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.419118909249997, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.1823215567939546, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.8329091229351039, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.2237754316221159`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.5040773967762742`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.7227665977411037`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9021075263969205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0541237336955462`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.186051276738094, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.787491742782046, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.438079308923196, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.8289456176102075`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.1092475827643655`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.327936783729195, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.507277712385012, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.659293919683638, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.7912214627261855`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-20.72326583694641, 
       FormBox["\"\"", TraditionalForm]}, {-16.11809565095832, 
       FormBox["\"\"", TraditionalForm]}, {-11.512925464970229`, 
       FormBox["\"\"", TraditionalForm]}, {-6.907755278982137, 
       FormBox["\"\"", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["\"\"", TraditionalForm]}, {2.302585092994046, 
       FormBox["\"\"", TraditionalForm]}, {6.907755278982137, 
       FormBox["\"\"", TraditionalForm]}, {-18.238359187158412`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.58777162101726, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.196905312330248`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.916603347176093`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.69791414621126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.518573217555446`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.36655701025682, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.234629467214273`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.633189001170319`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.98260143502917, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.591735126342158`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.311433161188, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.09274396022317, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.913403031567354`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.761386824268728`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.62945928122618, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.028018815182229, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.377431249041079, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.986564940354067, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.706262975199909, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.487573774235079, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.308232845579262, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.156216638280637, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.024289095238088, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.422848629194137, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.7722610630529876`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.3813947543659757`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.101092789211817, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.882403588246988, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.703062659591171, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.551046452292545, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.419118909249997, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.1823215567939546, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.8329091229351039, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.2237754316221159`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.5040773967762742`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.7227665977411037`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9021075263969205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0541237336955462`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.186051276738094, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.787491742782046, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.438079308923196, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.8289456176102075`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.1092475827643655`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.327936783729195, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.507277712385012, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.659293919683638, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.7912214627261855`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  ImageSize->{502., Automatic},
  Method->{},
  PlotRange->{{0, 100}, {-21.589665385393605`, 6.503066350334783}},
  PlotRangeClipping->True,
  PlotRangePadding->{{None, None}, 
    Scaled[0.02]},
  Ticks->{Automatic, {{-20.72326583694641, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-16.11809565095832, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-11.512925464970229`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-6.907755278982137, 
      FormBox["0.001`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {2.302585092994046, 
      FormBox["10", TraditionalForm]}, {6.907755278982137, 
      FormBox["1000", TraditionalForm]}, {-18.238359187158412`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-17.58777162101726, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-17.196905312330248`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.916603347176093`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.69791414621126, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.518573217555446`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.36655701025682, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.234629467214273`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-13.633189001170319`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.98260143502917, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.591735126342158`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.311433161188, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.09274396022317, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.913403031567354`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.761386824268728`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.62945928122618, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.028018815182229, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-8.377431249041079, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.986564940354067, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.706262975199909, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.487573774235079, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.308232845579262, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.156216638280637, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.024289095238088, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.422848629194137, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.7722610630529876`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.3813947543659757`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.101092789211817, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.882403588246988, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.703062659591171, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.551046452292545, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.419118909249997, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.1823215567939546, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.8329091229351039, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.2237754316221159`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.5040773967762742`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.7227665977411037`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9021075263969205`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0541237336955462`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.186051276738094, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.787491742782046, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.438079308923196, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {5.8289456176102075`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {6.1092475827643655`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {6.327936783729195, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {6.507277712385012, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {6.659293919683638, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {6.7912214627261855`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{
  3.5376340484799128`*^9, {3.5376342572386703`*^9, 3.5376342850583177`*^9}, {
   3.5376343189315767`*^9, 3.537634356696842*^9}, 3.5376344107353373`*^9, 
   3.537634614069068*^9, {3.537634899143337*^9, 3.5376349211265745`*^9}, {
   3.5376351003234644`*^9, 3.5376351099174814`*^9}, 3.537636572789031*^9}]
}, Open  ]]
},
WindowSize->{707, 637},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 882, 23, 52, "Input"],
Cell[1442, 45, 651, 18, 52, "Input"],
Cell[CellGroupData[{
Cell[2118, 67, 240, 5, 31, "Input"],
Cell[2361, 74, 17473, 293, 237, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19871, 372, 255, 6, 31, "Input"],
Cell[20129, 380, 320, 9, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20486, 394, 251, 6, 52, "Input"],
Cell[20740, 402, 440, 12, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21217, 419, 218, 5, 31, "Input"],
Cell[21438, 426, 280, 8, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21755, 439, 253, 5, 31, "Input"],
Cell[22011, 446, 236, 6, 33, "Output"]
}, Open  ]],
Cell[22262, 455, 145, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[22432, 461, 965, 28, 52, "Input"],
Cell[23400, 491, 31250, 564, 318, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
