#include "machdefs.h"

//---- System et stdc++ include files
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <iostream>
#include <fstream>
#include <complex>

#include <typeinfo>
#include <string>
#include <vector>
#include <map>
#include <functional>
#include <list>

//---- Sophya include files
#include "sopnamsp.h"
#include "basetools.h"
#include "systools.h"
#include "sutils.h"
#include "ntools.h"
#include "array.h"
#include "histats.h"

//---- Spiapp include files
#include "nobjmgr.h"
#include "servnobjm.h"

//---- Include files from additionnal modules

//---- function to compare bits on double 
int_8 BitCmp64(double v,int_8 flg) 
{return ((int_8)((v<0.) ? v-0.1 : v+0.1))&flg;} 

//---- function for Adding and displaying Objects  
void Keep_Object(AnyDataObj & obj, string const & nom) 
{ 
  string name = nom; 
  NamedObjMgr om; 
  if (om.GetObj(name)) 
    cerr << "KeepObj()/Warning Already kept object " << endl; 
  else om.AddObj(obj, name); 
} 

void Display_Object(AnyDataObj & obj, string const & opt, string const & nom) 
 { 
  string name = nom; 
  NamedObjMgr om; 
  if (!om.GetObj(name)) 
    om.AddObj(obj, name); 
  om.DisplayObj(name, opt); 
} 

//---- function for getting and setting ObjectManager variables  
void Set_ObjMgrVar(MuTyV v, string const & nom) 
{ 
  NamedObjMgr om; 
  om.SetVar(nom, (string)v); 
} 

MuTyV Get_ObjMgrVar(const char * nom) 
{ 
  string name = nom; NamedObjMgr om; 
  MuTyV v = om.GetVar(name); 
  return v; 
} 

//---- Macro for Objects and variables saving
#define KeepObj(obj) Keep_Object(obj, #obj)
#define GetOMVar(var) Get_ObjMgrVar( #var )
#define SetOMVar(var) Set_ObjMgrVar(var, #var )

//---- Macro Displaying objects and command execution
#define DispObj(obj, att) Display_Object(obj, att, #obj); 

#define ExecCmd(cmd) srvo.ExecuteCommand(cmd); 



//-------------------------------------------------//
//----------------- User Functions ----------------//
//-------------------------------------------------//

extern "C" {
  int meanoffset( vector<string>& args );
}

int meanoffset( vector<string>& args )
{
// Some definitions to help using spiapp;
NamedObjMgr omg;
Services2NObjMgr& srvo = *omg.GetServiceObj();

//-------------- Object List --------------
//Number of objects = 1
string ___nomobj;

___nomobj = "inarr";
TVector< r_4 > * ___inarr = dynamic_cast< TVector< r_4 >  * >(omg.GetObj(___nomobj));
if(___inarr==NULL) throw NullPtrError("CxxExecutor::PutObject: Non existing object inarr... please update file");
TVector< r_4 > & inarr = (*___inarr);


//--------------------------------------------//
//----------------- User Code ----------------//
//--------------------------------------------//
//#include "/home/bao/tmp/PIATmp_iAIt8R/cxx_spiapp.h"
//extract from input array 2 bands [fMin1st,fMax1st] U [fMin2nd,fMax2nd]
 
 sa_size_t fMin1st = (sa_size_t)inarr.NElts()*(atof(args[0].data())-1250.)/250.;
 sa_size_t fMax1st = (sa_size_t)inarr.NElts()*(atof(args[1].data())-1250.)/250.;
 sa_size_t fMin2nd = (sa_size_t)inarr.NElts()*(atof(args[2].data())-1250.)/250.;
 sa_size_t fMax2nd = (sa_size_t)inarr.NElts()*(atof(args[3].data())-1250.)/250.;


 TVector<r_4> outarr1(inarr.SubVector(Range(fMin1st,fMax1st)),false);
 TVector<r_4> outarr2(inarr.SubVector(Range(fMin2nd,fMax2nd)),false);
 
 r_4 mean1 = outarr1.Sum()/outarr1.NElts();
 r_4 mean2 = outarr2.Sum()/outarr2.NElts();
 
 r_4 mean = (mean1+mean2)/2.;
 
 TVector<r_4> outarr(inarr,false);
 outarr -= mean;

 KeepObj(outarr);


 return 0;
}
