(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     42218,       1151]
NotebookOptionsPosition[     37582,        986]
NotebookOutlinePosition[     38003,       1002]
CellTagsIndexPosition[     37960,        999]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  "\"\<E:\\\\Presentations\\\\BAO\\\\Amas 21cm\\\\Abell2440\>\"", 
  "]"}]], "Input",
 CellChangeTimes->{{3.510485086467894*^9, 3.510485118692116*^9}}],

Cell[BoxData["\<\"E:\\\\Presentations\\\\BAO\\\\Amas 21cm\\\\Abell2440\"\>"], \
"Output",
 CellChangeTimes->{3.5105689779304667`*^9, 3.5105690348801613`*^9, 
  3.511064938384456*^9, 3.5110657060580034`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Debut et fin des plateaux de DAB", "Section"]], \
"Section",
 CellChangeTimes->{{3.511065442593546*^9, 3.511065494257103*^9}, 
   3.5110655637914*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"lower1", " ", "=", " ", "21"}], ";"}]], "Input",
 CellChangeTimes->{{3.5105688470383787`*^9, 3.510568855485224*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"upper1", " ", "=", " ", "35"}], ";"}]], "Input",
 CellChangeTimes->{{3.510568859069582*^9, 3.51056886365204*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"lower2", " ", "=", " ", "38"}], ";"}]], "Input",
 CellChangeTimes->{{3.5105688666353383`*^9, 3.510568880539729*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"upper2", "=", "51"}], ";"}]], "Input",
 CellChangeTimes->{{3.5105688824399185`*^9, 3.510568887863461*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Calibration 1280 MHZ", "Section"]], "Section",
 CellChangeTimes->{{3.5110655004498663`*^9, 3.5110655155652*^9}, 
   3.5110655553679943`*^9, 3.5110655958003426`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"calv0", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"\"\<calibv01280.txt\>\"", ",", "\"\<Table\>\""}], "]"}], ",", 
      "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.510485126860933*^9, 3.5104851547187185`*^9}, {
  3.510485210853331*^9, 3.5104852183190775`*^9}, {3.510568257000381*^9, 
  3.510568276243305*^9}, {3.5105683234930296`*^9, 3.5105683261923*^9}, {
  3.5105683755972395`*^9, 3.510568377628443*^9}, {3.5105689538710613`*^9, 
  3.510568956222296*^9}, {3.510569023660039*^9, 3.5105690240910826`*^9}, {
  3.511064999755643*^9, 3.5110650004264517`*^9}, {3.5110653389332542`*^9, 
  3.5110653450324244`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"calv0", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.510485159057152*^9, 3.510485166604907*^9}, {
  3.510485226189865*^9, 3.510485240596305*^9}, {3.510568473122991*^9, 
  3.5105685426859465`*^9}, {3.51056858732241*^9, 3.5105686369613733`*^9}, {
  3.510568669384615*^9, 3.5105687303767138`*^9}, {3.510568794084084*^9, 
  3.5105688198266582`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd03lIk3Ecx/FpYynZQU3zKDzSeXaY97mPx+Y9t/DIpMI0KqNCbHmkMiMi
O8SjaTVIKFTMUhGsSLN1mZSSClpqmtlMJWUqmEepFT7f/dEDDw+v5/38fs/B
7zE/cmbfUW0WiyX8u/87rm5TfB8bG4H9nJrPnIC0LaOlWUXWwYGpu7Vm7eRN
GBPVrXg+JnNhkS9NMVk/xdgQIvXw0pMl6tsQrztgldJDNoOXS6mJ3izZAtf9
i+KevSJbQlq3/CGhmcyDPGl7fk0X2QbJTWeLDdl0Pzu8n58z2rqB7IDUpw48
V1PyLvSmCaae65P3QJ4dy17pp/kc8WVoXXGVNvW9YLcscnia93P673s4Yzqx
7WBY62/GLhifPq9YfqCNVbuiQ3ElylBBdkNTScHGzEdkdyiiy6of3iR7QNqu
UpyqIXuib1ku55WTvVDgmLbTvIzsjUZFpaeqguyDF6nqr0X3yL5gm8cp2Zr5
+Mitt41NLyUD4XmWmUZvGMsAh2Ang4hK6n7g8ls+N7ym7oeJAVN1dDV1f6TN
n6wXZlP3RzdbMqcVTD0AjTNxd9a6UQ9AZ0mqbY0d9UBsyakqc4umHgjbDGm+
Vhx1AWb0jBet3akL0F/5zXENXc8SImvylpVWMnUhpNq3dUwOUQ/CO/3BEQtf
6kEoXSnI+eVJPRifGvmD1THUg3Gt+YJzooR6CH4Muxor46mHwCahYvKw5vlC
cbxwMosvpR4KTq484OrET2Y9hKEp437AaQ6znmRhGBEWNlzSrN9wnGhNvxE6
z1gWjkw3Ay5nhHoERlUC3tBH6hFoWVCIL7NofYrQ48FJqqX/VSbCZkerojHN
+Eh0RUV+N6X/TxaJhVAzq3OT1MXosJ6xHDdm5oMYUW/tyo8t0vVidMZ7N40q
GSvF4Jako5dL95dAMNujjNGl8RLk2RYG7t5B7yuB/cXu/S/71Pw/w1M4/Q==

    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, Automatic},
  PlotRange->{All, {0, 4}},
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{
  3.510568543339012*^9, {3.510568593199998*^9, 3.5105686374844255`*^9}, {
   3.5105686742290993`*^9, 3.5105687307887554`*^9}, {3.5105687969993753`*^9, 
   3.5105688202857037`*^9}, 3.5105689783645105`*^9, 3.510569035179191*^9, 
   3.5110650041548996`*^9, 3.511065706385597*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"level0", " ", "=", " ", 
  RowBox[{"Median", "[", 
   RowBox[{"calv0", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "lower1"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5110650299108295`*^9, 3.511065084152725*^9}}],

Cell[BoxData["0.998663`"], "Output",
 CellChangeTimes->{{3.511065060034816*^9, 3.511065085806346*^9}, 
   3.511065706432396*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"firstPlateauV0", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv0", "[", 
     RowBox[{"[", 
      RowBox[{"lower1", ";;", "upper1"}], "]"}], "]"}], "]"}], "-", 
   "level0"}]}]], "Input",
 CellChangeTimes->{{3.5104853309903436`*^9, 3.510485459518195*^9}, {
  3.5105684434050198`*^9, 3.5105684489285717`*^9}, {3.5105685562363014`*^9, 
  3.5105686094556227`*^9}, {3.510568892881963*^9, 3.510568899942669*^9}, {
  3.511065099160117*^9, 3.5110651019681535`*^9}}],

Cell[BoxData["1.333027`"], "Output",
 CellChangeTimes->{3.5104854048187256`*^9, 3.510485460199263*^9, 
  3.510485759516192*^9, 3.5105682912378044`*^9, 3.5105683412928095`*^9, 
  3.510568393279008*^9, 3.510568641949872*^9, 3.5105689139200664`*^9, 
  3.510568978415515*^9, 3.510569035216195*^9, 3.5110651035125732`*^9, 
  3.5110657064635954`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"secondPlateauV0", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv0", "[", 
     RowBox[{"[", 
      RowBox[{"lower2", ";;", "upper2"}], "]"}], "]"}], "]"}], "-", 
   "level0"}]}]], "Input",
 CellChangeTimes->{{3.510485466973941*^9, 3.510485503540597*^9}, {
  3.510485745583799*^9, 3.5104857458898296`*^9}, {3.5105686462232995`*^9, 
  3.5105686574044175`*^9}, {3.5105686914878254`*^9, 3.510568714078084*^9}, {
  3.510568903906065*^9, 3.510568909599634*^9}, {3.511065108099032*^9, 
  3.5110651126854906`*^9}}],

Cell[BoxData["1.292897`"], "Output",
 CellChangeTimes->{
  3.5104855048687296`*^9, 3.510485749006141*^9, 3.5105682912768087`*^9, 
   3.5105683413138113`*^9, 3.5105683933020096`*^9, {3.5105687099826746`*^9, 
   3.5105687148391604`*^9}, 3.510568916197294*^9, 3.5105689784595194`*^9, 
   3.510569035237197*^9, 3.5110651134031*^9, 3.511065706479195*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefV0", " ", "=", " ", 
  RowBox[{"0.5", 
   RowBox[{"(", 
    RowBox[{"firstPlateauV0", "+", "secondPlateauV0"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5104855275750003`*^9, 3.510485554926735*^9}, {
  3.510485751407381*^9, 3.5104857516414046`*^9}}],

Cell[BoxData["1.312962`"], "Output",
 CellChangeTimes->{
  3.510485555287771*^9, {3.510485752134454*^9, 3.5104857636606064`*^9}, 
   3.5105682912988105`*^9, 3.5105683413358135`*^9, 3.510568393325012*^9, 
   3.5105687422469006`*^9, 3.510568978481522*^9, 3.510569035259199*^9, 
   3.511065117911558*^9, 3.5110657065103946`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"calv1", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"\"\<calibv11280.txt\>\"", ",", "\"\<Table\>\""}], "]"}], ",", 
      "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.510485582467489*^9, 3.5104855859028325`*^9}, {
  3.51056826929161*^9, 3.5105682788805685`*^9}, {3.5105683296836486`*^9, 
  3.5105683317928596`*^9}, {3.51056838190487*^9, 3.510568385624242*^9}, {
  3.510568962172891*^9, 3.5105689658952637`*^9}, {3.510569029622636*^9, 
  3.5105690299226656`*^9}, {3.5110651299705124`*^9, 3.5110651304385185`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"calv1", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.510485598649107*^9, 3.5104855988751297`*^9}, {
  3.510568802164892*^9, 3.5105688243971148`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw9kwss1VEcx/8pr4kuuZ5pWJqZ5HVv3r7X+3E9e0wxQ5MepNF6THIZG5ml
EGmsWLMs7jLKo5K4pBlRUYq6XrMeKF2l1W6a/++e7ezscz7n9zuP/Y5ZQmpk
ohLDMH5r/f+43pY8nUclKY5rIzsBbb7bo0g9YjWsLFz+Wc8l5sBYxilaMCXW
RYeo3JD/fJFlA+QUcnkVKuS3gaNSnbFFn9gUE+UO77i/ab05Or+1JF3bRH4H
dGQ5Yenfye8EX6WK4zJPbImSqemtTcvEVuh4EVN3RXFea8jnJAXiFfI26JUO
iOcU97PFg2FmUkmd2A5KN9KXhIr89uA0irzc/xI7QD4U//ihIt4R6JJcMhpY
ZZmHP7yDtdtr5CzzYTQh+CK8RbwHY/rqKc7lxE6wvztVNFBL7Iy8s235iz3E
LrjQOtO6t53YFfOT3RZ9VcRuqK6QJVjWEbsj14qXcbOM2AOdmSZOSYp8npj9
qlanLCYGpBold3KGWRatXaeh43x9N3kB4pPNngkKyAuQd/1+VuJt8l7ozi62
jlNisO69UKlmXB17jGXGG79ONPm5+5D3hkejJnfajbwPVGS70tuTyfvgA7dL
fiCNvC9KQ9qedsSQ90WqZnJZnB15P4i0lmeVo8j7obeOMRiKI++PkFzNMPE+
8v5wra80/eRBPgA8watMJpJ8AFQHDSPGo8kHwolzVVlI+USBGMwfmfwYTD4I
GeNScf8h8kF4Hb0x2uKNjH2fYDj7+qetbmHrRRSMzaW6UcxLqichWroK5sdG
WRYJcWq4P/Kzot5CIEWAnu0Gig/B6YzAw81aVH+hyAoVXOTT/xCFQn7mrdh1
guLD8F47VCP2B/kwSC2cZNkz5MPRbH68ZqiPZYRjtLi1b0SV9gtHzz2bk7W0
/5NwlJgYZ59T5I9A4dT+Ub6E4iOQ0rBbZ1xxnggcOeqm3bO66PkPUqJFVg==

    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, Automatic},
  PlotRange->{All, {0, 4}},
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{
  3.5104855992771697`*^9, 3.510568291350816*^9, 3.510568341382818*^9, 
   3.5105683933710165`*^9, {3.5105688140000753`*^9, 3.510568824869162*^9}, 
   3.5105689785275264`*^9, 3.510569035306204*^9, 3.5110651353369813`*^9, 
   3.5110657065571938`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"level1", " ", "=", " ", 
  RowBox[{"Median", "[", 
   RowBox[{"calv0", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "lower1"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.511065150219572*^9, 3.5110651582848754`*^9}}],

Cell[BoxData["0.998663`"], "Output",
 CellChangeTimes->{3.511065159049285*^9, 3.511065706588393*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"firstPlateauV1", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv1", "[", 
     RowBox[{"[", 
      RowBox[{"lower1", ";;", "upper1"}], "]"}], "]"}], "]"}], "-", 
   "level1"}]}]], "Input",
 CellChangeTimes->{{3.5104856456538067`*^9, 3.5104856850247436`*^9}, {
  3.510568752023878*^9, 3.5105687663173075`*^9}, {3.5105689197226467`*^9, 
  3.5105689337120457`*^9}, {3.5110651629805355`*^9, 3.511065164478155*^9}}],

Cell[BoxData["0.9792170000000001`"], "Output",
 CellChangeTimes->{{3.5104856655577974`*^9, 3.510485685530794*^9}, 
   3.510568291380819*^9, 3.5105683414188223`*^9, 3.5105683934040203`*^9, 
   3.510568767270403*^9, 3.5105689347901535`*^9, 3.51056897856353*^9, 
   3.5105690353422074`*^9, 3.5110651654297667`*^9, 3.5110657066039925`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"secondPlateauV1", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv1", "[", 
     RowBox[{"[", 
      RowBox[{"lower2", ";;", "upper2"}], "]"}], "]"}], "]"}], "-", 
   "level1"}]}]], "Input",
 CellChangeTimes->{{3.5104856974139824`*^9, 3.5104857138706284`*^9}, {
  3.5105687714528213`*^9, 3.5105687850551815`*^9}, {3.5105689411467886`*^9, 
  3.5105689462793016`*^9}, {3.5110651685810075`*^9, 3.5110651703126297`*^9}}],

Cell[BoxData["1.0435019999999997`"], "Output",
 CellChangeTimes->{3.510485714809722*^9, 3.5105682914028206`*^9, 
  3.5105683414388237`*^9, 3.510568393425022*^9, 3.5105687860472803`*^9, 
  3.5105689467363477`*^9, 3.510568978585532*^9, 3.5105690353652096`*^9, 
  3.5110651709834385`*^9, 3.511065706635192*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefV1", " ", "=", " ", 
  RowBox[{"0.5", 
   RowBox[{"(", 
    RowBox[{"firstPlateauV1", "+", "secondPlateauV1"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.510485724914732*^9, 3.510485738382079*^9}}],

Cell[BoxData["1.0113595`"], "Output",
 CellChangeTimes->{{3.5104857311753583`*^9, 3.510485738956136*^9}, 
   3.510568291422823*^9, 3.510568341459826*^9, 3.510568393445024*^9, 
   3.5105689786065345`*^9, 3.510569035386212*^9, 3.5110651734950705`*^9, 
   3.511065706650792*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calibration 1380 MHZ", "Section",
 CellChangeTimes->{{3.511065608295062*^9, 3.511065621538829*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"calv0", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"\"\<calibv01380.txt\>\"", ",", "\"\<Table\>\""}], "]"}], ",", 
      "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.510485126860933*^9, 3.5104851547187185`*^9}, {
  3.510485210853331*^9, 3.5104852183190775`*^9}, {3.510568257000381*^9, 
  3.510568276243305*^9}, {3.5105683234930296`*^9, 3.5105683261923*^9}, {
  3.5105683755972395`*^9, 3.510568377628443*^9}, {3.5105689538710613`*^9, 
  3.510568956222296*^9}, {3.510569023660039*^9, 3.5105690240910826`*^9}, {
  3.511064999755643*^9, 3.5110650004264517`*^9}, {3.5110653389332542`*^9, 
  3.511065370240247*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"calv0", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.510485159057152*^9, 3.510485166604907*^9}, {
  3.510485226189865*^9, 3.510485240596305*^9}, {3.510568473122991*^9, 
  3.5105685426859465`*^9}, {3.51056858732241*^9, 3.5105686369613733`*^9}, {
  3.510568669384615*^9, 3.5105687303767138`*^9}, {3.510568794084084*^9, 
  3.5105688198266582`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw91H8s1HEcx3E/b8rmyo92kzi/bkLmZ5Qf9zqHO7/OIb8y/XFHP/QHa4jV
dGrK1BRRmV9h149Z8mNx5GeMfulmmCylRaVfkhprNTq5t+/23XeP7/P73T7f
fd/fr6UkLSpFS0NDI0i1rx83tkVuXGJz71fzRa76BApCi7zl2mQ9FHQykWpE
3oackoyRuZ1kY/QpFelsGzILB2blFYNsshnml0uGju4is6F0fiA3WPquthVO
uE3LlEzqNuhfi22RWpM5sGXklfH1yXb47ag899CNbI+VzLeV223Jjmg7ck3n
zm6yE3qcy+1ZJmRnNGRb/3xsQXbBuDD0/Tc9sitGMk2P3fUhuyG1/2LPWXey
O1KGg9iHJv+q7YElnvLwxG0tbHgv8svbzqTIyZ4o+PVqMq+V7IXV8exPnGby
PihFDMGTBvJ+cKJ160s6yd5gVJ9iXq8k+2Bti1Ps+E2yL24xk8QzLWQ/JNSb
141WkbkYljLsZ2vIQKBh9yVJh9oyYM5Fu+zHfeo8SPb46fYpqPMwVGgaNtBE
3R/nY7qKc5Kp++P1jeqmwQFNdedDO9E23qxIbRkfmkaKTM/L1AMQ/5F1pbua
egAax1Qv4B71QEhHM7JcFdQD4ZubNlbTTT0ImCp16HpGPQhZqtcv3+wCfE78
kJHwnLoAF3o5x8c31yeExCQt2byDuhBX49YXRD0YhRbShYOPqAcjijk6b1BH
PQRl7daVO7qoh2DqxUr0rHxZPQ+heMc4ncuyVM+LLBTRxVul+jyan7CN5/Oi
HoZ21bQEb85rODz+X0A9HBMc0cJJO+oiVHh1zNSSZSLwdcz8y0ypR8DhT6Pe
qif1CAwIBkuFVtTFSHvZZtdK64EYb7JqO0T0vcnEsKjqXEqg/0GfGOl6ManL
oPsjYZH/JVJBHZFIKmx42uNA90fC0Jg7NO2xyP0H0qsx1Q==
    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, Automatic},
  PlotRange->{All, {0, 4}},
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{
  3.510568543339012*^9, {3.510568593199998*^9, 3.5105686374844255`*^9}, {
   3.5105686742290993`*^9, 3.5105687307887554`*^9}, {3.5105687969993753`*^9, 
   3.5105688202857037`*^9}, 3.5105689783645105`*^9, 3.510569035179191*^9, 
   3.5110650041548996`*^9, 3.511065706713191*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"level0", " ", "=", " ", 
  RowBox[{"Median", "[", 
   RowBox[{"calv0", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "lower1"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5110650299108295`*^9, 3.511065084152725*^9}}],

Cell[BoxData["1.00776`"], "Output",
 CellChangeTimes->{{3.511065060034816*^9, 3.511065085806346*^9}, 
   3.5110657067287903`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"firstPlateauV0", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv0", "[", 
     RowBox[{"[", 
      RowBox[{"lower1", ";;", "upper1"}], "]"}], "]"}], "]"}], "-", 
   "level0"}]}]], "Input",
 CellChangeTimes->{{3.5104853309903436`*^9, 3.510485459518195*^9}, {
  3.5105684434050198`*^9, 3.5105684489285717`*^9}, {3.5105685562363014`*^9, 
  3.5105686094556227`*^9}, {3.510568892881963*^9, 3.510568899942669*^9}, {
  3.511065099160117*^9, 3.5110651019681535`*^9}}],

Cell[BoxData["1.3281500000000002`"], "Output",
 CellChangeTimes->{3.5104854048187256`*^9, 3.510485460199263*^9, 
  3.510485759516192*^9, 3.5105682912378044`*^9, 3.5105683412928095`*^9, 
  3.510568393279008*^9, 3.510568641949872*^9, 3.5105689139200664`*^9, 
  3.510568978415515*^9, 3.510569035216195*^9, 3.5110651035125732`*^9, 
  3.5110657067599897`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"secondPlateauV0", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv0", "[", 
     RowBox[{"[", 
      RowBox[{"lower2", ";;", "upper2"}], "]"}], "]"}], "]"}], "-", 
   "level0"}]}]], "Input",
 CellChangeTimes->{{3.510485466973941*^9, 3.510485503540597*^9}, {
  3.510485745583799*^9, 3.5104857458898296`*^9}, {3.5105686462232995`*^9, 
  3.5105686574044175`*^9}, {3.5105686914878254`*^9, 3.510568714078084*^9}, {
  3.510568903906065*^9, 3.510568909599634*^9}, {3.511065108099032*^9, 
  3.5110651126854906`*^9}}],

Cell[BoxData["1.208715`"], "Output",
 CellChangeTimes->{
  3.5104855048687296`*^9, 3.510485749006141*^9, 3.5105682912768087`*^9, 
   3.5105683413138113`*^9, 3.5105683933020096`*^9, {3.5105687099826746`*^9, 
   3.5105687148391604`*^9}, 3.510568916197294*^9, 3.5105689784595194`*^9, 
   3.510569035237197*^9, 3.5110651134031*^9, 3.51106570677559*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefV0", " ", "=", " ", 
  RowBox[{"0.5", 
   RowBox[{"(", 
    RowBox[{"firstPlateauV0", "+", "secondPlateauV0"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5104855275750003`*^9, 3.510485554926735*^9}, {
  3.510485751407381*^9, 3.5104857516414046`*^9}}],

Cell[BoxData["1.2684325`"], "Output",
 CellChangeTimes->{
  3.510485555287771*^9, {3.510485752134454*^9, 3.5104857636606064`*^9}, 
   3.5105682912988105`*^9, 3.5105683413358135`*^9, 3.510568393325012*^9, 
   3.5105687422469006`*^9, 3.510568978481522*^9, 3.510569035259199*^9, 
   3.511065117911558*^9, 3.5110657068067884`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"calv1", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"\"\<calibv11380.txt\>\"", ",", "\"\<Table\>\""}], "]"}], ",", 
      "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.510485582467489*^9, 3.5104855859028325`*^9}, {
  3.51056826929161*^9, 3.5105682788805685`*^9}, {3.5105683296836486`*^9, 
  3.5105683317928596`*^9}, {3.51056838190487*^9, 3.510568385624242*^9}, {
  3.510568962172891*^9, 3.5105689658952637`*^9}, {3.510569029622636*^9, 
  3.5105690299226656`*^9}, {3.5110651299705124`*^9, 3.5110651304385185`*^9}, {
  3.511065374420752*^9, 3.5110653747795267`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"calv1", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.510485598649107*^9, 3.5104855988751297`*^9}, {
  3.510568802164892*^9, 3.5105688243971148`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw9k30s1HEcx48esM5Kbp7NOZbzOJ0Qjns7z893+IdUm6LRYq2b6clu7Cix
iPpL5SqReWqlSOjIiilPy8o8j6Ri8lC4TWnuc7/tt99ev9f3833Y9/2xTEyP
TtJkMBiB2+//786zJEiI171+2WFJoPqBPbk1aWtmxNqoC5q6xHIiPoCf4fIV
Ey9iFkx1Jx2L2MRGqClaLkm1IDZDU/2uuQIuMRsbDn05LS7EHJTmyeKH+MTW
uDeo2BRoER9Co/t6x2k7Yi4KuQu6bc7Edli8InA94UnsgL1rjhdeqc/jhJXY
vFGmO7EzlBJ+cjmP+DA++ZjfNFbvjwd+Tu6Wjvq8LghZ5eXPGhAfwftGeWJZ
+4aKXREnzkkxavurYjekbT6zsH1A7I6J9RGXME0GdvgoTi3GC32+kffApJzb
b7NM7AnbOjtlnTaN94LHQJ2wp488H4E/qlKzq4i90Tlkn2Q8TeyDiuT9zzU7
iQVYaOGsT/QQA8a1D6t1aH9S4Pe+jM4XXeR9ka95lRN1ULW+1BfVwbKnsnLy
QljxaqYLe6leCAHjSUTZKHk//JnP7MUseT90n6+UNGyR9wfr4i3Jhxny/hgo
Ttjy2yQfgNeSEqPdBrR+ALK7pnrrv5IPhJ4bvzVa7QOhMPPOSh8iH4S8czd4
pur5g/BWWJsy/ot8ME5qfTQWj5APxgzLvHu2nXwIDF8OMMbpvqQhOFb6hV3C
pPsIhdt3S5MxDfKhUHLkjnODa6r6MJgN6d/JhCov0jB0jMW1LAgpP+Hoz3p0
jWlPPhyfl1ZD4/aSj4D18HQMg0k+Anf1KloVhuQjkd8wNX+b8iuNhCvTQi+G
Qz4KS7LuWAXlWRqFmeQmjfvqfhSh53HC1HHKN0QIdjGIOGND40XgZhU0n9VR
8RsRKgXKYo66X8QYz5A3R1pRvRj6/mNabFeqF2O4qOnd4Hb//gP7Jkjp
    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, Automatic},
  PlotRange->{All, {0, 4}},
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{
  3.5104855992771697`*^9, 3.510568291350816*^9, 3.510568341382818*^9, 
   3.5105683933710165`*^9, {3.5105688140000753`*^9, 3.510568824869162*^9}, 
   3.5105689785275264`*^9, 3.510569035306204*^9, 3.5110651353369813`*^9, 
   3.511065706853588*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"level1", " ", "=", " ", 
  RowBox[{"Median", "[", 
   RowBox[{"calv0", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "lower1"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.511065150219572*^9, 3.5110651582848754`*^9}}],

Cell[BoxData["1.00776`"], "Output",
 CellChangeTimes->{3.511065159049285*^9, 3.5110657068847876`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"firstPlateauV1", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv1", "[", 
     RowBox[{"[", 
      RowBox[{"lower1", ";;", "upper1"}], "]"}], "]"}], "]"}], "-", 
   "level1"}]}]], "Input",
 CellChangeTimes->{{3.5104856456538067`*^9, 3.5104856850247436`*^9}, {
  3.510568752023878*^9, 3.5105687663173075`*^9}, {3.5105689197226467`*^9, 
  3.5105689337120457`*^9}, {3.5110651629805355`*^9, 3.511065164478155*^9}}],

Cell[BoxData["0.9792700000000001`"], "Output",
 CellChangeTimes->{{3.5104856655577974`*^9, 3.510485685530794*^9}, 
   3.510568291380819*^9, 3.5105683414188223`*^9, 3.5105683934040203`*^9, 
   3.510568767270403*^9, 3.5105689347901535`*^9, 3.51056897856353*^9, 
   3.5105690353422074`*^9, 3.5110651654297667`*^9, 3.5110657069003873`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5105689348231564`*^9, 3.5105689358642607`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"secondPlateauV1", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv1", "[", 
     RowBox[{"[", 
      RowBox[{"lower2", ";;", "upper2"}], "]"}], "]"}], "]"}], "-", 
   "level1"}]}]], "Input",
 CellChangeTimes->{{3.5104856974139824`*^9, 3.5104857138706284`*^9}, {
  3.5105687714528213`*^9, 3.5105687850551815`*^9}, {3.5105689411467886`*^9, 
  3.5105689462793016`*^9}, {3.5110651685810075`*^9, 3.5110651703126297`*^9}}],

Cell[BoxData["0.987425`"], "Output",
 CellChangeTimes->{3.510485714809722*^9, 3.5105682914028206`*^9, 
  3.5105683414388237`*^9, 3.510568393425022*^9, 3.5105687860472803`*^9, 
  3.5105689467363477`*^9, 3.510568978585532*^9, 3.5105690353652096`*^9, 
  3.5110651709834385`*^9, 3.5110657069315863`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefV1", " ", "=", " ", 
  RowBox[{"0.5", 
   RowBox[{"(", 
    RowBox[{"firstPlateauV1", "+", "secondPlateauV1"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.510485724914732*^9, 3.510485738382079*^9}}],

Cell[BoxData["0.9833475`"], "Output",
 CellChangeTimes->{{3.5104857311753583`*^9, 3.510485738956136*^9}, 
   3.510568291422823*^9, 3.510568341459826*^9, 3.510568393445024*^9, 
   3.5105689786065345`*^9, 3.510569035386212*^9, 3.5110651734950705`*^9, 
   3.5110657069471865`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calibration 1410 MHZ", "Section",
 CellChangeTimes->{{3.511065673095837*^9, 3.5110656850452075`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"calv0", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"\"\<calibv01410.txt\>\"", ",", "\"\<Table\>\""}], "]"}], ",", 
      "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.510485126860933*^9, 3.5104851547187185`*^9}, {
  3.510485210853331*^9, 3.5104852183190775`*^9}, {3.510568257000381*^9, 
  3.510568276243305*^9}, {3.5105683234930296`*^9, 3.5105683261923*^9}, {
  3.5105683755972395`*^9, 3.510568377628443*^9}, {3.5105689538710613`*^9, 
  3.510568956222296*^9}, {3.510569023660039*^9, 3.5105690240910826`*^9}, {
  3.511064999755643*^9, 3.5110650004264517`*^9}, {3.5110653389332542`*^9, 
  3.5110653450324244`*^9}, {3.5110654013288546`*^9, 3.511065404043063*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"calv0", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.510485159057152*^9, 3.510485166604907*^9}, {
  3.510485226189865*^9, 3.510485240596305*^9}, {3.510568473122991*^9, 
  3.5105685426859465`*^9}, {3.51056858732241*^9, 3.5105686369613733`*^9}, {
  3.510568669384615*^9, 3.5105687303767138`*^9}, {3.510568794084084*^9, 
  3.5105688198266582`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw90wlIk2Ecx/FlRt5lDmZmaKIiZh7lmeZ+npv3tNAiBfFIpUOsBEdJc+nM
Dk1T0ygjETQrKSwqQs3bLEmmpPOoaWSeuEg0r1bi+98L4+W7z54/L++eZ19c
akSiGovF8v//2bhvXgpuXLYi+buGgst8gQPl8cKohnmmNVAm799etES9EwZ6
De2tq9RssLkdI6/Uab0hlGbJn8ynyY2xnBNV5DFAbQrtWYdC6Sy1GRbvjt7J
3UbrzfGO/8jm8jq5Jbosl/WbxqmtcOZksczUgH5vDaXQyJ6/Qm6D9cV0+X19
cluUZ3X/WdpNbQ/psbAJE9V8B9wcTmalbiE/iCm9uCStvdSHwG8r5ldyqB3B
uTfjKJUuMe2E6uixGNu4Naad0Z/o8GLZldoF7EkDYdFFalfYK0YuvUmgdoP4
2S4bvSTqw6gVhwc8EFG7w3NS9nQlmtoD5lc2JlAfQV0fP+jHWWpP8Aq+DS+o
5nGR5JuSqsihBgYHLWpfS5gWAdLVjoGKE+ReUGraRvbHknuB9+HJBR0+uTe8
xOOdZe5/GffGTOTngPlhFjbdB3aS85Ux7UyLfKBR4Jx//CO5L4oK659Xj5L7
wnNOMZDQQ+4H3VZeW3EXuR98lOqc/dPk/tga63FV0kjuj0nxSqkbzWPx0Os7
qFjoJuehJaX5RmMLOR950q9y7T5yPuYnHuu9lZEHbP7/qucLwJx11VrVEHkg
xqyE6fnN5IHIrO+5NaW5yLyfIOzJyohpkjP7SxSEuvjotLR+2m/BWMg9VRHd
Rx4MH3Vj7xIj2l8hyJW015yeIw+Bpmu2tZPqvIXiZZTJjkw6j6JQ+A11PKxR
nacwuFz7ct25kzwMrVm3bWLVaL4Aeb0aznVKxiGArov8dyudf5EAZSvCo4Va
TL8XgF2aARmb1ofjl/9EIdeQaYSjRHzOLkWH1ocjIvMnx2JynvsPielTEQ==

    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, Automatic},
  PlotRange->{All, {0, 4}},
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{
  3.510568543339012*^9, {3.510568593199998*^9, 3.5105686374844255`*^9}, {
   3.5105686742290993`*^9, 3.5105687307887554`*^9}, {3.5105687969993753`*^9, 
   3.5105688202857037`*^9}, 3.5105689783645105`*^9, 3.510569035179191*^9, 
   3.5110650041548996`*^9, 3.511065707009585*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"level0", " ", "=", " ", 
  RowBox[{"Median", "[", 
   RowBox[{"calv0", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "lower1"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5110650299108295`*^9, 3.511065084152725*^9}}],

Cell[BoxData["1.00035`"], "Output",
 CellChangeTimes->{{3.511065060034816*^9, 3.511065085806346*^9}, 
   3.5110657070407844`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"firstPlateauV0", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv0", "[", 
     RowBox[{"[", 
      RowBox[{"lower1", ";;", "upper1"}], "]"}], "]"}], "]"}], "-", 
   "level0"}]}]], "Input",
 CellChangeTimes->{{3.5104853309903436`*^9, 3.510485459518195*^9}, {
  3.5105684434050198`*^9, 3.5105684489285717`*^9}, {3.5105685562363014`*^9, 
  3.5105686094556227`*^9}, {3.510568892881963*^9, 3.510568899942669*^9}, {
  3.511065099160117*^9, 3.5110651019681535`*^9}}],

Cell[BoxData["0.77481`"], "Output",
 CellChangeTimes->{3.5104854048187256`*^9, 3.510485460199263*^9, 
  3.510485759516192*^9, 3.5105682912378044`*^9, 3.5105683412928095`*^9, 
  3.510568393279008*^9, 3.510568641949872*^9, 3.5105689139200664`*^9, 
  3.510568978415515*^9, 3.510569035216195*^9, 3.5110651035125732`*^9, 
  3.511065707056384*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"secondPlateauV0", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv0", "[", 
     RowBox[{"[", 
      RowBox[{"lower2", ";;", "upper2"}], "]"}], "]"}], "]"}], "-", 
   "level0"}]}]], "Input",
 CellChangeTimes->{{3.510485466973941*^9, 3.510485503540597*^9}, {
  3.510485745583799*^9, 3.5104857458898296`*^9}, {3.5105686462232995`*^9, 
  3.5105686574044175`*^9}, {3.5105686914878254`*^9, 3.510568714078084*^9}, {
  3.510568903906065*^9, 3.510568909599634*^9}, {3.511065108099032*^9, 
  3.5110651126854906`*^9}}],

Cell[BoxData["1.1013200000000003`"], "Output",
 CellChangeTimes->{
  3.5104855048687296`*^9, 3.510485749006141*^9, 3.5105682912768087`*^9, 
   3.5105683413138113`*^9, 3.5105683933020096`*^9, {3.5105687099826746`*^9, 
   3.5105687148391604`*^9}, 3.510568916197294*^9, 3.5105689784595194`*^9, 
   3.510569035237197*^9, 3.5110651134031*^9, 3.5110657070875835`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefV0", " ", "=", " ", 
  RowBox[{"0.5", 
   RowBox[{"(", 
    RowBox[{"firstPlateauV0", "+", "secondPlateauV0"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5104855275750003`*^9, 3.510485554926735*^9}, {
  3.510485751407381*^9, 3.5104857516414046`*^9}}],

Cell[BoxData["0.9380650000000001`"], "Output",
 CellChangeTimes->{
  3.510485555287771*^9, {3.510485752134454*^9, 3.5104857636606064`*^9}, 
   3.5105682912988105`*^9, 3.5105683413358135`*^9, 3.510568393325012*^9, 
   3.5105687422469006`*^9, 3.510568978481522*^9, 3.510569035259199*^9, 
   3.511065117911558*^9, 3.5110657071343822`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"calv1", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"Import", "[", 
       RowBox[{"\"\<calibv11410.txt\>\"", ",", "\"\<Table\>\""}], "]"}], ",", 
      "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.510485582467489*^9, 3.5104855859028325`*^9}, {
  3.51056826929161*^9, 3.5105682788805685`*^9}, {3.5105683296836486`*^9, 
  3.5105683317928596`*^9}, {3.51056838190487*^9, 3.510568385624242*^9}, {
  3.510568962172891*^9, 3.5105689658952637`*^9}, {3.510569029622636*^9, 
  3.5105690299226656`*^9}, {3.5110651299705124`*^9, 3.5110651304385185`*^9}, {
  3.5110654135015974`*^9, 3.5110654186336355`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"calv1", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.510485598649107*^9, 3.5104855988751297`*^9}, {
  3.510568802164892*^9, 3.5105688243971148`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd02tIU3EYx/GlpS7xQhYzM9O8NNR5Ny9N99t0m9ucThPyVqEZUaa+UFEr
a5ZmokQZhIVJXsiQ1ESZUVFSSeDyhVY2wQtIarRsllqSmCmdZy8cjMN3n+f8
2cZzXDLzEk+asFgsyfp74/r/NS/YI33U37p+ZT7A9MXKJuyjtkAElyv2+m1g
2hbPb5Z8tjEj34kmjVWz8zK5PbK6lJ4OempHWB5b3NWym+adMSNomXxhTb0f
NeWaesUPmnfDMGvChL2d3ANJNQshjbbUXOxYuhyf/5PmPZGRlHjgPpvcG3uL
5Ob6NXKfTe2H+BTlJ7txav9NvycAQd6So9kG8kA41zW/NcxRB6Hqa3tZe+0v
poOxxMt/6u3xh+mDaFz2n+lwpw5BpKDG1imHOhSyEz3X24zzYeg2Ty1z8aIO
h2mae7JjHPUh5Ok03G4hNR/ObpZ1fTzqCChSroaOiKkjUTd+q7IilVoA2GW8
fm88H3g1nvJsTsS0GnCVn7/iG0suRHit9lKMgFyI6Y9hZlm+5CLMB/o4WshW
GBfhdmSBsFSxyngUusaGz8SkM62OQjTnQ++70+TR2Dj+ZSl5NO75VFcNSsnF
yHloP5snIhcjl3NXH5RILkF60UJSpfF8Cdiqw9qRc+RSaBvFmgXj+VJ81/eF
ucrJY/DFrqS2QEkeA2kor3joCLkMGt7A2RsychmOG/4Wd6aSy1E43c23ySWX
YzKgVZs5tci4AthYb0dmn9QKjHleK+tYpf2JhV+DMGptK3ks6vurK1yM+6yE
2OpBxrIFuRI9swHB7AnyOASdKh3wH2VaHQdvnYQ/Okgej6lkTu8QPc/qeNh2
6jnfjPutgk7n3tZLDRUcONblWVtoXgV+k6gwn57HPhXK0tb/cHO6PwHV2Rc8
VmYZRwLuNDx+YzpA3ycBFfqEJ07b5gX/AOWURyw=
    "]]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, Automatic},
  PlotRange->{All, {0, 4}},
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{
  3.5104855992771697`*^9, 3.510568291350816*^9, 3.510568341382818*^9, 
   3.5105683933710165`*^9, {3.5105688140000753`*^9, 3.510568824869162*^9}, 
   3.5105689785275264`*^9, 3.510569035306204*^9, 3.5110651353369813`*^9, 
   3.511065707181182*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"level1", " ", "=", " ", 
  RowBox[{"Median", "[", 
   RowBox[{"calv0", "[", 
    RowBox[{"[", 
     RowBox[{"1", ";;", "lower1"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.511065150219572*^9, 3.5110651582848754`*^9}}],

Cell[BoxData["1.00035`"], "Output",
 CellChangeTimes->{3.511065159049285*^9, 3.511065707196781*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"firstPlateauV1", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv1", "[", 
     RowBox[{"[", 
      RowBox[{"lower1", ";;", "upper1"}], "]"}], "]"}], "]"}], "-", 
   "level1"}]}]], "Input",
 CellChangeTimes->{{3.5104856456538067`*^9, 3.5104856850247436`*^9}, {
  3.510568752023878*^9, 3.5105687663173075`*^9}, {3.5105689197226467`*^9, 
  3.5105689337120457`*^9}, {3.5110651629805355`*^9, 3.511065164478155*^9}}],

Cell[BoxData["0.6400999999999999`"], "Output",
 CellChangeTimes->{{3.5104856655577974`*^9, 3.510485685530794*^9}, 
   3.510568291380819*^9, 3.5105683414188223`*^9, 3.5105683934040203`*^9, 
   3.510568767270403*^9, 3.5105689347901535`*^9, 3.51056897856353*^9, 
   3.5105690353422074`*^9, 3.5110651654297667`*^9, 3.5110657072279806`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5105689348231564`*^9, 3.5105689358642607`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"secondPlateauV1", " ", "=", " ", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"calv1", "[", 
     RowBox[{"[", 
      RowBox[{"lower2", ";;", "upper2"}], "]"}], "]"}], "]"}], "-", 
   "level1"}]}]], "Input",
 CellChangeTimes->{{3.5104856974139824`*^9, 3.5104857138706284`*^9}, {
  3.5105687714528213`*^9, 3.5105687850551815`*^9}, {3.5105689411467886`*^9, 
  3.5105689462793016`*^9}, {3.5110651685810075`*^9, 3.5110651703126297`*^9}}],

Cell[BoxData["0.8339399999999999`"], "Output",
 CellChangeTimes->{3.510485714809722*^9, 3.5105682914028206`*^9, 
  3.5105683414388237`*^9, 3.510568393425022*^9, 3.5105687860472803`*^9, 
  3.5105689467363477`*^9, 3.510568978585532*^9, 3.5105690353652096`*^9, 
  3.5110651709834385`*^9, 3.5110657072435803`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefV1", " ", "=", " ", 
  RowBox[{"0.5", 
   RowBox[{"(", 
    RowBox[{"firstPlateauV1", "+", "secondPlateauV1"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.510485724914732*^9, 3.510485738382079*^9}}],

Cell[BoxData["0.7370199999999999`"], "Output",
 CellChangeTimes->{{3.5104857311753583`*^9, 3.510485738956136*^9}, 
   3.510568291422823*^9, 3.510568341459826*^9, 3.510568393445024*^9, 
   3.5105689786065345`*^9, 3.510569035386212*^9, 3.5110651734950705`*^9, 
   3.5110657072747803`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1280", ",", 
        RowBox[{"1.44269", " ", 
         RowBox[{"23.943", "/", 
          RowBox[{"(", 
           RowBox[{"3.333844", "-", "1.44269"}], ")"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1380", ",", 
        RowBox[{"1.44269", " ", 
         RowBox[{"21.874", "/", 
          RowBox[{"(", 
           RowBox[{"3.276134", "-", "1.44269"}], ")"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1410", ",", " ", 
        RowBox[{"1.44269", " ", 
         RowBox[{"16.870", "/", 
          RowBox[{"(", 
           RowBox[{"2.789284", "-", "1.44269"}], ")"}]}]}]}], "}"}]}], "}"}], 
    ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "30"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5110667102249165`*^9, 3.5110667371038885`*^9}, {
  3.5110668667095194`*^9, 3.51106704109344*^9}, {3.511067093400575*^9, 
  3.511067097597002*^9}, {3.5110672336766744`*^9, 3.511067276951352*^9}}],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1280., 18.26521090826025}, {1380., 
   17.21208886663569}, {1410., 18.073881437166662`}, {1280., 
   18.26521090826025}, {1380., 17.21208886663569}, {1410., 
   18.073881437166662`}}, {
    {Hue[0.67, 0.6, 0.6], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->8.96], 4], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->8.96], 5], InsetBox[
      StyleBox["\<\"\[FilledCircle]\"\>",
       StripOnInput->False,
       FontSize->8.96], 6]}, {}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1280., 0},
  PlotRange->{All, {0, 30}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.511066976805428*^9, 3.5110670414834423`*^9}, 
   3.511067098501808*^9, {3.51106725943244*^9, 3.511067277466155*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{707, 761},
WindowMargins->{{Automatic, -23}, {31, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "PastelColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 196, 4, 41, "Input"],
Cell[778, 28, 206, 3, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1021, 36, 174, 3, 75, "Section"],
Cell[1198, 41, 151, 3, 41, "Input"],
Cell[1352, 46, 148, 3, 41, "Input"],
Cell[1503, 51, 151, 3, 41, "Input"],
Cell[1657, 56, 141, 3, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1835, 64, 188, 2, 75, "Section"],
Cell[2026, 68, 744, 15, 41, "Input"],
Cell[CellGroupData[{
Cell[2795, 87, 549, 12, 41, "Input"],
Cell[3347, 101, 1535, 30, 268, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4919, 136, 255, 6, 41, "Input"],
Cell[5177, 144, 128, 2, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5342, 151, 507, 11, 41, "Input"],
Cell[5852, 164, 344, 5, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6233, 174, 555, 12, 41, "Input"],
Cell[6791, 188, 349, 5, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7177, 198, 279, 6, 41, "Input"],
Cell[7459, 206, 325, 5, 40, "Output"]
}, Open  ]],
Cell[7799, 214, 644, 13, 41, "Input"],
Cell[CellGroupData[{
Cell[8468, 231, 353, 9, 41, "Input"],
Cell[8824, 242, 1507, 30, 268, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10368, 277, 255, 6, 41, "Input"],
Cell[10626, 285, 100, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10763, 291, 458, 10, 41, "Input"],
Cell[11224, 303, 335, 4, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11596, 312, 463, 10, 41, "Input"],
Cell[12062, 324, 307, 4, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12406, 333, 226, 5, 41, "Input"],
Cell[12635, 340, 275, 4, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12959, 350, 105, 1, 89, "Section"],
Cell[13067, 353, 742, 15, 41, "Input"],
Cell[CellGroupData[{
Cell[13834, 372, 549, 12, 41, "Input"],
Cell[14386, 386, 1522, 29, 268, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15945, 420, 255, 6, 41, "Input"],
Cell[16203, 428, 129, 2, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16369, 435, 507, 11, 41, "Input"],
Cell[16879, 448, 354, 5, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17270, 458, 555, 12, 41, "Input"],
Cell[17828, 472, 348, 5, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18213, 482, 279, 6, 41, "Input"],
Cell[18495, 490, 326, 5, 40, "Output"]
}, Open  ]],
Cell[18836, 498, 695, 14, 41, "Input"],
Cell[CellGroupData[{
Cell[19556, 516, 353, 9, 41, "Input"],
Cell[19912, 527, 1500, 29, 268, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21449, 561, 255, 6, 41, "Input"],
Cell[21707, 569, 101, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21845, 575, 458, 10, 41, "Input"],
Cell[22306, 587, 335, 4, 40, "Output"]
}, Open  ]],
Cell[22656, 594, 96, 1, 41, "Input"],
Cell[CellGroupData[{
Cell[22777, 599, 463, 10, 41, "Input"],
Cell[23243, 611, 299, 4, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23579, 620, 226, 5, 41, "Input"],
Cell[23808, 627, 277, 4, 40, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24134, 637, 107, 1, 75, "Section"],
Cell[24244, 640, 792, 15, 41, "Input"],
Cell[CellGroupData[{
Cell[25061, 659, 549, 12, 41, "Input"],
Cell[25613, 673, 1535, 30, 268, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27185, 708, 255, 6, 41, "Input"],
Cell[27443, 716, 129, 2, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27609, 723, 507, 11, 41, "Input"],
Cell[28119, 736, 341, 5, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28497, 746, 555, 12, 41, "Input"],
Cell[29055, 760, 361, 5, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29453, 770, 279, 6, 41, "Input"],
Cell[29735, 778, 335, 5, 40, "Output"]
}, Open  ]],
Cell[30085, 786, 697, 14, 41, "Input"],
Cell[CellGroupData[{
Cell[30807, 804, 353, 9, 41, "Input"],
Cell[31163, 815, 1484, 29, 268, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32684, 849, 255, 6, 41, "Input"],
Cell[32942, 857, 99, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33078, 863, 458, 10, 41, "Input"],
Cell[33539, 875, 335, 4, 40, "Output"]
}, Open  ]],
Cell[33889, 882, 96, 1, 41, "Input"],
Cell[CellGroupData[{
Cell[34010, 887, 463, 10, 41, "Input"],
Cell[34476, 899, 309, 4, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34822, 908, 226, 5, 41, "Input"],
Cell[35051, 915, 286, 4, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35374, 924, 1232, 33, 122, "Input"],
Cell[36609, 959, 945, 23, 265, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
