(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     42556,       1085]
NotebookOptionsPosition[     39330,        970]
NotebookOutlinePosition[     39749,        986]
CellTagsIndexPosition[     39706,        983]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  "\"\<E:\\\\Presentations\\\\BAO\\\\Amas 21cm\\\\Abell2440\>\"", 
  "]"}]], "Input"],

Cell[BoxData["\<\"E:\\\\Presentations\\\\BAO\\\\Amas 21cm\\\\Abell2440\"\>"], \
"Output",
 CellChangeTimes->{3.5111511711370373`*^9, 3.5111708935558796`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<sca150585.230.txt\>\"", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.511151204360359*^9, 3.51115121706663*^9}, {
  3.511151303986321*^9, 3.511151314996422*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"start", " ", "=", " ", 
   RowBox[{"StringSplit", "[", 
    RowBox[{"FindList", "[", 
     RowBox[{"\"\<sca150585.230.txt\>\"", ",", "\"\<HDEP\>\""}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.511151424236345*^9, 3.5111514430872297`*^9}, {
   3.511151583529272*^9, 3.51115159350327*^9}, {3.5111516770216208`*^9, 
   3.511151677674686*^9}, {3.5111517341843367`*^9, 3.5111517497698946`*^9}, {
   3.5111517979447117`*^9, 3.511151800503968*^9}, {3.5111518815470715`*^9, 
   3.511151882114128*^9}, {3.511152135730487*^9, 3.5111521390138154`*^9}, {
   3.5111522432462378`*^9, 3.5111522823901515`*^9}, 3.511152351822094*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateOfStart", "=", " ", 
  RowBox[{"start", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111522966425767`*^9, 3.5111523174736595`*^9}}],

Cell[BoxData["\<\"24/03/11\"\>"], "Output",
 CellChangeTimes->{3.5111523180087132`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HeureOfStart", " ", "=", " ", 
  RowBox[{"start", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "3"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.51115233097501*^9, 3.5111523439513073`*^9}}],

Cell[BoxData["\<\"9:49:16.00\"\>"], "Output",
 CellChangeTimes->{3.511152344327345*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"acq", "=", " ", 
   RowBox[{"StringSplit", "@", 
    RowBox[{"FindList", "[", 
     RowBox[{"\"\<sca150585.230.txt\>\"", ",", "\"\<PERI\>\""}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.511152371353047*^9, 3.511152399847896*^9}, {
  3.5111524586487756`*^9, 3.5111525090488153`*^9}, {3.51115390249716*^9, 
  3.5111539051904297`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PermierCycle", " ", "=", " ", 
  RowBox[{"acq", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "6"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.511152510888999*^9, 3.511152513845295*^9}, {
  3.5111525661455245`*^9, 3.5111525665975695`*^9}, {3.511153909967907*^9, 
  3.511153948614772*^9}}],

Cell[BoxData["\<\"1\"\>"], "Output",
 CellChangeTimes->{3.511152514136324*^9, 3.5111525671326227`*^9, 
  3.511153910963007*^9, 3.5111539496108713`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DernierCycle", " ", "=", " ", 
  RowBox[{"acq", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "6"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.511153956777588*^9, 3.5111539688767977`*^9}}],

Cell[BoxData["\<\"24\"\>"], "Output",
 CellChangeTimes->{3.5111539694318533`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.511153865358447*^9, 3.5111538906199727`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"acq", "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.511154509885893*^9, 3.5111545145443587`*^9}, {
  3.5111547233662386`*^9, 3.5111547261205144`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", ",", "\<\"10:37:00.00\"\>",
    ",", "\<\"336\"\>", ",", "\<\"4\"\>", ",", "\<\"24\"\>", ",", "\<\"2\"\>",
    ",", "\<\"40\"\>", ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
    ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", 
   ",", "\<\"375.058643\"\>", ",", "\<\"375.058643\"\>", 
   ",", "\<\"375.058643\"\>", ",", "\<\"375.058643\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.51115451485439*^9, 3.5111547269345956`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cycle2", "=", " ", 
  RowBox[{"Cases", "[", 
   RowBox[{"acq", ",", 
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "6", "]"}], "]"}], "\[Equal]", 
      RowBox[{"ToString", "[", "2", "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111544112350287`*^9, 3.5111544403349385`*^9}, {
  3.5111544872876334`*^9, 3.511154495622467*^9}, {3.51115453375628*^9, 
  3.5111545576086645`*^9}, {3.5111546216430674`*^9, 3.51115463436734*^9}, {
  3.511154762963198*^9, 3.511154771055007*^9}, {3.511154816757577*^9, 
  3.5111548370976105`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:32.00\"\>", ",", "\<\"15\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:33.00\"\>", ",", "\<\"16\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:34.00\"\>", ",", "\<\"17\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:35.00\"\>", ",", "\<\"18\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"1\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:36.00\"\>", ",", "\<\"19\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"1\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:37.00\"\>", ",", "\<\"20\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:38.00\"\>", ",", "\<\"21\"\>", ",", "\<\"2\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"1\"\>", ",", "\<\"40\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:32.00\"\>", ",", "\<\"22\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:33.00\"\>", ",", "\<\"23\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:34.00\"\>", ",", "\<\"24\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:35.00\"\>", ",", "\<\"25\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"1\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:36.00\"\>", ",", "\<\"26\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"1\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:37.00\"\>", ",", "\<\"27\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:38.00\"\>", ",", "\<\"28\"\>", ",", "\<\"4\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"2\"\>", ",", "\<\"40\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5111544962225266`*^9, {3.51115453485639*^9, 3.5111545579116955`*^9}, {
   3.5111546228831916`*^9, 3.5111546348313866`*^9}, {3.5111547660765095`*^9, 
   3.511154771640066*^9}, {3.511154824774379*^9, 3.5111548392328243`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cycle2Calib1Start", " ", "=", " ", 
  RowBox[{"Cycle2", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "3"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111549006209626`*^9, 3.511154956513551*^9}}],

Cell[BoxData["\<\"9:51:32.00\"\>"], "Output",
 CellChangeTimes->{{3.51115494819972*^9, 3.511154957040604*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cycle2calibType1", " ", "=", " ", 
  RowBox[{"Cases", "[", 
   RowBox[{"Cycle2", ",", 
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "7", "]"}], "]"}], "\[Equal]", 
      RowBox[{"ToString", "[", 
       RowBox[{"-", "1"}], "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111549916080604`*^9, 3.511155039894889*^9}, {
  3.511155666032496*^9, 3.5111556967335663`*^9}, {3.511155784654357*^9, 
  3.511155786140506*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:32.00\"\>", ",", "\<\"15\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:33.00\"\>", ",", "\<\"16\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:34.00\"\>", ",", "\<\"17\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:35.00\"\>", ",", "\<\"18\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"1\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:36.00\"\>", ",", "\<\"19\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"1\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:51:37.00\"\>", ",", "\<\"20\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:32.00\"\>", ",", "\<\"22\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:33.00\"\>", ",", "\<\"23\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:34.00\"\>", ",", "\<\"24\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:35.00\"\>", ",", "\<\"25\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"1\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:36.00\"\>", ",", "\<\"26\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"1\"\>", 
     ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"1\"\>",
      ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", 
     ",", "\<\"9:52:37.00\"\>", ",", "\<\"27\"\>", ",", "\<\"3\"\>", 
     ",", "\<\"2\"\>", ",", "\<\"-1\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>", 
     ",", "\<\"EWGD\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
     ",", "\<\"375.058846\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5111550404059396`*^9, 3.511155698612754*^9, 
  3.511155787794671*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cycle2calibType1", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "3"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5111550842783265`*^9, 3.51115508721462*^9}, {
  3.511155703332226*^9, 3.5111557349443865`*^9}, {3.511155794905382*^9, 
  3.5111558062305145`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"9:51:32.00\"\>", ",", "\<\"9:51:33.00\"\>", 
   ",", "\<\"9:51:34.00\"\>", ",", "\<\"9:51:35.00\"\>", 
   ",", "\<\"9:51:36.00\"\>", ",", "\<\"9:51:37.00\"\>", 
   ",", "\<\"9:52:32.00\"\>", ",", "\<\"9:52:33.00\"\>", 
   ",", "\<\"9:52:34.00\"\>", ",", "\<\"9:52:35.00\"\>", 
   ",", "\<\"9:52:36.00\"\>", ",", "\<\"9:52:37.00\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.5111550877246714`*^9, 3.5111557355834503`*^9, 
  3.511155807849676*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cycle2FirstCalibStart", " ", "=", " ", 
  RowBox[{"cycle2calibType1", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "3"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111563290917954`*^9, 3.5111563987287583`*^9}}],

Cell[BoxData["\<\"9:51:32.00\"\>"], "Output",
 CellChangeTimes->{3.5111563996298485`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cycle2FirstCalibEnd", " ", "=", "  ", 
  RowBox[{"cycle2calibType1", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "cycle2calibType1", "]"}], "/", "2"}], ",", 
     "3"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111564167685623`*^9, 3.5111564549893837`*^9}}],

Cell[BoxData["\<\"9:51:37.00\"\>"], "Output",
 CellChangeTimes->{3.511156456416527*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cycle2SecondCalibStart", " ", "=", " ", 
  RowBox[{"cycle2calibType1", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "cycle2calibType1", "]"}], "/", "2"}], "+", 
      "1"}], ",", "3"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111564956784525`*^9, 3.5111565154734316`*^9}}],

Cell[BoxData["\<\"9:52:32.00\"\>"], "Output",
 CellChangeTimes->{3.5111565161555*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cycle2SecondtCalibEnd", " ", "=", "  ", 
  RowBox[{"cycle2calibType1", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "3"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111565373196163`*^9, 3.511156559026787*^9}}],

Cell[BoxData["\<\"9:52:37.00\"\>"], "Output",
 CellChangeTimes->{3.5111565597178555`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data1cycle2", "=", 
  RowBox[{"Cases", "[", 
   RowBox[{"Cycle2", ",", 
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "7", "]"}], "]"}], "\[Equal]", 
      RowBox[{"ToString", "[", "1", "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111558146313543`*^9, 3.5111558721711082`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", ",", "\<\"9:51:38.00\"\>",
     ",", "\<\"21\"\>", ",", "\<\"2\"\>", ",", "\<\"2\"\>", ",", "\<\"1\"\>", 
    ",", "\<\"40\"\>", ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
     ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", 
    ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
    ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>"}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5111558434852395`*^9, 3.5111558738222733`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cycle2Data1Start", "=", 
   RowBox[{"data1cycle2", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "3"}], "]"}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.511156976486396*^9, 3.5111570399976206`*^9}}],

Cell[BoxData["\<\"9:51:38.00\"\>"], "Output",
 CellChangeTimes->{{3.511157034597141*^9, 3.5111570406244297`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{
   RowBox[{"DatePlus", "[", 
    RowBox[{"cycle2Data1Start", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ToExpression", "[", 
        RowBox[{"data1cycle2", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "8"}], "]"}], "]"}], "]"}], ",", 
       "\"\<Second\>\""}], "}"}]}], "]"}], ",", "\"\<Time\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.511158605464714*^9, 3.511158655769744*^9}, {
  3.5111586887540426`*^9, 3.511158689152082*^9}, {3.5111587881369796`*^9, 
  3.5111588261597815`*^9}, {3.511158914796644*^9, 3.5111589173168964`*^9}, {
  3.5111633484367595`*^9, 3.5111633567222443`*^9}}],

Cell[BoxData["\<\"09:52:18\"\>"], "Output",
 CellChangeTimes->{3.511158657618929*^9, 3.5111586900131683`*^9, 
  3.511158826871853*^9, 3.5111589179489594`*^9, 3.511163357672529*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data2cycle2", "=", 
  RowBox[{"Cases", "[", 
   RowBox[{"Cycle2", ",", 
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "7", "]"}], "]"}], "\[Equal]", 
      RowBox[{"ToString", "[", "2", "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.511155885671458*^9, 3.511155892273118*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"PERI\"\>", ",", "\<\"24/03/11\"\>", ",", "\<\"9:52:38.00\"\>",
     ",", "\<\"28\"\>", ",", "\<\"4\"\>", ",", "\<\"2\"\>", ",", "\<\"2\"\>", 
    ",", "\<\"40\"\>", ",", "\<\"100\"\>", ",", "\<\"0\"\>", ",", "\<\"0\"\>",
     ",", "\<\"0\"\>", ",", "\<\"1\"\>", ",", "\<\"EWGD\"\>", 
    ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>", 
    ",", "\<\"375.058846\"\>", ",", "\<\"375.058846\"\>"}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.511155892904181*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cycle2Data2Start", "=", 
  RowBox[{"data2cycle2", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "3"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5111590452916927`*^9, 3.5111590515713205`*^9}}],

Cell[BoxData["\<\"9:52:38.00\"\>"], "Output",
 CellChangeTimes->{3.5111590524014034`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{
   RowBox[{"DatePlus", "[", 
    RowBox[{"cycle2Data2Start", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ToExpression", "[", 
        RowBox[{"data2cycle2", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "8"}], "]"}], "]"}], "]"}], ",", 
       "\"\<Second\>\""}], "}"}]}], "]"}], ",", "\"\<Time\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5111590758037434`*^9, 3.511159113055468*^9}, 
   3.5111591503451967`*^9, {3.511159281949356*^9, 3.5111592953166924`*^9}, {
   3.5111593855377135`*^9, 3.5111594117203317`*^9}}],

Cell[BoxData["\<\"09:53:18\"\>"], "Output",
 CellChangeTimes->{{3.5111590858057437`*^9, 3.511159114003563*^9}, {
  3.511159284747636*^9, 3.5111592959897594`*^9}, {3.511159393287489*^9, 
  3.5111594125274124`*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "decodeCycle", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"decodeCycle", "[", "c_List", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "i", ",", "calibType1", ",", "firstCalibStart", ",", "firstCalibEnd", 
       ",", "secondCalibStart", ",", "secondCalibEnd", ",", "data1", ",", 
       "data1Start", ",", "data1End", ",", "data2", ",", "data2Start", ",", 
       "data2End"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"calibType1", " ", "=", " ", 
       RowBox[{"Cases", "[", 
        RowBox[{"c", ",", 
         RowBox[{"x_", "/;", 
          RowBox[{
           RowBox[{"x", "[", 
            RowBox[{"[", "7", "]"}], "]"}], "\[Equal]", 
           RowBox[{"ToString", "[", 
            RowBox[{"-", "1"}], "]"}]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"firstCalibStart", " ", "=", " ", 
       RowBox[{
        RowBox[{"calibType1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"calibType1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "3"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i", " ", "=", " ", 
       RowBox[{
        RowBox[{"Length", "[", "calibType1", "]"}], "/", "2"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"firstCalibEnd", " ", "=", "  ", 
       RowBox[{
        RowBox[{"calibType1", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "2"}], "]"}], "]"}], "<>", "\"\< \>\"", " ", "<>", 
        RowBox[{"calibType1", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "3"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"secondCalibStart", " ", "=", " ", 
       RowBox[{
        RowBox[{"calibType1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}], "<>", 
        "\"\< \>\"", "<>", " ", 
        RowBox[{"calibType1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "3"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"secondCalibEnd", " ", "=", "  ", 
       RowBox[{
        RowBox[{"calibType1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"calibType1", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "3"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"data1", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{"c", ",", 
         RowBox[{"x_", "/;", 
          RowBox[{
           RowBox[{"x", "[", 
            RowBox[{"[", "7", "]"}], "]"}], "\[Equal]", 
           RowBox[{"ToString", "[", "1", "]"}]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"data1Start", "=", 
       RowBox[{
        RowBox[{"data1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"data1", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "3"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"data1End", " ", "=", 
       RowBox[{"DateString", "[", 
        RowBox[{
         RowBox[{"DatePlus", "[", 
          RowBox[{"data1Start", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"data1", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "8"}], "]"}], "]"}], "]"}], ",", 
             "\"\<Second\>\""}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Day\>\"", ",", "\"\</\>\"", ",", "\"\<Month\>\"", ",", 
           "\"\</\>\"", ",", "\"\<YearShort\>\"", ",", "\"\< \>\"", ",", 
           "\"\<Time\>\""}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"data2", "=", 
       RowBox[{"Cases", "[", 
        RowBox[{"c", ",", 
         RowBox[{"x_", "/;", 
          RowBox[{
           RowBox[{"x", "[", 
            RowBox[{"[", "7", "]"}], "]"}], "\[Equal]", 
           RowBox[{"ToString", "[", "2", "]"}]}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"data2Start", "=", 
       RowBox[{
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
        RowBox[{"data2", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "3"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"data2End", " ", "=", 
       RowBox[{"DateString", "[", 
        RowBox[{
         RowBox[{"DatePlus", "[", 
          RowBox[{"data2Start", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ToExpression", "[", 
              RowBox[{"data2", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "8"}], "]"}], "]"}], "]"}], ",", 
             "\"\<Second\>\""}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Day\>\"", ",", "\"\</\>\"", ",", "\"\<Month\>\"", ",", 
           "\"\</\>\"", ",", "\"\<YearShort\>\"", ",", "\"\< \>\"", ",", 
           "\"\<Time\>\""}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{
       "firstCalibStart", "<>", "\"\<, \>\"", "<>", "firstCalibEnd", "<>", 
        "\"\<, \>\"", "<>", "data1Start", "<>", "\"\<, \>\"", "<>", 
        "data1End", "<>", "\"\<, \>\"", "<>", "secondCalibStart", "<>", 
        "\"\<, \>\"", "<>", "secondCalibEnd", "<>", "\"\<, \>\"", "<>", 
        "data2Start", "<>", "\"\<, \>\"", "<>", "data2End"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5111667321104455`*^9, 3.5111667905752916`*^9}, {
  3.511166844045638*^9, 3.5111670669959307`*^9}, {3.5111671129775286`*^9, 
  3.5111674032735553`*^9}, {3.5111709694704704`*^9, 3.5111711201485367`*^9}, {
  3.5111711987874*^9, 3.5111712505565763`*^9}, {3.5111714384493637`*^9, 
  3.5111714389044094`*^9}, {3.511171483037822*^9, 3.511171483930911*^9}, {
  3.511171629464463*^9, 3.511171690697586*^9}, {3.511171734478964*^9, 
  3.5111717594094563`*^9}, {3.5111724842864494`*^9, 3.5111725120414495`*^9}, {
  3.5111738564671555`*^9, 3.511173959045412*^9}, {3.5111740533308396`*^9, 
  3.511174069447451*^9}, {3.5111741270322094`*^9, 3.511174130320538*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "dump", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dump", "[", "f_String", "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "fileOut", ",", "start", ",", "acq", ",", "premierCycle", ",", 
       "dernierCycle", ",", "cycles"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"fileOut", " ", "=", " ", 
       RowBox[{"OpenWrite", "[", 
        RowBox[{
         RowBox[{"FileBaseName", "[", "f", "]"}], "<>", "\"\<.out\>\""}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"fileOut", ",", 
        RowBox[{"FormatType", "\[Rule]", "OutputForm"}], ",", 
        RowBox[{"PageWidth", "\[Rule]", "255"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"start", " ", "=", 
       RowBox[{"StringSplit", "[", 
        RowBox[{"FindList", "[", 
         RowBox[{"f", ",", "\"\<HDEP\>\""}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Write", "[", 
         RowBox[{"fileOut", ",", 
          RowBox[{
           RowBox[{"start", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "2"}], "]"}], "]"}], "<>", "\"\< \>\"", "<>", 
           RowBox[{"start", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3"}], "]"}], "]"}]}]}], "]"}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"acq", "=", " ", 
       RowBox[{"StringSplit", "@", 
        RowBox[{"FindList", "[", 
         RowBox[{"f", ",", "\"\<PERI\>\""}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"premierCycle", " ", "=", " ", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"acq", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "6"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dernierCycle", " ", "=", " ", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"acq", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "6"}], "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<cycle 2\>\"", ",", 
          RowBox[{"Cases", "[", 
           RowBox[{"acq", ",", 
            RowBox[{"x_", "/;", 
             RowBox[{
              RowBox[{"x", "[", 
               RowBox[{"[", "6", "]"}], "]"}], "\[Equal]", 
              RowBox[{"ToString", "[", "2", "]"}]}]}]}], "]"}]}], "]"}], 
        ";"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"cycles", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Cases", "[", 
          RowBox[{"acq", ",", 
           RowBox[{"x_", "/;", 
            RowBox[{
             RowBox[{"x", "[", 
              RowBox[{"[", "6", "]"}], "]"}], "\[Equal]", 
             RowBox[{"ToString", "[", "n", "]"}]}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "premierCycle", ",", "dernierCycle"}], "}"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"cycles", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Write", "[", 
         RowBox[{"fileOut", ",", 
          RowBox[{"decodeCycle", "[", 
           RowBox[{"cycles", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}], ";"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Write", "[", 
          RowBox[{"fileOut", ",", 
           RowBox[{"decodeCycle", "[", "#", "]"}]}], "]"}], "&"}], ",", 
        "cycles"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "fileOut", "]"}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5111635974271193`*^9, 3.5111635982942924`*^9}, {
   3.5111643101273737`*^9, 3.511164348477208*^9}, {3.5111643798863487`*^9, 
   3.511164450735433*^9}, {3.511164550274386*^9, 3.5111647309164486`*^9}, 
   3.511164767257082*^9, {3.5111649816345177`*^9, 3.5111650506394176`*^9}, {
   3.5111651211274652`*^9, 3.511165124810834*^9}, {3.511165336807031*^9, 
   3.5111654784131904`*^9}, {3.511165509602309*^9, 3.5111655867820263`*^9}, {
   3.511165755045882*^9, 3.511165796529882*^9}, {3.511165869102882*^9, 
   3.511166040667882*^9}, {3.511166151150882*^9, 3.511166174389882*^9}, {
   3.511166262074882*^9, 3.511166450981882*^9}, {3.511166521082882*^9, 
   3.511166525858882*^9}, {3.511166558733882*^9, 3.511166600154882*^9}, {
   3.5111674376409917`*^9, 3.511167459079135*^9}, {3.51117019258379*^9, 
   3.5111702101185427`*^9}, {3.511170261142645*^9, 3.5111702914586763`*^9}, {
   3.5111712617486954`*^9, 3.511171282716792*^9}, {3.5111718811714497`*^9, 
   3.5111719001194496`*^9}, {3.5111719551424494`*^9, 
   3.5111719792294493`*^9}, {3.5111720229094496`*^9, 
   3.5111720300204496`*^9}, {3.5111720755574493`*^9, 
   3.5111721222034492`*^9}, {3.51117253141245*^9, 3.5111725398704495`*^9}, {
   3.5111726571734495`*^9, 3.5111727762631454`*^9}, {3.5111731111166277`*^9, 
   3.511173114791995*^9}, {3.5111731634398594`*^9, 3.5111731859031057`*^9}, {
   3.5111732419397087`*^9, 3.5111732457770925`*^9}, {3.51117328265478*^9, 
   3.5111733450580196`*^9}, {3.511173654775988*^9, 3.51117365599511*^9}, {
   3.511173755174027*^9, 3.511173788525362*^9}, {3.511174413451848*^9, 
   3.5111744549229946`*^9}, {3.51117454958646*^9, 3.5111745600085025`*^9}, {
   3.5111747429657965`*^9, 3.5111748040269017`*^9}}],

Cell[BoxData[
 RowBox[{"dump", "[", "\"\<sca150585.230.txt\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.5111655938997383`*^9, 3.5111656168510327`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5111727214566655`*^9, 3.511172723127833*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "\"\<sca150585.230.out\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.5111725469254494`*^9, 3.5111725569344497`*^9}, {
  3.5111725896214495`*^9, 3.5111725938444495`*^9}}],

Cell[BoxData["\<\"sca150585.230.out\"\>"], "Output",
 CellChangeTimes->{3.5111725576824493`*^9, 3.51117259423345*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"OpenWrite", "[", "\"\<test.out\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.5111722223314495`*^9, 3.5111722331164494`*^9}}],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"test.out\"\>", ",", "54"}], "]"}]], "Output",
 CellChangeTimes->{3.5111722336394496`*^9, 3.5111722931064496`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"str", ",", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "2"}], "}"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.51117223872145*^9, 3.5111722483334494`*^9}, {
  3.5111723798964496`*^9, 3.5111723874794493`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellChangeTimes->{{3.51117226118145*^9, 3.5111722647624493`*^9}}],

Cell[BoxData["\<\"test.out\"\>"], "Output",
 CellChangeTimes->{3.5111722651724496`*^9, 3.51117239424745*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5111723942754498`*^9, 3.5111723954814496`*^9}}]
},
WindowSize->{707, 761},
WindowMargins->{{0, Automatic}, {0, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 130, 3, 41, "Input"],
Cell[712, 27, 157, 2, 40, "Output"]
}, Open  ]],
Cell[884, 32, 287, 7, 41, "Input"],
Cell[1174, 41, 670, 12, 41, "Input"],
Cell[CellGroupData[{
Cell[1869, 57, 215, 5, 41, "Input"],
Cell[2087, 64, 87, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2211, 70, 218, 5, 41, "Input"],
Cell[2432, 77, 87, 1, 40, "Output"]
}, Open  ]],
Cell[2534, 81, 378, 9, 41, "Input"],
Cell[CellGroupData[{
Cell[2937, 94, 317, 7, 41, "Input"],
Cell[3257, 103, 151, 2, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3445, 110, 238, 6, 41, "Input"],
Cell[3686, 118, 81, 1, 40, "Output"]
}, Open  ]],
Cell[3782, 122, 94, 1, 41, "Input"],
Cell[CellGroupData[{
Cell[3901, 127, 219, 5, 41, "Input"],
Cell[4123, 134, 527, 8, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4687, 147, 594, 13, 41, "Input"],
Cell[5284, 162, 6743, 118, 516, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12064, 285, 225, 5, 41, "Input"],
Cell[12292, 292, 110, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12439, 298, 485, 12, 41, "Input"],
Cell[12927, 312, 5664, 100, 459, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18628, 417, 287, 6, 41, "Input"],
Cell[18918, 425, 490, 9, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19445, 439, 241, 5, 41, "Input"],
Cell[19689, 446, 89, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19815, 452, 324, 8, 41, "Input"],
Cell[20142, 462, 87, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20266, 468, 355, 9, 41, "Input"],
Cell[20624, 479, 85, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20746, 485, 261, 6, 41, "Input"],
Cell[21010, 493, 89, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21136, 499, 349, 9, 41, "Input"],
Cell[21488, 510, 559, 10, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22084, 525, 261, 7, 62, "Input"],
Cell[22348, 534, 113, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22498, 540, 670, 16, 62, "Input"],
Cell[23171, 558, 180, 2, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23388, 565, 345, 9, 41, "Input"],
Cell[23736, 576, 533, 10, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24306, 591, 221, 5, 41, "Input"],
Cell[24530, 598, 89, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24656, 604, 597, 15, 62, "Input"],
Cell[25256, 621, 213, 3, 40, "Output"]
}, Open  ]],
Cell[25484, 627, 6468, 156, 522, "Input"],
Cell[31955, 785, 5685, 129, 382, "Input"],
Cell[37643, 916, 151, 2, 41, "Input"],
Cell[37797, 920, 94, 1, 41, "Input"],
Cell[CellGroupData[{
Cell[37916, 925, 205, 3, 41, "Input"],
Cell[38124, 930, 117, 1, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38278, 936, 172, 3, 41, "Input"],
Cell[38453, 941, 173, 3, 40, "Output"]
}, Open  ]],
Cell[38641, 947, 311, 8, 41, "Input"],
Cell[CellGroupData[{
Cell[38977, 959, 127, 2, 41, "Input"],
Cell[39107, 963, 108, 1, 40, "Output"]
}, Open  ]],
Cell[39230, 967, 96, 1, 41, "Input"]
}
]
*)

(* End of internal cache information *)
