#include "machdefs.h"

//---- System et stdc++ include files
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <iostream>
#include <fstream>
#include <complex>

#include <typeinfo>
#include <string>
#include <vector>
#include <map>
#include <functional>
#include <list>

//---- Sophya include files
#include "sopnamsp.h"
#include "basetools.h"
#include "systools.h"
#include "sutils.h"
#include "ntools.h"
#include "array.h"
#include "histats.h"

//---- Spiapp include files
#include "nobjmgr.h"
#include "servnobjm.h"

//---- Include files from additionnal modules

//---- function to compare bits on double 
int_8 BitCmp64(double v,int_8 flg) 
{return ((int_8)((v<0.) ? v-0.1 : v+0.1))&flg;} 

//---- function for Adding and displaying Objects  
void Keep_Object(AnyDataObj & obj, string const & nom) 
{ 
  string name = nom; 
  NamedObjMgr om; 
  if (om.GetObj(name)) 
    cerr << "KeepObj()/Warning Already kept object " << endl; 
  else om.AddObj(obj, name); 
} 

void Display_Object(AnyDataObj & obj, string const & opt, string const & nom) 
 { 
  string name = nom; 
  NamedObjMgr om; 
  if (!om.GetObj(name)) 
    om.AddObj(obj, name); 
  om.DisplayObj(name, opt); 
} 

//---- function for getting and setting ObjectManager variables  
void Set_ObjMgrVar(MuTyV v, string const & nom) 
{ 
  NamedObjMgr om; 
  om.SetVar(nom, (string)v); 
} 

MuTyV Get_ObjMgrVar(const char * nom) 
{ 
  string name = nom; NamedObjMgr om; 
  MuTyV v = om.GetVar(name); 
  return v; 
} 

//---- Macro for Objects and variables saving
#define KeepObj(obj) Keep_Object(obj, #obj)
#define GetOMVar(var) Get_ObjMgrVar( #var )
#define SetOMVar(var) Set_ObjMgrVar(var, #var )

//---- Macro Displaying objects and command execution
#define DispObj(obj, att) Display_Object(obj, att, #obj); 

#define ExecCmd(cmd) srvo.ExecuteCommand(cmd); 



//-------------------------------------------------//
//----------------- User Functions ----------------//
//-------------------------------------------------//

extern "C" {
  int func( vector<string>& args );
}

int func( vector<string>& args )
{
// Some definitions to help using spiapp;
NamedObjMgr omg;
Services2NObjMgr& srvo = *omg.GetServiceObj();

//-------------- Object List --------------
//Number of objects = 1
string ___nomobj;

___nomobj = "inarr";
TVector< r_4 > * ___inarr = dynamic_cast< TVector< r_4 >  * >(omg.GetObj(___nomobj));
if(___inarr==NULL) throw NullPtrError("CxxExecutor::PutObject: Non existing object inarr... please update file");
TVector< r_4 > & inarr = (*___inarr);

//--------------------------------------------//
//----------------- User Code ----------------//
//CALIBRATION
//--------------------------------------------//


//Frequences utilisées pour la calibration par F. Alsac
 r_4 f1 = 1280.;
 r_4 f2 = 1380.;
 r_4 f3 = 1410.;
 //calbration RT du 15 Mars 2011 Est/West
 r_4 c1E = 23.943;
 r_4 c2E = 21.874;
 r_4 c3E = 16.870;
 r_4 c1W = 29.598;
 r_4 c2W = 27.084;
 r_4 c3W = 20.275;
 //calibration BAO Abell2440 DAQ:24 Mars 2011 Ch0/Ch1 (spectre moyenne)
 //5/4/11: il faut retranche la valeur du fond = 1/ln2=1.44269
//  r_4 bao1v0 = 3.333844-1.44269;
//  r_4 bao2v0 = 3.276134-1.44269;
//  r_4 bao3v0 = 2.789284-1.44269;
//  r_4 bao1v1 = 2.899674-1.44269;
//  r_4 bao2v1 = 2.876464-1.44269;
//  r_4 bao3v1 = 2.501294-1.44269;
//calibration BAO Abell2440 DAQ:24 Mars 2011 Ch0/Ch1 (spectre median)
 r_4 bao1v0 = 1.31296;
 r_4 bao2v0 = 1.26843;
 r_4 bao3v0 = 0.938065;
 r_4 bao1v1 = 1.01136;
 r_4 bao2v1 = 0.983348;
 r_4 bao3v1 = 0.73702;


 r_4 voie = atof(args[2].data()); //INPUT voie=0 ou 1
 cout << "Calibration de la voie ="<< voie <<endl;
 r_4 c1,c2,c3,bao1,bao2,bao3;
 //Choix d'associer voie 0 BAO a la polarisation Est RT
 if( voie == 0 ){
   c1 = c1E;
   c2 = c2E;
   c3 = c3E;
   bao1= bao1v0;
   bao2= bao2v0;
   bao3= bao3v0;
 } else {
   c1 = c1W;
   c2 = c2W;
   c3 = c3W;
   bao1= bao1v1;
   bao2= bao2v1;
   bao3= bao3v1;
 }

 TVector<r_4> outarr1(inarr.NCols());

 for (sa_size_t ch=0; ch<inarr.NCols(); ch++) {
   r_4 f = (ch/8192.)*250.+1250.;
   r_4 coef = c1/bao1 + (f - f1)*((-(c1/bao1) + c2/bao2)/(-f1 + f2) + 
    ((f - f2)*(-((-(c1/bao1) + c2/bao2)/(-f1 + f2)) + 
	       (-(c2/bao2) + c3/bao3)/(-f2 + f3)))/(-f1 + f3));
   outarr1(ch)= coef * inarr(ch);
 }

//--------------------------------------------//
//----------------- User Code ----------------//
//EXTRACTION
//--------------------------------------------//

//Input: inarr vector: X=> freq
//Output: outarr vector: X=> freq
//Center a window @ 1410 MHz; the DAQ takes 250MHz starting at 1250MHz
//RT filter width for calibration : 6.25MHz  
 r_4 f0 = atof(args[0].data());
 r_4 RTFilterWidth = atof(args[1].data());
 sa_size_t c0 = (sa_size_t)inarr.NElts()*(f0-1250.)/250.;
 sa_size_t dc = (sa_size_t)inarr.NElts()*RTFilterWidth/250.;
 sa_size_t fMin = c0-dc/2; //lower bound of the freq. filter
 sa_size_t fMax = c0+dc/2; //upper bound of the freq. filter

 TVector<r_4> outarr(outarr1.SubVector(Range(fMin,fMax)),false);//freq. bin 0 is a DC level
 
 KeepObj(outarr);


 return 0;
}
