#include "machdefs.h"

//---- System et stdc++ include files
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <iostream>
#include <fstream>
#include <complex>

#include <typeinfo>
#include <string>
#include <vector>
#include <map>
#include <functional>
#include <list>

//---- Sophya include files
#include "sopnamsp.h"
#include "basetools.h"
#include "systools.h"
#include "sutils.h"
#include "ntools.h"
#include "array.h"
#include "histats.h"

//---- Spiapp include files
#include "nobjmgr.h"
#include "servnobjm.h"

//---- Include files from additionnal modules

//---- function to compare bits on double 
int_8 BitCmp64(double v,int_8 flg) 
{return ((int_8)((v<0.) ? v-0.1 : v+0.1))&flg;} 

//---- function for Adding and displaying Objects  
void Keep_Object(AnyDataObj & obj, string const & nom) 
{ 
  string name = nom; 
  NamedObjMgr om; 
  if (om.GetObj(name)) 
    cerr << "KeepObj()/Warning Already kept object " << endl; 
  else om.AddObj(obj, name); 
} 

void Display_Object(AnyDataObj & obj, string const & opt, string const & nom) 
 { 
  string name = nom; 
  NamedObjMgr om; 
  if (!om.GetObj(name)) 
    om.AddObj(obj, name); 
  om.DisplayObj(name, opt); 
} 

//---- function for getting and setting ObjectManager variables  
void Set_ObjMgrVar(MuTyV v, string const & nom) 
{ 
  NamedObjMgr om; 
  om.SetVar(nom, (string)v); 
} 

MuTyV Get_ObjMgrVar(const char * nom) 
{ 
  string name = nom; NamedObjMgr om; 
  MuTyV v = om.GetVar(name); 
  return v; 
} 

//---- Macro for Objects and variables saving
#define KeepObj(obj) Keep_Object(obj, #obj)
#define GetOMVar(var) Get_ObjMgrVar( #var )
#define SetOMVar(var) Set_ObjMgrVar(var, #var )

//---- Macro Displaying objects and command execution
#define DispObj(obj, att) Display_Object(obj, att, #obj); 

#define ExecCmd(cmd) srvo.ExecuteCommand(cmd); 



//-------------------------------------------------//
//----------------- User Functions ----------------//
//-------------------------------------------------//

extern "C" {
  int func( vector<string>& args );
}

int func( vector<string>& args )
{
// Some definitions to help using spiapp;
NamedObjMgr omg;
Services2NObjMgr& srvo = *omg.GetServiceObj();

//-------------- Object List --------------
//Number of objects = 1
string ___nomobj;

___nomobj = "inarr";
TVector< r_4 > * ___inarr = dynamic_cast< TVector< r_4 >  * >(omg.GetObj(___nomobj));
if(___inarr==NULL) throw NullPtrError("CxxExecutor::PutObject: Non existing object inarr... please update file");
TVector< r_4 > & inarr = (*___inarr);



//--------------------------------------------//
//----------------- User Code ----------------//
//--------------------------------------------//
//#include "/home/bao/tmp/PIATmp_iAIt8R/cxx_spiapp.h"

//Input: inarr vector: X=> freq
//Output: outarr vector: X=> freq
//Center a window @ 1410 MHz; the DAQ takes 250MHz starting at 1250MHz
//RT filter width for calibration : 6.25MHz  
 r_4 f0 = atof(args[0].data());
 r_4 RTFilterWidth = atof(args[1].data());
 sa_size_t c0 = (sa_size_t)inarr.NElts()*(f0-1250.)/250.;
 sa_size_t dc = (sa_size_t)inarr.NElts()*RTFilterWidth/250.;
 sa_size_t fMin = c0-dc/2; //lower bound of the freq. filter
 sa_size_t fMax = c0+dc/2; //upper bound of the freq. filter

 TVector<r_4> outarr(inarr.SubVector(Range(fMin,fMax)),false);//freq. bin 0 is a DC level
 
 KeepObj(outarr);


 return 0;
}
