
double WDISH = 2.8;
double DIST = 12.;
double lambda = 0.21;
// Vitesse angulaire Omega en degre/second = 15./3600.*cos(delta)
double OMEGA = cos(M_PI*47./180)*15./3600.;
double tmsec=0.;  // 
#define ANG (OMEGA*tmsec) 
#define T1 (2*M_PI*WDISH/lambda*sin(M_PI*ANG/180.))
#define XX ((fabs(T1)<1e-8)?1.:(sin(T1)/T1))
#define T2 (2*M_PI*DIST/lambda*sin(M_PI*ANG/180.))

// duree totale 90 minutes par pas de 30 secondes --> SIZE = 181
double timestep=30.;
sa_size_t SIZE=181;
sa_size_t SZ2=SIZE/2; 

const char * names[6] = {"time","I","vre","vim","vI","err"};
int i,j, k;
double xnt[10];
NTuple  visi(6, names, 50);

double FLXSRC = 20.;  // Flux en jansky 
double NOISE = 5.;   // bruit correspondant  Tsys 

ThSDR48RandGen rnd;
for(sa_size_t i=0; i<SIZE; i++) {
  tmsec=(i-SZ2)*timestep; 
  double intens=FLXSRC*XX*XX;
  double vis_real=intens*cos(T2)+rnd.Gaussian()*NOISE; 
  double vis_imag=intens*sin(T2)+rnd.Gaussian()*NOISE; 
  double vis_mod=sqrt(vis_real*vis_real+vis_imag*vis_imag);
  xnt[0]=tmsec; xnt[1]=intens; xnt[2]=vis_real; xnt[3]=vis_imag; xnt[4]=vis_mod; xnt[5]=NOISE;  
  visi.Fill(xnt);
} 
KeepObj(visi); 
