////////////////////////////////
// Classe Alignement          //
// Franck RICHARD             //
// BAORadio                   //
// franckrichard033@gmail.com //
// février 2012               //
////////////////////////////////



#ifndef Alignement_class
#define Alignement_class

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>
#include <unistd.h>
#include <time.h>
#include <memory>
#include <pthread.h>
#include <iostream>
#include <time.h>
#include <unistd.h>
#include <sys/time.h>
#include <fstream>
#include "../communs/const.h"
#include "../communs/filetools.h"
#include "../communs/astro.h"
#include "../communs/logs.h"


using namespace std;

struct Coord
{
    double x;
    double y;
    double z;
};

class Alignement : public Astro, public Logs
{
public:
    Alignement();
    ~Alignement();

    void InitAlignement();
    void TransmettreParametresClasseAstro(double Annee, double Mois, double Jour, double Heu, double Min, double Sec, double Longitude, double Latitude, double Pression, double Temp);


    /*******************************************************/
    /* Gestion des fichiers de paramètres
    ********************************************************/
    bool is_readable( const std::string & file );
    bool ChargementParametresAlignement(string IP, string fileName, double ad, double de);

    // bool ChargementParametresAlignement(string fileName, int ip, int num);
    bool EnregistrementParametresAlignement(string IP, string fileName);
    bool EnregistrementParametresAlignement(int IP, string fileName);



    /*******************************************************/
    /* Calcul des matrices
    ********************************************************/

    //Réinitialisation MATRICE = Matrice identité
    void Identity();
    void RotationAutourDunAxe(double t, double r, double alpha);

    // Méthode de correction "simple
    inline int Calculer_Matrice_Simple( Coord a1, Coord a2, Coord a3, Coord m1, Coord m2, Coord m3);
    inline int ElementsMatriceSimple(Coord aa1, Coord aa2, Coord aa3, Coord mm1, Coord mm2, Coord mm3);
    void AppliquerMatriceCorrectionSimple( Coord * result, Coord vect);


    // Méthode de correction "affine"
    void Calculer_Matrice_GETPQ(Coord p1, Coord p2, Coord p3);
    int  Calculer_Matrice_Affine(double x, double y, Coord a1, Coord a2, Coord a3, Coord m1, Coord m2, Coord m3);
    void AppliquerMatriceCorrectionAffine( Coord* result, Coord ob);

    // Méthode correction "Taki"
    void Calculer_Matrice_LMN(Coord p1, Coord p2, Coord p3);
    int  Calculer_Matrice_Taki(double x, double Y, Coord a1, Coord a2, Coord a3, Coord m1, Coord m2, Coord m3);
    void AppliquerMatriceCorrectionTaki(Coord * result, Coord vect);


    void CalculerMatriceCorrection(double ad, double de);


    double Surface_Triangle(double px1, double py1, double px2, double py2, double px3, double py3);
<<<<<<< .mine
    void   AzHa2XY(double az, double ha, double *x, double *y);
    bool   PointSitueDansSurfaceTriangle(double px, double py, double px1, double py1, double px2, double py2, double px3, double py3);
=======
    void AzHa2XY(double az, double ha, double *x, double *y);
    bool PointSitueDansSurfaceTriangle(double px, double py, double px1, double py1, double px2, double py2, double px3, double py3);
>>>>>>> .r680
    
    double Determinant();

    inline double Determinant();
    void   InitParametresInstrument();
    void   OptimisationGeometrieAntenne();
    double Alt2Motor(double targetAlt);
    inline double Motor2Alt(double pas);



    int MethodeAlignement;                      // Méthode d'alignement utilisée

    int nbrcorrections;                         // Nombre de points utilisés pour bâtir la ou les matrices de correction

    int AlignementEnCours;

    bool Matrice_ok;				// Il existe une matrice de correction applicable à la direction de l'observation

    long delta_az_polar;			// Correction en azimut de l'orientation de l'étoile polaire
    // C'est la première étape de l'alignement dans les mode AFFINE et TAKI
    
    long int deltaAZ;                           // delta en azimut et en hauteur pour une correction à la raquette
    long int deltaHA;                           // hors procédure d'alignement
    
    bool SelectionnePourCalculMatrice[MAXALIGNEMENTANTENNE];

    long int deltaAZ;                           // delta en azimut et en hauteur pour une correction à la raquette
    long int deltaHA;                           // hors procédure d'alignement

    bool SelectionnePourCalculMatrice[MAXALIGNEMENTANTENNE];

    double ad[MAXALIGNEMENTANTENNE];            // Coordonnées horaires d'un point de correction

    double de[MAXALIGNEMENTANTENNE];

    double tsl[MAXALIGNEMENTANTENNE];           // Temps sidéral local où les mesures en ar et dec ont été faites

    double delta_ad[MAXALIGNEMENTANTENNE];        // nbre de pas ajoutés en ascension droite et en déclinaison pour centrer l'objet visé

    double delta_de[MAXALIGNEMENTANTENNE];

    double MATRICE[4][4];                       // La matrices de correction calculée dans les trois modes d'alignement

    Coord  VECT_OFFSET;                      // Vecteur offset que l'on applique dans les modes affine/taki

    double GETLMN[4][4];                        // Matrices intermédiaires nécessaires pour le calcul des matrices de correction
    // dans les modes d'alignement AFFINE/TAKI
    double GETPQ[4][4];


    double BC;                          //Paramètres de l'instrument
    // Formule de Marc
    double CD;
    double ED;
    double AE;
    double I0;
    double CoeffMoteur;
    double Thau;

};

#endif
