////////////////////////////////
// Classe Astro               //
// Franck RICHARD             //
// BAORadio                   //
// franckrichard033@gmail.com //
// juin 2011                  //
////////////////////////////////

#ifndef Astro_class
#define Astro_class

#include "math.h"
#include "../communs/const.h"
#include "stdio.h"
#include "stdlib.h"
#include <iostream>
#include <string.h>
#include <sstream>
#include <iomanip>
#include "const.h"

using namespace std;




struct CoordonneesHoraires
{
    string ar;				// Coordonnées horaires d'un objet
    string dec;
};

struct CoordonneesHorairesDouble
{
    double ar;				// Coordonnées horaires d'un objet
    double dec;
};

class Astro 
{
public:
    Astro();
    ~Astro();

       
    void   DefinirDateHeure(double Annee, double Mois, double Jour, double Heu, double Min, double Sec);
    void   DefinirPressionTemp(double P, double T);
    void   DefinirLongitudeLatitude(double log, double lat);
    double VerifAngle(double Angle);
    double VerifDistance(double Angle);
    double DistanceAngulaireEntre2Points(double az1, double ha1, double az2, double ha2);
    double Arrondi(double a);
    string DHMS(double mema, bool HMS);
     void   Azimut(double Ar, double De, double *azi, double *hau);
    void   AzHa2ADDe(double Az, double Ha, double *AD, double *Dec);
    void   RechercheAzimutFinSuivi(double AD, double Dec, long int *azmin, long int *azmax);
    void   AzHa2ADDe(double Az, double Ha, double *AD, double *Dec);
    void   RechercheAzimutFinSuivi(double AD, double Dec, long int *azmin, long int *azmax);
    void   Precession(double *ar, double *de);
    void   NutationEtoile(double *ar, double *de);
    void   AberrationAnnuelle(double *ar, double *de);
    void   CalculJJ(double Heure);
    double CalculJJ(double A, double M, double J, double Heure);
    void   CalculTSL();  
    double RefractionAtmospherique(double ht);
    double CalculLongitudeSoleil();
    double TSL(double JJ,double HeureSiderale,double Longitude);
    bool    Decomposition(string chaine, char type, float *a1, float *a2, float *a3);
    void   Nutation();
    void   Obliquite(double JJ);
    void   atms ( double rt, double tt, double dnt, double gamal, double r,
                   double *dn, double *rdndr );
    void   atmt ( double robs, double tdkok, double alpha, double gamm2,
                   double delm2, double c1, double c2, double c3,
                   double c4, double c5, double c6, double r,
                   double *t, double *dn, double *rdndr );
    void   slaRefro ( double zobs, double hm, double tdk, double pmb,
                double rh, double wl, double phi, double tlr,
                double eps, double *ref );
    float  slaRange(float angle );
    double slaDrange(double angle );
    void   CalculARDecSoleil(CoordonneesHorairesDouble *Soleil);
    
    double GetLatitude()    { return Latitude;  }
    double GetLongitude()   { return Longitude; }
    double GetPression()    { return Pression;  }
    double GetTemperature() { return Temp;  }
    double GetAnnee()       { return Annee; }
    double GetMois()        { return Mois;  }
    double GetJour()        { return Jour;  }
    double GetHeure()       { return Heure; }
    double GetMin()         { return Min;   }
    double GetSec()         { return Sec;   }
    double GetJJ()          { return JJ;    }  
    double GetTSL()         { return tsl;   } 

  
     
private:
    
    double Pression;
    double Temp;
    double Longitude;
    double Latitude;
    double JJ;
    double CorP;
    double CorEP;
    double Annee;
    double Mois;
    double Jour;
    double Heure;
    double Min;
    double Sec;
    double ep;
    double hs;
    double UTCP;
    double tsl;
    double LongitudeSoleil;
  
};


#endif
