/*
 Pilote Indi BAORadio
 franckrichard033@gmail.com
 Décembre 2011
*/

#ifndef BAO_H
#define BAO_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>
#include <unistd.h>
#include <time.h>
#include <memory>
#include <pthread.h>
#include <iostream>
#include <time.h>
#include <unistd.h>
#include <sys/time.h>
#include <fstream>

#include <stdarg.h>

#include <termios.h>
#include <unistd.h>

#include <config.h>
#include "indicom.h"
#include "indidevapi.h"
#include "indicom.h"
#include "../communs/const.h"
#include "../communs/Socket.h"
#include "../communs/ServerSocket.h"
#include "../communs/SocketException.h"
#include "../communs/astro.h"
#include "../communs/alignement.h"


using namespace std;


struct Position
{
    long int x;
    long int y;
};


struct DefSocket
{
    ServerSocket new_sock;                  // socket permettant de gérer la connexion avec une antennes

    string IP;                              // IP de l'antenne

    char status;                            // status='B' pour bus,  'R' pour READY

    int sendalertes;                        // une requête 'send' a généré une erreur sur le réseau
    int AttenteExecution;	            // L'antenne parvient-elle à exécuter un cycle de commandes ?
    int AnomaliesExecution;	            // Erreur critique. L'antenne ne répond plus !
    int etape;                              // étape dans le cycle de commandes/réponses entre PC et micro-contrôleurs

    bool Connected;                         // le micro-contrôleur est-il connecté ?
    bool PosValides;                        // le micro-contrôleur a-t-il donné une position des moteurs valide ?
    bool ack_status;                        // Etat des acknowledges ?
    bool ack_pos;                           // le PC a-t-il reçu une confirmation du micro-contrôleurs après un ordre POSITION ?
    bool ack_park;	                    // le PC a-t-il reçu une confirmation du micro-contrôleurs après un ordre PARK ?
    bool ack_abort;                         // le PC a-t-il reçu une confirmation du micro-contrôleurs après un ordre ABORT ?
    bool ack_goto;                          // le PC a-t-il reçu une confirmation du micro-contrôleurs après un ordre GOTO ?
    bool GotoOk;                            // Est-ce que le dernier goto est OK ?

    Position TargetPosition;                // Position à atteindre
    Position Pos;                           // dernière position retournée par le micro-contrôleur 
    
    Alignement *AlignementAntenne;          // Contient les paramètres d'alignement de l'antenne  
}; 


// Le PC et les antennes communiquent par le biais du port 8000 sur le réseau Ethernet

ServerSocket server( BAO_PORT );         

class BAO : public Astro
{
public:
    BAO();
    ~BAO();

    /*******************************************************/
    /* Gestion de l'interface intégrée dans KStars
    ********************************************************/

    void ISGetProperties (const char *dev);
    void ISNewNumber (const char *dev, const char *name, double values[], char *names[], int n);
    void ISNewText (const char *dev, const char *name, char *texts[], char *names[], int n);
    void ISNewSwitch (const char *dev, const char *name, ISState *states, char *names[], int n);
    void ISPoll ();

    /*******************************************************/
    /* Gestion des threads
    ********************************************************/

    void *pThreadSocket ();
    void *pThreadExit ();

    /*******************************************************/
    /* Les commandes
    ********************************************************/

    bool COMMANDE(int numsocket, char* Commande, char* Params);
    bool ExtractPosition(string str, Position *result);
    bool STATUS(int numsocket);
    bool POSITION(int numsocket);
    bool ABORT(int numsocket);
    bool PARK(int numsocket);
    bool GOTO(int numsocket, int deltaAz, int deltaAlt);


    /*******************************************************/
    /* Connection Routines
    ********************************************************/
    void init_properties();
    void connect_telescope();
    bool is_connected(void);
    int  AntennesConnectees();
    void DeconnecterSocket(int num);
    void InitAntennes();


    /*******************************************************/
    /* Misc routines
    ********************************************************/
    bool process_coords();
    int  get_switch_index(ISwitchVectorProperty *sp);
    void ADDEC2Motor(double newRA, double newDEC);
    
  
    /*******************************************************/
    /* Simulation Routines
    ********************************************************/
    void enable_simulation(bool enable);

    /*******************************************************/
    /* Error handling routines
    ********************************************************/
    void reset_all_properties();
    void handle_error(INumberVectorProperty *nvp, int err, const char *msg);
    void correct_fault();
    void connection_lost();
    void connection_resumed();
    
    void AfficherLog(const char* Message,...);
    
    
  
    


private:

    enum BAO_STATUS { BAO_TRANSIT, BAO_TRACKING, BAO_PARK };

    // Paramètres par défaut d'un pilote indi

    /* Switches */
    ISwitch ConnectS[2];
    ISwitch OnCoordSetS[2];
    ISwitch AlignmentS[3];
    ISwitch AlignementAltp[1];
    ISwitch AlignementAz[2];
    ISwitch AlignementAltn[1]; 
    ISwitch AlignementOk[2];
    ISwitch RaquetteN[2];
    ISwitch AlignementReset[1];
    ISwitch AbortSlewS[1];
    ISwitch ParkS[1];

    /* Texts */
    IText PortT[1];
    IText ObjectT[1];
    IText CommandT[1];
    IText AlignementIP[1];

    /* Numbers */
    INumber EquatorialCoordsWN[2];
    INumber GeographicCoordsWN[2];
    INumber PressionTempWN[2];
    INumber ActualisationN1[1];
    INumber ActualisationN2[1];
    

    /* Switch Vectors */
    ISwitchVectorProperty ConnectSP;
    ISwitchVectorProperty OnCoordSetSP;
    ISwitchVectorProperty AlignmentSP;
    ISwitchVectorProperty AlignementAltpP;
    ISwitchVectorProperty AlignementAzP;
    ISwitchVectorProperty AlignementAltnP; 
    ISwitchVectorProperty AlignementOkP;
    ISwitchVectorProperty AlignementResetP;
    ISwitchVectorProperty RaquetteNP;
    ISwitchVectorProperty AbortSlewSP;
    ISwitchVectorProperty ParkSP;

    /* Number Vectors */
    INumberVectorProperty EquatorialCoordsWNP;
    INumberVectorProperty GeographicCoordsWNP;
    INumberVectorProperty PressionTempWNP;
    INumberVectorProperty ActualisationNP1;
    INumberVectorProperty ActualisationNP2;
    
    /* Text Vectors */
    ITextVectorProperty PortTP;
    ITextVectorProperty ObjectTP;
    ITextVectorProperty CommandTP;
    ITextVectorProperty AlignementIPP;



protected:

    int SocketsNumber;                   // nbre de sockets utilisés pour connecter les antennes
    bool InitThreadOK;                   // Le thread est-t-il  actif ?
    DefSocket Sockets[MAXHOSTNAME + 1];  // Définit chaque socket. Un socket permet la communication avec une antenne
    pthread_t th1;                       // le pointeur du thread

    double JD;				 // Jour julien
    double lastRA;                       // Sauvegarde de la dernière position avant actualisation, ici l'AD...
    double lastDEC;                      // ...et la déclinaison
    double JJAnc;                        // Sauvegarde du jour julien lors de la dernière actualisation de la position (fct Goto)
    double ActualisationTMTransit;       // Délai entre deux actualisations dans les modes transit (en sec)
    double ActualisationTMTracking;      //  "                 "                     "     tracking (en sec)
    double Longitude;			 // Longitude et latitude du lieu d'observation
    double Latitude;
    double Pression;			 // Pression et température sur le lieu d'observation
    double Temp;    
    bool   RealisationGoto;              // Permet de réaliser les différentes étapes nécessaires à la réalisation d'un goto
                                         // tant qu'un goto n'est pas terminé, ActualisationPosition = true
    bool   Abort;			 // Annulation du mouvement en cours
    bool   Park;			 // On place les antennes dans une position de repos
    bool   Suivi;			 // Est-ce que les antennes suivent actuellement un objet ?
    bool   UpdatedGoto;			 // On peut exécuter un Goto
    bool   Exit;                         // On ferme le driver

    int    currentSet;                   // mode de suivi actuel - tracking ou transit
    int    MethodeAlignement;            // Méthode d'alignement
    BAO_STATUS  TrackingMode;            // Mode de suivi actuellement activé
    
    long int azmincodeur;
    long int azmaxcodeur;  
    
    int    targetAlignmentIP;
    
    long int VitesseRaquette;
    long int delta_az;
    long int delta_ha;
    
   
};

#endif
