/**************************************************************************************
** Petit simulateur d'antenne
** BAORadio
** Franck RICHARD
***************************************************************************************/

#include "../communs/ClientSocket.h"
#include "../communs/SocketException.h"
#include <iostream>
#include <string>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <net/if.h> 
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>

using namespace std;


/**************************************************************************************
** Extraction de la position de l'antenne
**
***************************************************************************************/

Position ExtractPosition(std::string str)
{
    Position result;

    std::string str2, str3;

    result.x=-1;
    result.y=-1;

    int pos = str.find("#");

    if (pos!=string::npos)
    {
        str2 = str.substr(pos+2);

        pos = str2.find("Az");

        result.x=atoi(str2.substr(0, pos-1).c_str());

        pos = str2.find("#");

        if (pos!=string::npos)
        {
            str3 = str2.substr(pos+2);

            pos = str3.find("Alt");

            result.y=atoi(str3.substr(0, pos-1).c_str());;

        }
    }

    return result;
}

Position ExtractPosition2(std::string str)
{
    Position result;

    result.x=0;
    result.y=0;

    if (str.length() > 2)
    {
        result.x=atoi(str.substr(2, 4).c_str());

        result.y=atoi(str.substr(7, 4).c_str());

        if (str[1]=='f') result.x=-result.x;

        if (str[6]=='f') result.y=-result.y;
    }

    return result;
}

/**************************************************************************************
** Création de l'identifiant de l'antenne à partir de l'IP
**
***************************************************************************************/
/*
int NumeroServeur()
{
    std::string str, str2;

    int fd;
    struct ifreq ifr;

    fd=socket(AF_INET, SOCK_DGRAM, 0);

    ifr.ifr_addr.sa_family=AF_INET;

    strncpy(ifr.ifr_name, "eth0", IFNAMSIZ-1);

    ioctl(fd, SIOCGIFADDR, &ifr);

    close(fd);

    str=(std::string)inet_ntoa(((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr);

    int pos = str.find_last_of(".");

    if (pos!=string::npos)
    {
        str2 = str.substr(pos+1);

        return atoi(str2.c_str());
    }
  
    return -1;
}
*/


/**************************************************************************************
** MAIN
**
***************************************************************************************/

#define ERREURS 10

int main ( int argc, char *argv[] )
{
    Position Pos, Pos2;
    char cIP;
    char IP[20];
    bool Aleat;

    // Parametres sups
    bool ErreursAleatoires=false;
    bool Affichage=true;

    // Position PARK
    Pos.x=0;
    Pos.y=0;

    //init nbs aléatoires
    if (ErreursAleatoires) srand(time(NULL));

    

    std::cout <<  "******************\n";
    std::cout <<  "* Simulateur BAO *\n";
    std::cout <<  "******************\n\n";
    std::cout <<  "Adresse IP du serveur :\n";
    std::cout <<  "1)-  192.168.0.1\n";
    std::cout <<  "2)-  127.0.0.1\n\n? ";
    std::cin >> cIP;

    if (cIP=='1') strcpy(IP, "192.168.0.1");
    else strcpy(IP, "127.0.0.1");


    try
    {
       ClientSocket client_socket ( IP, 8000 );
        
       // ServerSocket socket ( 8000 );        
       // ServerSocket client_socket;
       // socket.accept ( client_socket );

        std::string reply;
        std::string asks,memasks;
        char chaine[5000];

        while (true)
        {
            
                client_socket.recv(asks);

                int pos=asks.find("\n");
                memasks=asks;
		
                while ((pos!=string::npos) && (asks.length()>1))
                {
                    memasks=asks.substr(pos+1);
                    asks=asks.substr(0,pos);

                    strcpy(chaine, "");

                   
                        if (ErreursAleatoires) Aleat=rand()%ERREURS != 1; else Aleat=1;

                        if (Affichage) std::cout <<  "Pilote BAO : " << asks << "\n" ;
         

			if (asks.find("P")!=string::npos)
                        {

                           strcpy(chaine,"ACK/POSITION\n");
                           client_socket << chaine;
//usleep(10000);
                            if (Affichage) std::cout <<  "Microcontrôleur : " << chaine;

                            if (Aleat)
                            {
                                sprintf(chaine, "POSITION/%05i/%05i/\n", Pos.x, Pos.y);
                            }
                            else
                            {
                                strcpy(chaine, "NACK/HALT/POSITION/\n");   //erreur moteur !
                            }
                        }

                        if (asks.find("G")!=string::npos)
                        {
			
                            Pos2=ExtractPosition2(asks);
			    
			    Pos.x-=Pos2.x;
			    Pos.y-=Pos2.y;

                            strcpy(chaine,"ACK/GOTO/\n");
                            client_socket << chaine;

                            if (Affichage)
			    { 
                               std::cout <<  "Microcontrôleur : " << chaine;

                               std::cout <<  "Positionnement de l antenne...\n";			       
                            }
                            
                            // sleep(20);

                            // sleep(rand()%10);

                            if (Aleat)
                            {
                                strcpy(chaine, "OK/GOTO/\n");
                            }
                            else
                            {
                                strcpy(chaine, "NACK/HALT/GOTO/\n");   //erreur moteur !
                            }
                        }

                        if (asks.find("Z")!=string::npos)
                        {

                            strcpy(chaine, "ACK/PARK\n");
                            client_socket << chaine;

                            if (Affichage) std::cout <<  "Microcontrôleur : " << chaine;

                            if (Aleat)
                            {
                                strcpy(chaine, "OK/PARK/\n");
                            }
                            else
                            {
                                strcpy(chaine, "NACK/HALT/PARK/\n");   //erreur
                            }
                        }

                        if (asks.find("A")!=string::npos)
                        {

                            strcpy(chaine,"ACK/ABORT\n");
                            client_socket << chaine;

                            if (Affichage) std::cout <<  "Microcontrôleur : " << chaine;

                            if (Aleat)
                            {
                                strcpy(chaine, "OK/ABORT/\n");
                            }
                            else
                            {
                                strcpy(chaine, "NACK/HALT/ABORT/\n");   //erreur
                            }
                        }

                        if (strlen(chaine)>1)
                        {
                            //   usleep(200);

                            client_socket << chaine;


                            if (Affichage)
                            {
                                std::cout <<  "Microcontrôleur : " << chaine;

                                std::cout <<  "---------\n";
                            }
                        }
                    

                    asks=memasks;
                    pos=asks.find("\n");
                }           
            
        }
    }
    catch ( SocketException& e )
    {
        std::cout << "Exception was caught:" << e.description() << "\n";
    }

    return 0;
}
