#ifndef BAOQT_H
#define BAOQT_H
#include <QtGui>
#include <QDialog>

#include <qlayout.h>

#include <qframe.h>
#include <QHBoxLayout>

#include "selectstars.h"
#include "liste.h"
#include "map.h"

#include "baocontrol.h"

#include "qledindicator.h"

#include "Joystick.h"

#include "Server.hpp"

#include "../communs/astro.h"

namespace Ui {
class BAOqt;
}

class BAOqt : public QDialog, public Server2, public Astro
{
    Q_OBJECT

public:
    explicit BAOqt(QWidget *parent = 0);
    ~BAOqt();

    void DisableButtons(bool b);

    void step(long long int timeout_micros);

    QList<QLedIndicator*> leds;
    QButtonGroup   *group;

    QDialog *dialog;

    BAOcontrol *bao;

    QTimer *timer;

    bool RechercheOptimisation;

    Joystick *joystick;


private slots :
    void on_pushButtonPark_clicked();
    void on_pushButtonCommande_clicked();
    void on_pushButtonAbort_clicked();
    void on_pushButtonAzM_clicked();
    void on_pushButtonAzP_clicked();
    void on_pushButtonHaM_clicked();
    void on_pushButtonHaP_clicked();
    void on_pushButton1x_clicked();
    void on_pushButton10x_clicked();
    void on_pushButtonIP_clicked();
    void on_pushButtonChoisir_clicked();
    void on_pushButtonSelectionner_clicked();
    void on_pushButtonValider_clicked();
    void on_pushButtonSauvegarder_clicked();
    void on_pushButtonReset_clicked();
    void on_pushButtonListe_clicked();
    void on_pushButtonMap_clicked();
    void on_pushButton1pt_clicked();
    void on_pushButtonGoto_clicked();
    void on_pushButtonTo00_clicked();
    void on_pushButtonScript_clicked();
    void on_pushButtonCalculMatrices_clicked();
    void on_pushButtonOptGeom_clicked();
    void on_pushButtonRetryGoto_clicked();
    void updateCaption();

private:
    Ui::BAOqt *ui;

private:
    void gotoReceived(unsigned int ra_int,int dec_int);
    double current_pos[3];
    double desired_pos[3];
    double last_pos[3];
    long long int next_pos_time;
};

#endif // BAOQT_H
