#include "map.h"
#include "ui_map.h"

Map::Map(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Map)
{
    ui->setupUi(this);

    numLies = 0;

    setlocale(LC_NUMERIC,"C");
}

Map::~Map()
{
    delete ui;
    
    close();
}


void Map::UpdateDatas()
{
    string chaine, suite;

    num = 0;

    numLies = 0;

    num3 = 0;

    if (Corrections == "") return;

    Corrections = Corrections.substr(Corrections.find("Corrections:") + 12);

    if (Corrections.find("/") != string::npos)
    {
        suite = Corrections.substr(0, Corrections.find("/") );
        Corrections = Corrections.substr(Corrections.find("/") + 1);

        chaine = suite.substr(0, suite.find(",") );
        suite = suite.substr(suite.find(",") + 1);

        targetaz = atof(chaine.c_str());

        chaine = suite.substr(0, suite.find(",") );
        suite = suite.substr(suite.find(",") + 1);

        targetha = atof(chaine.c_str());
    }

    if (Corrections.find("/") != string::npos)
    {
        suite = Corrections.substr(0, Corrections.find("/") );
        Corrections = Corrections.substr(Corrections.find("/") + 1);

        while (suite.find(",") != string::npos)
        {
            chaine = suite.substr(0, suite.find(",") );
            suite = suite.substr(suite.find(",") + 1);

            Lies[numLies++] = atoi(chaine.c_str());
        }
    }

    if (Corrections.find("/") != string::npos)
    {
        suite = Corrections.substr(0, Corrections.find("/") );
        Corrections = Corrections.substr(Corrections.find("/") + 1);
    }
    else
    {
        suite = Corrections;
        Corrections = "";
    }

    while (suite.find(",") != string::npos)
    {
        chaine = suite.substr(0, suite.find(",") );
        suite = suite.substr(suite.find(",") + 1);

        az[num] = atof(chaine.c_str());

        chaine = suite.substr(0, suite.find(",") );
        suite = suite.substr(suite.find(",") + 1);

        ha[num] = atof(chaine.c_str());

        chaine = suite.substr(0, suite.find(",") );
        suite = suite.substr(suite.find(",") + 1);

        az2[num] = atof(chaine.c_str());

        chaine = suite.substr(0, suite.find(",") );
        suite = suite.substr(suite.find(",") + 1);

        ha2[num] = atof(chaine.c_str());

        num++;
    }

    while (Corrections.find(",") != string::npos)
    {
        chaine = Corrections.substr(0, Corrections.find(",") );
        Corrections = Corrections.substr(Corrections.find(",") + 1);

        az3[num3] = atof(chaine.c_str());

        chaine = Corrections.substr(0, Corrections.find(",") );
        Corrections = Corrections.substr(Corrections.find(",") + 1);

        ha3[num3] = atof(chaine.c_str());

        num3++;
    }

}


void Map::paintEvent(QPaintEvent * /* event */)
{
    QPainter painter(this);
    
    char text[10];

    double xold   = 0.0;
    double yold   = 0.0;
    double xdebut = 0.0;
    double ydebut = 0.0;
    double r, x, y;
    
    painter.setPen(Qt::NoPen);

    painter.setBrush(Qt::black);

    painter.setRenderHint(QPainter::Antialiasing);

    painter.drawRect( MARGE, MARGE, SIZE, SIZE);

    painter.setPen(Qt::darkGray);

    painter.setBrush(Qt::NoBrush);

    for (int i=30; i<=80; i+=10)
    {
        double r = (90.0 - i) * SIZE / 60.0;

        painter.drawEllipse(QRectF(SIZE / 2.0 + MARGE - r/2.0, SIZE / 2.0 + MARGE - r/2.0, r, r));
    }

    painter.drawLine(MARGE, SIZE / 2.0 + MARGE, MARGE + SIZE, SIZE / 2.0 + MARGE);

    painter.drawLine(SIZE / 2.0 + MARGE, MARGE, SIZE / 2.0 + MARGE, SIZE + MARGE);


    painter.setPen(Qt::darkBlue);

    if (numLies == 3)
    {

        for (int i=0; i<numLies; i++)
        {
            double r = (90.0 - ha[Lies[i]] * N180divPi) * SIZE / 2.0 / 60.0;

            x = r * cos(-az[Lies[i]] - Pidiv2) + SIZE / 2.0 + MARGE;
	    
            y = r * sin(-az[Lies[i]] - Pidiv2) + SIZE / 2.0 + MARGE;

            if (i>0)
            {
                painter.drawLine(xold, yold, x, y);

            }
            else
            {
                xdebut=x;
		
                ydebut=y;
            }

            xold=x;
	    
            yold=y;
        }

        painter.drawLine(xdebut, ydebut, x, y);
    }

    painter.setPen(Qt::red);

    for (int i=0; i<num; i++)
    {
        r = (90.0 - ha[i] * N180divPi) * SIZE / 2.0 / 60.0;

        x = r * cos(-az[i] - Pidiv2) ;
	
        y = r * sin(-az[i] - Pidiv2) ;

        painter.drawEllipse(QRectF( SIZE / 2.0 + MARGE + x - 3.0,  SIZE / 2.0 + MARGE + y - 3.0, 6, 6));

        sprintf(text, "%i", i);

        painter.drawText(SIZE /2.0 + 20.0 + x, SIZE / 2.0 + 20.0 + y, QString( text ));
    }

    painter.setPen(Qt::green);

    for (int i=0; i<num; i++)
    {
        r = (90.0 - ha2[i] * N180divPi ) * SIZE / 2.0 / 60.0;

        x = r * cos(-az2[i] - Pidiv2) + SIZE / 2.0 + MARGE;

        y = r * sin(-az2[i] - Pidiv2) + SIZE / 2.0 + MARGE;

        painter.drawLine(x - 3.0, y - 3.0, x + 3.0, y + 3.0);

        painter.drawLine(x + 3.0, y - 3.0, x - 3.0, y + 3.0);
    }

    painter.setPen(Qt::yellow);

    for (int i=0; i<num; i++)
    {
        r = (90.0 - ha3[i] * N180divPi ) * SIZE / 2.0 / 60.0;

        x = r * cos(-az3[i] - Pidiv2) + SIZE / 2.0 + MARGE;

        y = r * sin(-az3[i] - Pidiv2) +  SIZE / 2.0 + MARGE;

        painter.drawLine(x - 3.0, y , x + 3.0, y );

        painter.drawLine(x, y - 3.0, x, y + 3.0);
    }


    r = (90.0 - targetha * N180divPi) * SIZE / 2.0 / 60.0;

    x = r * cos(-targetaz - Pidiv2) ;
    
    y = r * sin(-targetaz - Pidiv2) ;

    painter.drawEllipse(QRectF( SIZE / 2.0 + MARGE + x - 3.0,  SIZE / 2.0 + MARGE + y - 3.0, 6, 6));

}
