#include <QtGui>
#include "baoqt.h"
#include "baocontrol.h"
#include "ui_baoqt.h"



BAOqt::BAOqt(QWidget *parent) :
    QDialog(parent),
    Server2(STELLARIUM_PORT),
    ui(new Ui::BAOqt)
{
    QPoint pointPos;

    RechercheOptimisation = false;

    //Stellarium

    last_pos[0] = current_pos[0] = desired_pos[0] = 1.0;
    last_pos[1] = current_pos[1] = desired_pos[1] = 0.0;
    last_pos[2] = current_pos[2] = desired_pos[2] = 0.0;
    next_pos_time = -0x8000000000000000LL;


    bao = new BAOcontrol();

    dialog = new QDialog;

    ui->setupUi(dialog);

    for(int i=0; i<4; i++) {
        leds.append(new QLedIndicator(this));
    }

    for(int i=0; i<leds.size(); i++) {
        ui->layoutIndependent->addWidget(leds[i]);
    }

    pointPos.setX(1);
    pointPos.setY(1);

    dialog->move(pointPos);

    dialog->show();


    connect(ui->pushButtonPark, SIGNAL(clicked()), this, SLOT(on_pushButtonPark_clicked()));

    connect(ui->pushButtonCommande, SIGNAL(clicked()), this, SLOT(on_pushButtonCommande_clicked()));

    connect(ui->pushButtonAbort, SIGNAL(clicked()), this, SLOT(on_pushButtonAbort_clicked()));

    connect(ui->pushButtonAzM, SIGNAL(clicked()), this, SLOT(on_pushButtonAzM_clicked()));

    connect(ui->pushButtonAzP, SIGNAL(clicked()), this, SLOT(on_pushButtonAzP_clicked()));

    connect(ui->pushButtonHaP, SIGNAL(clicked()), this, SLOT(on_pushButtonHaP_clicked()));

    connect(ui->pushButtonHaM, SIGNAL(clicked()), this, SLOT(on_pushButtonHaM_clicked()));

    connect(ui->pushButton1x, SIGNAL(clicked()), this, SLOT(on_pushButton1x_clicked()));

    connect(ui->pushButton10x, SIGNAL(clicked()), this, SLOT(on_pushButton10x_clicked()));

    connect(ui->pushButtonIP, SIGNAL(clicked()), this, SLOT(on_pushButtonIP_clicked()));

    connect(ui->pushButtonChoisir, SIGNAL(clicked()), this, SLOT(on_pushButtonChoisir_clicked()));

    connect(ui->pushButtonSelectionner, SIGNAL(clicked()), this, SLOT(on_pushButtonSelectionner_clicked()));

    connect(ui->pushButtonValider, SIGNAL(clicked()), this, SLOT(on_pushButtonValider_clicked()));

    connect(ui->pushButtonSauvegarder, SIGNAL(clicked()), this, SLOT(on_pushButtonSauvegarder_clicked()));

    connect(ui->pushButtonReset, SIGNAL(clicked()), this, SLOT(on_pushButtonReset_clicked()));

    connect(ui->pushButtonListe, SIGNAL(clicked()), this, SLOT(on_pushButtonListe_clicked()));

    connect(ui->pushButtonMap, SIGNAL(clicked()), this, SLOT(on_pushButtonMap_clicked()));

    connect(ui->pushButton1pt, SIGNAL(clicked()), this, SLOT(on_pushButton1pt_clicked()));

    connect(ui->pushButtonGoto, SIGNAL(clicked()), this, SLOT(on_pushButtonGoto_clicked()));

    connect(ui->pushButtonTo00, SIGNAL(clicked()), this, SLOT(on_pushButtonTo00_clicked()));

    connect(ui->pushButtonScript, SIGNAL(clicked()), this, SLOT(on_pushButtonScript_clicked()));

    connect(ui->pushButtonCalculMatrices, SIGNAL(clicked()), this, SLOT(on_pushButtonCalculMatrices_clicked()));

    connect(ui->pushButtonOptGeom, SIGNAL(clicked()), this, SLOT(on_pushButtonOptGeom_clicked()));

    connect(ui->pushButtonRetryGoto, SIGNAL(clicked()), this, SLOT(on_pushButtonRetryGoto_clicked()));



#ifdef JOYSTICK
    
    joystick = new Joystick();

    if (joystick)
    {
      if (!joystick->init()) 
      {
	delete joystick;
	
	joystick = NULL;
	
	QMessageBox::information(this, tr("Jostick"), tr("Joystick inaccessible. Verifiez que le recepteur est bien branche sur un port USB."));
      }
    }
    
#endif

    ui->lineEditIP->setText("127.0.0.1");
    //ui->lineEditIP->setText("134.158.88.199");
    
    ui->lineEdit_2->setText((QString("BAORadio, LAL, version ").append(VERSION)).toStdString().c_str());

    // On laisse le temps au serveur de Stellarium de démarrer dans de bonnes conditions

    sleep(1);

    //Timer

    DisableButtons(true);

    ui->pushButton1x->setDown(false);
    
    ui->pushButton10x->setDown(true);

    timer = new QTimer(this);

    connect(timer, SIGNAL(timeout()), this, SLOT(updateCaption()));

    timer->start(100);
}

BAOqt::~BAOqt()
{
    close();

    timer->stop();

    delete timer;

    delete ui;
    delete dialog;
    delete bao;

#ifdef JOYSTICK
    if (joystick)
    {
        joystick->close();

        delete joystick;
    }
#endif


}


void BAOqt::step(long long int timeout_micros)
{
    if (last_pos[0]!=current_pos[0] || last_pos[1]!=current_pos[1] || last_pos[2]!=current_pos[2])
    {
        current_pos[0] = desired_pos[0];
        current_pos[1] = desired_pos[1];
        current_pos[2] = desired_pos[2];

        const double ra = atan2(current_pos[1],current_pos[0]);
        const double dec = atan2(current_pos[2],
                                 sqrt(current_pos[0]*current_pos[0]+current_pos[1]*current_pos[1]));

        // On passe les coordonnées aux antennes

        ui->lineEditEtoileSelectionneeAD->setText(QString(DHMS(VerifAngle(ra)*180.0/M_PI, true).c_str()));
        ui->lineEditEtoileSelectionneeDec->setText(QString(DHMS(dec*180.0/M_PI, false).c_str()));

        bao->Goto(DHMS(VerifAngle(ra)*180.0/M_PI, true), DHMS(dec*180.0/M_PI, false), bao->Transit, false);

        last_pos[0] = current_pos[0];
        last_pos[1] = current_pos[1];
        last_pos[2] = current_pos[2];
    }

    Server2::step(timeout_micros);
}

void BAOqt::gotoReceived(unsigned int ra_int, int dec_int)
{
    const double ra = ra_int*(M_PI/(unsigned int)0x80000000);
    const double dec = dec_int*(M_PI/(unsigned int)0x80000000);
    const double cdec = cos(dec);

    desired_pos[0] = cos(ra)*cdec;
    desired_pos[1] = sin(ra)*cdec;
    desired_pos[2] = sin(dec);

    last_pos[0] = -1000000L;
}

void BAOqt::DisableButtons(bool b)
{
    RechercheOptimisation = false;

    ui->pushButtonChoisir->setDisabled(b);

    ui->pushButtonSelectionner->setDisabled(b);

    ui->pushButtonValider->setDisabled(b);

    ui->pushButtonSauvegarder->setDisabled(b);

    ui->pushButtonReset->setDisabled(b);

    ui->pushButtonListe->setDisabled(b);

    ui->pushButtonMap->setDisabled(b);

    ui->pushButton1pt->setDisabled(b);

    ui->pushButtonCalculMatrices->setDisabled(b);

    ui->pushButtonOptGeom->setDisabled(b);
}

void BAOqt::updateCaption()
{
    static int StartStellariumServer = 0;
    static int joy = 0;

    if (RechercheOptimisation) return;

    bao->thread_process();

    const QString *var = new QString( bao->chaineDateHeure);

    ui->lineStatus->setText(*var);

    delete var;

    // Affichage des messages venant du serveur indi_BAO et récupérés par la fonction LireReponse()
    // Les messages d'erreurs sont affichés en rouge
    ui->textEdit->clear();

    for (int i=0; i<bao->lognum; i++)
    {
        if (i>bao->lognum-11)
        {
            if ((bao->logs[i].find("Err")!=string::npos)
                    || (bao->logs[i].find("ALERTE")!=string::npos))
            {
                ui->textEdit->setTextColor(QColor(255,0,0));
            }
            else
            {
                ui->textEdit->setTextColor(QColor(0,0,0));
            }

            ui->textEdit->append(bao->logs[i].c_str());
        }
    }

    // affichage des cercles d'état des antennes
    // vert = l'antenne fonctionne
    // rouge = problème détecté sur l'antenne
    // gris = antenne non connectée

    for (int i=0; i <4; i++)
    {
        switch (bao->Antennes[i].ok)
        {
        case 1 :
            leds[i]->red = false;
            leds[i]->setChecked( true );
            break;
        case 2 :

            leds[i]->red = true;
            leds[i]->setChecked( true );

            break;
        default:
            leds[i]->red = false;
            leds[i]->setChecked( false );
            break;
        }
    }

    dialog->repaint();

#ifdef JOYSTICK
    joy++;

    int max = 2000;

    if (joy>1)
    {
        joy = 0;

        JoystickStatus js;

        if (joystick)
        {
            if (joystick->GetStatus( js))
            {
                if (js.x < -max) on_pushButtonAzM_clicked();
                if (js.x > max)  on_pushButtonAzP_clicked();
                if (js.y < -max) on_pushButtonHaP_clicked();
                if (js.y > max)  on_pushButtonHaM_clicked();
                if (js.button1)
                {
                    on_pushButton1x_clicked();
                    ui->pushButton1x->setDown(true);
                    ui->pushButton10x->setDown(false);
                }
                if (js.button2)
                {
                    on_pushButton10x_clicked();
                    ui->pushButton1x->setDown(false);
                    ui->pushButton10x->setDown(true);
                }
            }
        }
    }
#endif


    if (StartStellariumServer < 10)
    {
        StartStellariumServer++;
    }
    else
    {
        step(1000);
    }
}

void BAOqt::on_pushButtonPark_clicked()
{
    RechercheOptimisation = false;

    bao->DecodageEntreesUtilisateur("park");
}

void BAOqt::on_pushButtonAbort_clicked()
{
    RechercheOptimisation = false;

    bao->DecodageEntreesUtilisateur("abort");
}

void BAOqt::on_pushButtonCommande_clicked()
{
    RechercheOptimisation = false;

    QString chaine = ui->lineEditCommande->text();

    bao->DecodageEntreesUtilisateur("send " + chaine.toStdString());
}

void BAOqt::on_pushButtonAzM_clicked()
{
    RechercheOptimisation = false;

    bao->AlignementDelta("-1", true);
}

void BAOqt::on_pushButtonAzP_clicked()
{
    RechercheOptimisation = false;

    bao->AlignementDelta("1", true);
}

void BAOqt::on_pushButtonHaM_clicked()
{
    RechercheOptimisation = false;

    bao->AlignementDelta("-1", false);
}

void BAOqt::on_pushButtonHaP_clicked()
{
    RechercheOptimisation = false;

    bao->AlignementDelta("1", false);
}

void BAOqt::on_pushButton1x_clicked()
{
    RechercheOptimisation = false;

    bao->VitesseAlignement(1);

    ui->pushButton1x->setDown(true);
    ui->pushButton10x->setDown(false);
}

void BAOqt::on_pushButton10x_clicked()
{
    RechercheOptimisation = false;

    bao->VitesseAlignement(10);

    ui->pushButton1x->setDown(false);
    ui->pushButton10x->setDown(true);
}

void BAOqt::on_pushButtonIP_clicked()
{
    RechercheOptimisation = false;

    QString chaine = ui->lineEditIP->text();

    if (bao->SelectionIP(chaine.toStdString()))
    {
        QMessageBox::information(this, tr("Selection d'une antenne pour l'alignement"), tr("L'antenne indiquee est maintenant prete pour l'alignement."));

        DisableButtons(false);
    }
    else
    {
        QMessageBox::information(this, tr("Selection d'une antenne pour l'alignement"), tr("Aucune antenne ne porte cette adresse IP !"));
    }
}

void BAOqt::on_pushButtonChoisir_clicked()
{
    RechercheOptimisation = false;

    bao->AlignementAntenneIP(ui->lineEditIP->text().toStdString());

    SelectStars selectstar;

    stringstream os;

    int NumListeEtoilesSelectionnees = 0;

    for (int i=0; i<bao->numEtoiles; i++)
    {
        if ( bao->Etoiles[i].selectionnee )
        {
            os.str("");
            os.width(20);
            os << bao->Etoiles[i].nom;
            os << " (" << bao->Etoiles[i].cons << "), ";
            string c ="az=" + bao->DHMS(bao->Etoiles[i].az * N180divPi, false) + ",     ";
            os << c.substr(0 ,17);
            c= "ha=" + bao->DHMS(bao->Etoiles[i].ha * N180divPi, false) + ",     ";
            os << c.substr(0, 17);
            os << " magnitude=";
            os << bao->Etoiles[i].mag;

            selectstar.Noms[NumListeEtoilesSelectionnees++] = os.str();
        }
    }

    selectstar.Num = NumListeEtoilesSelectionnees;

    selectstar.UpdateDatas();

    selectstar.exec();


    int EtoileSelectionnee = selectstar.NumSelectionne;

    if (EtoileSelectionnee != -1)
    {
        int NumListeEtoilesSelectionnees = 0;

        for (int i=0; i<bao->numEtoiles; i++)
        {
            if ( bao->Etoiles[i].selectionnee )
            {
                if ( NumListeEtoilesSelectionnees == EtoileSelectionnee )
                {
                    ui->lineEditEtoileSelectionneeAD->setText(  QString( bao->DHMS(bao->Etoiles[i].ad * N180divPi, true ).c_str()) );
                    ui->lineEditEtoileSelectionneeDec->setText( QString( bao->DHMS(bao->Etoiles[i].de * N180divPi, false).c_str()) );
                    on_pushButtonSelectionner_clicked();
                }

                NumListeEtoilesSelectionnees++;
            }
        }
    }
}

void BAOqt::on_pushButtonSelectionner_clicked()
{
    RechercheOptimisation = false;

    bao->Goto( ui->lineEditEtoileSelectionneeAD->text().toStdString(), ui->lineEditEtoileSelectionneeDec->text().toStdString(), bao->Transit, false);
}

void BAOqt::on_pushButtonValider_clicked()
{
    RechercheOptimisation = false;

    bao->ValidationAlignement();
}

void BAOqt::on_pushButtonSauvegarder_clicked()
{
    RechercheOptimisation = false;

    bao->SauvegardeAlignement();
}

void BAOqt::on_pushButtonReset_clicked()
{
    QMessageBox::StandardButton reply;

    RechercheOptimisation = false;

    reply = QMessageBox::question(this, tr("Reset alignement"),
                                  "Voulez-vous reinitialiser l'alignement de l'antenne ?",
                                  QMessageBox::Yes | QMessageBox::No );

    if (reply == QMessageBox::Yes) bao->ResetAlignement();
}

void BAOqt::on_pushButtonListe_clicked()
{
    Liste liste;

    RechercheOptimisation = false;

    stringstream os;

    int NumListeEtoilesSelectionnees = 0;

    for (int i=0; i<bao->numEtoiles; i++)
    {
        if ( bao->Etoiles[i].selectionnee )
        {
            os.str("");
            os.width(20);
            os << bao->Etoiles[i].nom;
            os << " (" << bao->Etoiles[i].cons << "), ";
            string c ="az=" + bao->DHMS(bao->Etoiles[i].az * N180divPi, false) + ",     ";
            os << c.substr(0 ,17);
            c= "ha=" + bao->DHMS(bao->Etoiles[i].ha * N180divPi, false) + ",     ";
            os << c.substr(0, 17);
            os << " magnitude=";
            os << bao->Etoiles[i].mag;

            liste.Noms[NumListeEtoilesSelectionnees++] = os.str();
        }
    }

    liste.Num = NumListeEtoilesSelectionnees;

    liste.UpdateDatas();

    liste.exec();
}

void BAOqt::on_pushButtonMap_clicked()
{
    Map map1;

    RechercheOptimisation = false;

    string str = bao->DecodageEntreesUtilisateur("send C");

    map1.Corrections = str;

    map1.UpdateDatas();

    map1.exec();
}

void BAOqt::on_pushButton1pt_clicked()
{
    static int etape = 1;

    RechercheOptimisation = false;

    switch (etape)
    {
    case 1:
    {
        etape=2;

        QMessageBox::information(this, tr("Alignement 1pt de l antenne"), tr("Choisissez un objet facile a pointer"));

        on_pushButtonGoto_clicked();

        QMessageBox::information(this, tr("Alignement 1pt de l antenne"), tr("Attendez la fin du pointage. Centrez l'objet dans le viseur et rappuyez sur le bouton 'alignement 1pt' pour terminer."));

    };
    break;

    case 2:
    {
        etape=1;

        QMessageBox::information(this, tr("Alignement 1pt de l antenne"), tr("Annulation du mouvement en cours."));

        bao->Abort();

        sleep(1);

        string str = bao->DecodageEntreesUtilisateur("send X");

        string str2;

        int x = 0;
        int y = 0;

        char a1='b';
        char a2='b';

        size_t pos = str.find("/");

        if (pos != string::npos)
        {
            str2 = str.substr(pos + 1);

            pos = str2.find("/");

            if (pos != string::npos)
            {
                x = atol( str2.substr(0, pos).c_str() );

                y = atol( str2.substr(pos + 1).c_str() );
            }
        }

        sleep(1);

        str = bao->DecodageEntreesUtilisateur("send D");

        int dx = 0;
        int dy = 0;

        pos = str.find("/");

        if (pos != string::npos)
        {
            str2 = str.substr(pos + 1);

            pos = str2.find("/");

            if (pos != string::npos)
            {
                dx = atol( str2.substr(0, pos).c_str() );

                x -= dx;

                dy = atol( str2.substr(pos + 1).c_str() );

                y -= dy;

                if ( x < 0 ) {
                    a1 = 'f';
                    x = -x;
                }

                if ( y < 0 ) {
                    a2 = 'f';
                    y = -y;
                }

                char chaine[100];

                sprintf(chaine, "send g%c%04df0000", a1, x);

                str = bao->DecodageEntreesUtilisateur(string(chaine));

                QMessageBox::information(this, tr("Alignement 1pt de l antenne"), tr("Attendez la fin du mouvement avant de cliquer sur OK."));


                sprintf(chaine, "send gf0000%c%04d", a2, y);

                str = bao->DecodageEntreesUtilisateur(string(chaine));
                QMessageBox::information(this, tr("Alignement 1pt de l antenne"), tr("Appuyez sur les deux boutons places dans la boite de l'antenne."));

                QMessageBox::StandardButton reply;

                reply = QMessageBox::question(this, tr("Alignement 1pt de l antenne"),
                                              "Voulez-vous reinitialiser les codeurs de l'antenne en envoyant la c ommande Park ?",
                                              QMessageBox::Yes | QMessageBox::No );

                if (reply == QMessageBox::Yes)
                {

                    str = bao->DecodageEntreesUtilisateur("send z");

                    sleep(1);

                    str = bao->DecodageEntreesUtilisateur("send p");
                }
                QMessageBox::information(this, tr("Alignement 1pt de l antenne"), tr("Fin de la procedure."));
            }
        }
    }
    break;
    }
}


void BAOqt::on_pushButtonGoto_clicked()
{
    bool ok;

    RechercheOptimisation = false;

    QString text = QInputDialog::getText(this, tr("Goto"),
                                         tr("Entrez le nom ou les coordonnees de l'objet a suivre"), QLineEdit::Normal,
                                         "", &ok);
    if (ok && !text.isEmpty())
        bao->DecodageEntreesUtilisateur("goto " + text.toStdString());

}

void BAOqt::on_pushButtonTo00_clicked()
{
    RechercheOptimisation = false;

    string str = bao->DecodageEntreesUtilisateur("send X");

    string str2;

    int x = 0;
    int y = 0;

    size_t pos = str.find("/");

    if (pos != string::npos)
    {
        str2 = str.substr(pos + 1);

        pos = str2.find("/");

        if (pos != string::npos)
        {
            char a1='b';
            char a2='b';

            x = atol( str2.substr(0, pos).c_str() );

            if ( x < 0 ) {
                a1 = 'f';
                x = -x;
            }

            y = atol( str2.substr(pos + 1).c_str() );

            if ( y < 0 ) {
                a2 = 'f';
                y = -y;
            }

            char chaine[100];

            sprintf(chaine, "send g%c%04d%c%04d", a1, x, a2, y);

            string str = bao->DecodageEntreesUtilisateur(string(chaine));
        }
    }
}

void BAOqt::on_pushButtonCalculMatrices_clicked()
{
    RechercheOptimisation = false;

    bao->DecodageEntreesUtilisateur("send m");
}

void BAOqt::on_pushButtonScript_clicked()
{

}

void BAOqt::on_pushButtonOptGeom_clicked()
{
    RechercheOptimisation = true;

    bao->DecodageEntreesUtilisateur("send o");
}

void BAOqt::on_pushButtonRetryGoto_clicked()
{
    RechercheOptimisation = true;

    RechercheOptimisation = false;

    bao->Goto( ui->lineEditEtoileSelectionneeAD->text().toStdString(), ui->lineEditEtoileSelectionneeDec->text().toStdString(), bao->Transit, false);
}
