#!/bin/bash

if  [ "$#" == 0 ] || [ "$1" == "--help" ]
then
echo "Installation du pilote BAO"
echo 
echo "Tapez :";
echo 
echo "'bao install' pour installer le pilote indi_bao et BAOcontrol"
echo "'bao install config' pour installer les fichiers de configuration"
echo "'bao clean' pour supprimer les fichiers inutiles issus de la compilation"
echo "'bao remove' pour supprimer le pilote et BAOcontrol de votre ordinateur"

echo
fi

if  [ "$1" == "clean" ]
then
cd libindi_build
make clean
rm -f *.cmake *.h *.txt Makefile *.pc 
rm -rf CMakeFiles/*
cd ../BAOcontrol
make clean
rm -f *.o *.cpp~ *.h~  BAOtest
cd ../BAOTest
make clean
cd ..
echo "Les fichiers ont été supprimés";
fi

if  [ "$1" == "remove" ]
then
rm /usr/bin/BAOcontrol
rm /usr/bin/BAOtest
echo "Les fichiers ont été supprimés";
fi


if  [ "$1" == "install" ] && [ "$#" == 1 ]
then
echo ;
echo ;
echo "*** Compilation du pilote BAO ***";
echo ;

cd libindi_build
cmake -DCMAKE_INSTALL_PREFIX=/usr . ../
make
make install
echo ;
echo ;
echo "*** Compilation de BAOcontrol  ***";
echo ;

cd ../BAOcontrol
qmake -project
qmake
make
cp BAOcontrol /usr/bin
chmod +x /usr/bin/BAOcontrol
echo ;
echo ;
echo "*** Compilation de BAOtest ***";
echo ;

cd ../BAOTest
make
make install
cd ..
echo ;
echo ;
echo "Fin de la compilation.";
fi

if  [ "$1" == "install" ] && [ "$2" == "config" ]
then 
cp BAOcontrol/baocontrol_params "/home/"$USER
echo "Le fichier baocontrol_params a été copié dans le répertoire /home/"$USER;
cp BAOcontrol/bao_catalogue.dat "/home/"$USER
echo "Le fichier bao_catalogue.dat a été copié dans le répertoire /home/"$USER;
fi



