#ifndef Const_h
#define Const_h

#include "math.h"

//////////////////////////////////////////
// Paramètres utilisés dans le logiciel //
//////////////////////////////////////////

#define VERSION "0.62"
#define VERSION_DATE "14/09/12"

//#define ET_UT 0.0
#define ET_UT 66.185

// Paramètres de l'instrument

#define ED0 243.2
#define CD0 111.01
#define BC0 242.5
#define AE0 44.68
#define I00 81.0
#define CoeffMoteur0 0.078947
#define Theta0 20.2345


// dimensions des tableaux

#define MAXLOG 100000
#define MAXOBJETS 1000
#define MAXETOILES 250
#define MAXANTENNES 50
#define MAXALIGNEMENTANTENNE 20
#define TAILLEMAXLOGS 3000000


// Taille maximale des chaines de caractères

#define MAXCARACTERES 1024


// nombre de pas sur l'axe azimut

#define NBREPASCODEURSAZ  4000

// Définition des limites autorisées pour l'azimut (en pas codeur)

#define MINAZCODEURS -1680
#define MAXAZCODEURS  3800


// Hauteur minimale au-dessus de laquelle un objet devient accessible à l'antenne

#define HAUTMIN 30.0


//////////////////////////////////////////
// Définition des méthodes d'alignement //
//////////////////////////////////////////


#define NONE 0
#define SIMPLE 1
#define AFFINE 2
#define TAKI 3

// Magnitude maximale des étoiles qui serviront à la procédure de calibration

#define MAGNITUDEMAXETOILESCALIBRATION 3.5


// distance minimale entre deux étoiles de référence utilisées par les méthodes d'alignement AFFINE et TAKI

#define MIN_DISTANCE_ALIGNEMENT 0.3


//////////////////////////////
// Constantes Mathématiques //
//////////////////////////////

#define Pi		3.14159265358979323846264338327
#define Pidiv180	0.01745329251994329576923690768
#define N180divPi	57.2957795130823208767981548141
#define Pi2          	6.28318530717958647692528676655
#define Pidiv2		1.57079632679489661923132169163

// 1 ' en rad

#define MINUTE_ARC 0.000290888209

// valeurs des angles (exprimés en rad) ajoutés à l'ascension droite et à la déclinaison lorsque
// l'utilisateur agit sur les touches fléchées durant la procédure d'alignement des antennes

#define PasDeltaAD ( 2.0 * MINUTE_ARC )
#define PasDeltaDe ( 2.0 * MINUTE_ARC )

#define PasDeltaHa ( 5.0 * MINUTE_ARC )
#define PasDeltaAz ( 5.0 * MINUTE_ARC )

#define gmax(A,B) ((A)>(B)?(A):(B))

#define gmin(A,B) ((A)<(B)?(A):(B))



/////////////////////////////////////////
// dimensions de la fenêtre graphique //
/////////////////////////////////////////

#define haut_fenetre 10+22*10
#define larg_fenetre 605


/////////////////////////////////////////
// couleurs utilisées dans le terminal //
/////////////////////////////////////////


#define red1 "\033[0;31m"
#define blue1 "\033[0;34m"
#define green1 "\033[0;32m"
#define black1 "\033[0;30m"
#define grey1 "\033[1;30m"
#define red2 "\033[1;31m"
#define blue2 "\033[1;34m"
#define green2 "\033[1;32m"
#define black2 "\033[1;30m"
#define grey2 "\033[1;37m"


////////////
// Macros //
////////////

#define SAFEDELETE(pointer) if ((pointer)) { delete ((pointer)); pointer = NULL; }

#define SAFEDELETE_TAB(pointer) if ((pointer)) { delete [] ((pointer)); pointer = NULL; }


/////////////////////////////////////////////
// Fonctionnement des trames sur le réseau //
// Ne pas modifier                         //
/////////////////////////////////////////////

// Port utilisé sur le réseau tcp/ip pour communiquer avec les antennes

#define BAO_PORT 8000

#define STELLARIUM_PORT 8001

// Délai maximum en ms d'attente de la réponse des micro-contrôleurs

#define MAX_DELAI_REPONSE 60

// Si une commande ne recoit pas d'acknowledge. Alors refaire 80 tentatives en renvoyant la commande

#define MAXATTENTE 80

// Si pas de réponse au bout de 80 tentatives -> erreur critique -> socket perdu ?

#define MAXANOMALIES 2

// attendre plus de 2 mn pour considérer qu'une antenne n'est pas en mesure de faire un goto

#define MAXANOMALIESGOTO 2000

// Durée (en sec) entre deux actualisations en mode tracking

#define UPDATETRACKINGDELAY 1.0

// Durée (en sec) entre deux actualisations en mode transit

#define UPDATETRANSITDELAY ( 15.0 * 60.0 )

#define JOYSTICK

#define JOY_DEV "/dev/input/js0"



#endif
