(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     26039,        566]
NotebookOptionsPosition[     25160,        531]
NotebookOutlinePosition[     25506,        546]
CellTagsIndexPosition[     25463,        543]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "a", "]"}], 
      RowBox[{"Cos", "[", "b", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "a", "]"}], 
      RowBox[{"Sin", "[", "b", "]"}]}], ",", 
     RowBox[{"Sin", "[", "a", "]"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.556526786827944*^9, 3.556526827328615*^9}, {
  3.5565271763397107`*^9, 3.5565271855189786`*^9}, {3.556527561240263*^9, 
  3.5565275899056273`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"sin12", "[", 
   RowBox[{"a1_", ",", "a2_", ",", "b1_", ",", "b2_"}], "]"}], ":=", " ", 
  RowBox[{"Norm", "[", 
   RowBox[{"Cross", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"a1", ",", "b1"}], "]"}], ",", 
     RowBox[{"u", "[", 
      RowBox[{"a2", ",", "b2"}], "]"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5565268962289934`*^9, 3.556526937853281*^9}, {
  3.556527381356373*^9, 3.5565274490184503`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin12", "[", 
  RowBox[{"0", ",", "0", ",", "x", ",", "y"}], "]"}]], "Input",
 CellChangeTimes->{{3.556527455169184*^9, 3.5565274646918945`*^9}, {
  3.556527617899024*^9, 3.556527623313577*^9}}],

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", "y", "]"}]}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.556527465050947*^9, {3.556527571850915*^9, 3.5565276243746424`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.5565276008439612`*^9, 3.5565276109396844`*^9}}],

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", "-", "y"}], "]"}], "]"}]], "Output",
 CellChangeTimes->{{3.5565276112829704`*^9, 3.5565276268712664`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sint", " ", "=", " ", 
  RowBox[{"sin12", "[", 
   RowBox[{
    RowBox[{"40", " ", "Degree"}], ",", 
    RowBox[{"45", " ", "Degree"}], ",", 
    RowBox[{"145", "  ", "Degree"}], ",", 
    RowBox[{"164", " ", "Degree"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5565276393387823`*^9, 3.556527697432102*^9}, {
  3.5565277394221973`*^9, 3.5565277477546797`*^9}, {3.556527903991444*^9, 
  3.5565279403288035`*^9}}],

Cell[BoxData[
 RowBox[{"\[Sqrt]", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"35", " ", "\[Degree]"}], "]"}], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"40", " ", "\[Degree]"}], "]"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"16", " ", "\[Degree]"}], "]"}]}], 
         SqrtBox["2"]]}], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"16", " ", "\[Degree]"}], "]"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"40", " ", "\[Degree]"}], "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"35", " ", "\[Degree]"}], "]"}]}], 
        SqrtBox["2"]]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"35", " ", "\[Degree]"}], "]"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"40", " ", "\[Degree]"}], "]"}]}], 
        SqrtBox["2"]], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"16", " ", "\[Degree]"}], "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"40", " ", "\[Degree]"}], "]"}]}], 
        SqrtBox["2"]]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"40", " ", "\[Degree]"}], "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"35", " ", "\[Degree]"}], "]"}]}], 
        SqrtBox["2"]], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"16", " ", "\[Degree]"}], "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"40", " ", "\[Degree]"}], "]"}]}], 
        SqrtBox["2"]]}], ")"}], "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.5565276982591085`*^9, 3.5565277489873877`*^9, {3.556527923072323*^9, 
   3.556527941623745*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "sint", "]"}], "/", "Degree"}], "]"}]], "Input",
 CellChangeTimes->{{3.556527772393736*^9, 3.556527790194933*^9}, {
  3.5565278552839737`*^9, 3.5565278818686695`*^9}, {3.5565280028634176`*^9, 
  3.556528006904258*^9}, {3.5565291516782513`*^9, 3.556529154080698*^9}}],

Cell[BoxData["14.831353017191299`"], "Output",
 CellChangeTimes->{
  3.5565277786186943`*^9, {3.556527865705709*^9, 3.5565278822586975`*^9}, {
   3.5565279260210447`*^9, 3.556527945228738*^9}, 3.556528007497123*^9, 
   3.556529154829512*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Func", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"5", " ", 
     RowBox[{"10", "^", "4"}]}], " ", "+", " ", 
    RowBox[{"28", " ", 
     RowBox[{"10", "^", "4"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", 
          RowBox[{"BesselJ", "[", 
           RowBox[{"1", ",", 
            RowBox[{"2", " ", "Pi", " ", 
             RowBox[{"1.5", "/", "0.21"}], " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"14.8", " ", "Degree", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"t", "-", "1250"}], ")"}], "/", "3600."}]}], 
              "]"}]}]}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", " ", "Pi", " ", 
          RowBox[{"1.5", "/", "0.21"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"14.8", " ", "Degree", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t", "-", "1250"}], ")"}], "/", "3600"}]}], "]"}]}], 
         ")"}]}], ")"}], "^", "2"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.5565311788437047`*^9, 3.556531204555276*^9}, {
  3.5565313852843466`*^9, 3.55653138671649*^9}, {3.5565314317809963`*^9, 
  3.5565314531011276`*^9}, {3.5565322967047358`*^9, 3.5565323238387356`*^9}, {
  3.5565324605477357`*^9, 3.5565324669967356`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Func", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3500"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "All"}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1.2"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick", ",", "Dashed"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.556528528900959*^9, 3.5565285844064703`*^9}, {
  3.5565286223773575`*^9, 3.556528798659583*^9}, {3.556528832995403*^9, 
  3.556528838939041*^9}, {3.5565288742420673`*^9, 3.5565290186066923`*^9}, {
  3.55652908765462*^9, 3.556529087997827*^9}, {3.556529140087229*^9, 
  3.556529216793904*^9}, {3.5565292783051033`*^9, 3.556529320706176*^9}, {
  3.5565293555099983`*^9, 3.5565293715937014`*^9}, {3.556529720739235*^9, 
  3.556529748803635*^9}, {3.5565311949333134`*^9, 3.556531257072527*^9}, {
  3.556531299164736*^9, 3.556531302597079*^9}, {3.5565322750817356`*^9, 
  3.5565322797847357`*^9}, {3.5565324730997353`*^9, 3.556532475171736*^9}, {
  3.5565333112309313`*^9, 3.556533322007009*^9}, {3.5565338738601885`*^9, 
  3.556533874241227*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[Large], Dashing[{Small, Small}], 
    LineBox[CompressedData["
1:eJwd2nk8VG8XAHAUSfahQsiSKBKhsuTc7EQSColCyp4tWSNKC2FslXXGDEab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     "]]}},
  AspectRatio->1.2,
  Axes->True,
  AxesOrigin->{0, 50000.},
  ImageSize->{452.00048108996316`, Automatic},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.5565287174293756`*^9, 3.556528762435953*^9, 3.5565288000323915`*^9, 
   3.5565288399530478`*^9, {3.556528886862548*^9, 3.5565289346302776`*^9}, {
   3.5565289821799917`*^9, 3.5565290200419197`*^9}, 3.5565290891678495`*^9, 
   3.5565291640336895`*^9, {3.5565292032216425`*^9, 3.5565292171995115`*^9}, {
   3.556529281440724*^9, 3.5565293211897783`*^9}, 3.5565293722177057`*^9, {
   3.5565297264488354`*^9, 3.556529750192035*^9}, 3.5565312628311024`*^9, 
   3.5565313034661655`*^9, 3.556531392209039*^9, {3.556531435661384*^9, 
   3.5565314565374713`*^9}, 3.556532328190736*^9, 3.5565324759137354`*^9, {
   3.5565333138811965`*^9, 3.556533322884097*^9}, 3.5565338748142843`*^9}]
}, Open  ]]
},
WindowSize->{707, 867},
WindowMargins->{{476, Automatic}, {Automatic, 199}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 564, 16, 31, "Input"],
Cell[1124, 38, 467, 12, 31, "Input"],
Cell[CellGroupData[{
Cell[1616, 54, 218, 4, 31, "Input"],
Cell[1837, 60, 370, 11, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2244, 76, 135, 2, 31, "Input"],
Cell[2382, 80, 181, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2600, 89, 437, 10, 31, "Input"],
Cell[3040, 101, 2034, 62, 142, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5111, 168, 337, 6, 31, "Input"],
Cell[5451, 176, 241, 4, 30, "Output"]
}, Open  ]],
Cell[5707, 183, 1393, 36, 132, "Input"],
Cell[CellGroupData[{
Cell[7125, 223, 1214, 23, 52, "Input"],
Cell[8342, 248, 16802, 280, 530, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

