#ifndef MEMPHYSTrackingAction_h
#define MEMPHYSTrackingAction_h

//Geant4
#include "G4UserTrackingAction.hh"
#include "globals.hh"

//std
#include <set>


class G4Track;

//JEC 10/1/06 introduce MEMPHYS
namespace MEMPHYS {

class MEMPHYSTrackingAction : public G4UserTrackingAction {
 public:
   MEMPHYSTrackingAction();
  virtual ~MEMPHYSTrackingAction();

  void PreUserTrackingAction (const G4Track* aTrack);
  void PostUserTrackingAction(const G4Track* aTrack);

private:
  std::set<G4String> ProcessList;
  std::set<G4int> ParticleList;
  
  //JEC 15/11/05 add these parameters (may be later on a messenger)
  G4float percentageOfCherenkovPhotonsToDraw;
  G4float thresholdTobeSaved;
};
}

#endif


