#ifndef MEMPHYSWCDigitizer_h
#define MEMPHYSWCDigitizer_h 1

//Geant4
#include "G4VDigitizerModule.hh"
#include "globals.hh"
#include "Randomize.hh"

//MEMPHYS
#include "MEMPHYS/MEMPHYSWCDigi.hh"

//JEC 10/1/06 introduce MEMPHYS
namespace MEMPHYS {

class MEMPHYSWCDigitizer : public G4VDigitizerModule {
public:
  
  MEMPHYSWCDigitizer(G4String name);
  virtual ~MEMPHYSWCDigitizer();
  
  void SetPMTSize(G4float inputSize) {PMTSize = inputSize;}
  void Digitize();
  
private:
  static void Threshold(double& pe,int& iflag){
    double x = pe+0.1; iflag=0;
    double thr; double RDUMMY,err;
    if ( x<1.1) {
      thr = std::min(1.0,
	     -0.06374+x*(
	        3.748+x*(
	       -63.23+x*(
		452.0+x*(
	      -1449.0+x*(
	       2513.0+x*(
	       -2529.+x*(
               1472.0+x*(
               -452.2+x*(
                51.34+x*2.370))))))))));
    } else {
      thr = 1.0;
    }
    RDUMMY = G4UniformRand();
    if (thr < RDUMMY) {
      pe = 0.0;
      iflag = 1;
    } else {
      err = G4RandGauss::shoot(0.0,0.03);
      pe = pe+err;
    }
  }//Threshold

  static const double offset; // hit time offset
  static const double pmtgate; // ns
  static const double eventgateup; // ns
  static const double eventgatedown; // ns
  static const double LongTime; // ns
  static const int GlobalThreshold; //number of hit PMTs within an <=200ns sliding window that decides the global trigger t0

  G4int triggerhisto[20000]; // for finding t0
  G4float RealOffset;  // t0 = offset corrected for trigger start
  G4float MinTime;  // very first hit time

  MEMPHYSWCDigitsCollection*  DigitsCollection;
  
  G4float PMTSize;
};

}
#endif








