#ifndef MEMPHYSWCHit_h
#define MEMPHYSWCHit_h 1

//Geant4
#include "G4VHit.hh"
#include "G4THitsCollection.hh"
#include "G4Allocator.hh"
#include "G4Transform3D.hh"
#include "G4ThreeVector.hh"
#include "G4LogicalVolume.hh"
#include "G4ios.hh"
#include "G4Colour.hh"


//std
#include <algorithm> // for sort, find, count_if
#include <functional> //for less_equal, bind2nd,...

//JEC 10/1/06 introduce MEMPHYS
namespace MEMPHYS {

class MEMPHYSWCHit : public G4VHit {
 public:
  
  MEMPHYSWCHit();
  virtual ~MEMPHYSWCHit();
  G4int operator==(const MEMPHYSWCHit&) const;
  
  inline void* operator new(size_t);
  inline void  operator delete(void*);
  
  void Draw(); //JEC FIXME what do we do with this?
  void Print();
  //JEC 1/12/05 implement same mechanism as Trajectory
  virtual const std::map<G4String,G4AttDef>* GetAttDefs() const;
  virtual std::vector<G4AttValue>* CreateAttValues() const;


  
 public:
  
  void SetTubeID       (G4int tube)                 { tubeID = tube; }
  void SetTrackID      (G4int track)                { trackID = track; }
  void SetEdep         (G4double de)                { edep = de; }
  //  void SetPos          (G4ThreeVector xyz)          { pos = xyz; }
  // void SetRot          (G4RotationMatrix rotMatrix) { rot = rotMatrix; }
  void SetTransform (G4Transform3D aTrans) { transform = aTrans; }
  void SetLogicalVolume(G4LogicalVolume* logV)      { pLogV = logV;}
  void SetColour(G4Colour aColour) { colour = aColour; }
  void UpdateColour(); //modify color at the end of the event

  // This is temporarily used for the drawing scale
  void SetMaxPe(G4int number = 0)  {maxPe   = number;}

  void AddPe(G4float hitTime);  

  G4int         GetTubeID()     { return tubeID; }
  G4int         GetTrackID()    { return trackID; }
  //G4ThreeVector GetPos()        { return pos; }
  G4int         GetTotalPe()    { return totalPe;}
  G4float       GetTime(int i)  { return time[i]; }
  G4Transform3D GetTransform()  { return transform; }
  G4LogicalVolume* GetLogicalVolume() { return pLogV; }
  G4Colour GetColour() { return colour; }
  
  
  void SortHitTimes() {   sort(time.begin(),time.end()); }
  G4int GetPeInGate(double pmtgate,double evgate);


 private:
  MEMPHYSWCHit(const MEMPHYSWCHit&);
  const MEMPHYSWCHit& operator=(const MEMPHYSWCHit&);
  
  G4int            tubeID;
  G4int            trackID;
  G4double         edep;
  //G4ThreeVector    pos;
  //G4RotationMatrix rot;

  //JEC to GB
  G4Colour         colour;
  G4Transform3D    transform;
  G4LogicalVolume* pLogV;

  // This is temporarily used for the drawing scale
  // Since its static *every* WChit sees the same value for this.
  static G4int     maxPe;

  G4int                 totalPe;
  std::vector<G4float>  time;
  G4int                 totalPeInGate;
};
}

//----------------------------------------------------------------

//JEC 10/1/06 introduce MEMPHYS
namespace MEMPHYS {
  typedef G4THitsCollection<MEMPHYSWCHit> MEMPHYSWCHitsCollection;
  extern G4Allocator<MEMPHYSWCHit> MEMPHYSWCHitAllocator;
}

inline void* MEMPHYS::MEMPHYSWCHit::operator new(size_t) {
  void *aHit;
  aHit = (void *) MEMPHYS::MEMPHYSWCHitAllocator.MallocSingle();
  return aHit;
}

inline void MEMPHYS::MEMPHYSWCHit::operator delete(void *aHit) {
  MEMPHYS::MEMPHYSWCHitAllocator.FreeSingle((MEMPHYS::MEMPHYSWCHit*) aHit);
}

#endif
