// Geant4:
#include "G4ios.hh"
#include "G4RunManager.hh"
#include "G4UImanager.hh"

//MEMPHYS:
#include "MEMPHYS/MEMPHYSAnalysis.hh"
#include "MEMPHYS/MEMPHYSDetectorConstruction.hh"
#include "MEMPHYS/MEMPHYSPhysicsList.hh"
#include "MEMPHYS/MEMPHYSPhysicsMessenger.hh"
#include "MEMPHYS/MEMPHYSPrimaryGeneratorAction.hh"
#include "MEMPHYS/MEMPHYSEventAction.hh"
#include "MEMPHYS/MEMPHYSRunAction.hh"
#include "MEMPHYS/MEMPHYSStackingAction.hh"
#include "MEMPHYS/MEMPHYSTrackingAction.hh"
#include "MEMPHYS/MEMPHYSSteppingAction.hh"


//JEC AIDA :
#include <AIDA/IAnalysisFactory.h>

// std::
#include <iostream>

//JEC Lib :
#include <Lib/System.h>

/////////////////////////////////////////////////////////////////
int main(
	 int //aArgc 
	 , char** //aArgv
	 )
{
  //AIDA Analysis factory
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cout << "MEMPHYS_batch :"
              << " AIDA not found." << std::endl;
    return 0;
  }
  //Book all the histo, tuple 
  MEMPHYS::MEMPHYSAnalysis* analysis = new MEMPHYS::MEMPHYSAnalysis(*aida);


  // Construct the default run manager
  G4RunManager* runManager = new G4RunManager;

  // UserInitialization classes (mandatory)



  //JEC 18/11/05 give the "analysis" to fill geometry ITuple
  MEMPHYS::MEMPHYSDetectorConstruction* MEMPHYSdetector = 
    new MEMPHYS::MEMPHYSDetectorConstruction(*analysis); 

  runManager->SetUserInitialization(MEMPHYSdetector);

  runManager->SetUserInitialization(new MEMPHYS::MEMPHYSPhysicsList);

  G4UImanager* UI = G4UImanager::GetUIpointer();
  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/jobOptions.mac"; //JEC FIXME this comes from JHF
    UI->ApplyCommand("/control/execute "+file);  
  }



  // Set user action classes
  MEMPHYS::MEMPHYSPrimaryGeneratorAction* myGeneratorAction = new MEMPHYS::MEMPHYSPrimaryGeneratorAction(MEMPHYSdetector);
  runManager->SetUserAction(myGeneratorAction);

  MEMPHYS::MEMPHYSRunAction* myRunAction = new MEMPHYS::MEMPHYSRunAction();

  runManager->SetUserAction(myRunAction);


  runManager->SetUserAction(new MEMPHYS::MEMPHYSEventAction(*analysis,
						   myRunAction, 
						   MEMPHYSdetector,
						   myGeneratorAction));
  runManager->SetUserAction(new MEMPHYS::MEMPHYSTrackingAction);

  runManager->SetUserAction(new MEMPHYS::MEMPHYSStackingAction);
  runManager->SetUserAction(new MEMPHYS::MEMPHYSSteppingAction); //JEC 15/12/05 Add user SteppingAction

  // Initialize G4 kernel
  runManager->Initialize();

  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/init.g4m"; //JEC FIXME this comes from JHF
    UI->ApplyCommand("/control/execute "+file);  
  }

  runManager->BeamOn(1);


  //JEC interactive session  delete visManager;

  delete runManager;
  delete analysis;
  delete aida;
  return 0;
}


