
// Geant4:
#include "G4ios.hh"
#include "G4RunManager.hh"
#include "G4UImanager.hh"

//AIDA :
#include <AIDA/IAnalysisFactory.h>

// std::
#include <iostream>

// Lib :
#include <Lib/Interfaces/IManager.h>
#include <Lib/System.h>
#include <Lib/Cast.h>

// G4Lab :
#include <G4Lab/UIOnX.h>
#include <G4Lab/TrackingAction.h>
#include <G4Lab/Helpers.h>
#include <G4Lab/DigitsCollectionType.h>

//MEMPHYS:
#include "MEMPHYS/Analysis.hh"
#include "MEMPHYS/DetectorConstruction.hh"
#include "MEMPHYS/PhysicsList.hh"
#include "MEMPHYS/PhysicsMessenger.hh"
#include "MEMPHYS/PrimaryGeneratorAction.hh"
#include "MEMPHYS/EventAction.hh"
#include "MEMPHYS/RunAction.hh"
#include "MEMPHYS/StackingAction.hh"
#include "MEMPHYS/TrackingAction.hh"
#include "MEMPHYS/SteppingAction.hh"
#include "MEMPHYS/WCDigi.hh"

// Create a manager to access the MEMPHYSAnalysis from the callbacks :

//JEC 10/1/06 introduce MEMPHYS namespace
namespace MEMPHYS {

class AnalysisManager 
  :public virtual IManager
  ,public Analysis  {
 public: //IManager
  virtual const std::string& name() const { return fName;}
  virtual void* cast(const std::string& aTo) const {
    if(aTo=="MEMPHYS::AnalysisManager") {
      return Lib_SCast(MEMPHYS::AnalysisManager);
    } else if(aTo=="MEMPHYS::IAnalysis") {
      return Lib_SCast(MEMPHYS::IAnalysis);
    } else if(aTo=="MEMPHYS::Analysis") {
      return Lib_SCast(MEMPHYS::Analysis);
    } else if(aTo=="IManager") {
      return Lib_SCast(IManager);
    } else {
      return 0;
    }
  }
 public:
  AnalysisManager(AIDA::IAnalysisFactory& aAIDA,bool aBatch)
    :Analysis(aAIDA,aBatch),fName("MEMPHYS::AnalysisManager") {}
  virtual ~AnalysisManager(){}
 private:
  std::string fName;
};
}

//////////////////////////////////////////////////////////////////////////////
int main(
	 int aArgc
	 ,char** aArgv
	 ) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //Lib::Debug::checkByClass(true);

  G4RunManager* runManager = new G4RunManager;

  // Need to pass the G4RunManager at UIOnX creation
  std::string gui = "$MEMPHYSROOT/scripts/OnX/MEMPHYS_session.onx";
  G4Lab::UIOnX* session = new G4Lab::UIOnX(*runManager,gui,aArgc,aArgv);

  MEMPHYS::AnalysisManager* analysisManager = 0;

  AIDA::IAnalysisFactory* aida = G4Lab::UIOnX_aida(*session);
  if(!aida) {
    std::cout << "MEMPHYS_session : AIDA not found." << std::endl;
  } else {
    analysisManager = new MEMPHYS::AnalysisManager(*aida,false);
    session->addManager(analysisManager);
  }
  if(session->session()) {
    //GB 07/12/2005 : declare DigitsCollections types.
    //FIXME : Why can't we be generic as for hits collection ?
    //FIXME : From G4VDigiCollection, we can't loop on G4VDigi !
    session->addType
      (new G4Lab::DigitsCollectionType<MEMPHYS::WCDigi>
        (*(session->session()),"WCDigitizedCollection"));
  }

  G4UImanager* UI = G4UImanager::GetUIpointer();
  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/jobOptions.mac";
    UI->ApplyCommand("/control/execute "+file);  
  }

  
  //JEC 18/11/05 give the "analysis" to fill geometry ITuple
  MEMPHYS::DetectorConstruction* MEMPHYSdetector = 
    new MEMPHYS::DetectorConstruction(*analysisManager); 

  runManager->SetUserInitialization(MEMPHYSdetector);

  runManager->SetUserInitialization(new MEMPHYS::PhysicsList);

  // Set user action classes
  MEMPHYS::PrimaryGeneratorAction* myGeneratorAction = 
    new MEMPHYS::PrimaryGeneratorAction(MEMPHYSdetector);
  runManager->SetUserAction(myGeneratorAction);

  MEMPHYS::RunAction* myRunAction = new MEMPHYS::RunAction();

  runManager->SetUserAction(myRunAction);


  runManager->SetUserAction(new MEMPHYS::EventAction(*analysisManager,
						   myRunAction, 
						   MEMPHYSdetector,
						   myGeneratorAction));
  runManager->SetUserAction(new MEMPHYS::TrackingAction);

  runManager->SetUserAction(new MEMPHYS::StackingAction);

  runManager->SetUserAction(new MEMPHYS::SteppingAction); //JEC 15/12/05 Add user SteppingAction

  // Initialize G4 kernel
  runManager->Initialize();

  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/init.g4m";
    UI->ApplyCommand("/control/execute "+file);  
  }


  // Main UI loop :
  session->SessionStart();

  delete session; //It will delete the analysisManager.

  delete runManager;

  return 0;
}

