#!/bin/csh -f

#
# File produced by the obuild tool version 1.0
# for the package snovis with version v1r0.
#

#////////////////////////////////////////////////
# Usage :
#   csh> source setup.csh
#////////////////////////////////////////////////

#set verbose  # uncomment this line to have full verbosity.

#////////////////////////////////////////////////
# Set the absolute path of this package.
# If in the below line there is the keyword :
#
#     @@absolute_dir@@
#
# then the package had not been installed.
#
#  Someone has to replace @@absolute_dir@@
# by the absolute path of the package.
# By "absolute path of the package", we mean that
# if the obuild directory of the package is 
# found under :
#    some_path/pack/vers/obuild
# then the "absolute path of the package" is :
#    some_path/pack/vers
#
#  This replacement can be done on the setup
# scripts of the package by using the sh/build 
# with the -i option.
#
#  This replacement can be done recursively
# on the setups of the used packages by using 
# the sh/build script with the -bci option 
# ("bci" for broadcast install).
#
#////////////////////////////////////////////////

set obuild_snovis_path="@@absolute_dir@@"


if ( "${obuild_snovis_path}" == '@@absolute_dir@@' ) then
  echo '  The package snovis had not been installed.'
  echo ''
  echo ' In the file :'
  echo '    snovis/<vers>/obuild/setup.csh'
  echo ' someone has to replace '
  echo '    @@absolute_dir@@'
  echo ' by the absolute path of the package.'
  echo '  By "absolute path of the package", we mean that'
  echo ' if the obuild directory of the package is found under :'
  echo '    some_path/pack/vers/obuild'
  echo ' then the "absolute path of the package" is :'
  echo '    some_path/pack/vers'
  echo ''
  echo '  If having the write access, this replacement can be done'
  echo ' on the setup scripts of the package by using the sh/build'
  echo ' with the -i option. This replacement can be done recursively'
  echo ' on the setups of the used packages by using the sh/build script'
  echo ' with the -bci option ("bci" for broadcast install).'
  echo ''
  exit
endif

if ( $?OBUILD_PLATFORM ) then
  if ( "${OBUILD_PLATFORM}" == "" ) then
    set obuild_platform=`uname`
  else
    set obuild_platform=${OBUILD_PLATFORM}
  endif
else
  set obuild_platform=`uname`
endif

if ( "${obuild_platform}" == "" ) then
  echo "obuild_platform variable not defined."
  exit
endif

if ( $?OBUILD_DIR_BIN ) then
  if (  "${OBUILD_DIR_BIN}" == "" ) then
    set obuild_dir_bin=${obuild_platform}_obuild
  else
    set obuild_dir_bin=${OBUILD_DIR_BIN}
  endif
else
  set obuild_dir_bin=${obuild_platform}_obuild
endif

if ( "${obuild_dir_bin}" == "" ) then
  echo "obuild_dir_bin variable not defined."
  exit
endif

if ( ! -e "${obuild_snovis_path}/${obuild_dir_bin}/obuild_platform" ) then
  if ( ! -e "${obuild_snovis_path}/obuild/cpp/obuild_platform.cpp" ) then
    echo "Program source obuild_platform.cpp not found."
    exit
  endif
  if ( $?obuild_cxx_command ) then
    if ( "${obuild_cxx_command}" == "" ) then
      if (  $?OBUILD_CXX ) then
        set obuild_platform_compiler=${OBUILD_CXX}
      else
        set obuild_platform_compiler=c++
      endif
    else
      set obuild_platform_compiler=${obuild_cxx_command}
    endif
  else
    set obuild_platform_compiler=c++
  endif
  ${obuild_platform_compiler} -o "${obuild_snovis_path}/${obuild_dir_bin}/obuild_platform" "${obuild_snovis_path}/obuild/cpp/obuild_platform.cpp"
  unset obuild_platform_compiler
  if ( ! -e "${obuild_snovis_path}/${obuild_dir_bin}/obuild_platform" ) then
    echo "Program obuild_platform not found."
    exit
  endif
endif
set obuild_platform_exe="${obuild_snovis_path}/${obuild_dir_bin}/obuild_platform"
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} UNIX`
if ( ${obuild_platform_result} == yes ) then
set bhep_home="/Users/barrand/dev/exp/nemo/bhep/v1r4p2"
endif
unset obuild_platform_result
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
set bhep_platform="Darwin"
endif
unset obuild_platform_result
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} UNIX`
if ( ${obuild_platform_result} == yes ) then
set snova_home="/Users/barrand/dev/exp/nemo/snova/v2r0p0"
endif
unset obuild_platform_result
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
set snova_platform="Darwin"
endif
unset obuild_platform_result
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} UNIX`
if ( ${obuild_platform_result} == yes ) then
set CLHEP_home="/usr/local/CLHEP/2.0.3.1"
endif
unset obuild_platform_result
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} UNIX`
if ( ${obuild_platform_result} == yes ) then
set Geant4_home="/usr/local/geant4/8.2"
endif
unset obuild_platform_result
if ( ! -e "${obuild_snovis_path}/${obuild_dir_bin}/obuild_find" ) then
  if ( ! -e "${obuild_snovis_path}/obuild/cpp/obuild_find.cpp" ) then
    echo "Program source obuild_find.cpp not found."
    exit
  endif
  if ( $?obuild_cxx_command ) then
    if ( "${obuild_cxx_command}" == "" ) then
      if (  $?OBUILD_CXX ) then
        set obuild_find_compiler=${OBUILD_CXX}
      else
        set obuild_find_compiler=c++
      endif
    else
      set obuild_find_compiler=${obuild_cxx_command}
    endif
  else
    set obuild_find_compiler=c++
  endif
  ${obuild_find_compiler} -o "${obuild_snovis_path}/${obuild_dir_bin}/obuild_find" "${obuild_snovis_path}/obuild/cpp/obuild_find.cpp"
  unset obuild_find_compiler
  if ( ! -e "${obuild_snovis_path}/${obuild_dir_bin}/obuild_find" ) then
    echo "Program obuild_find not found."
    exit
  endif
endif
set obuild_find_exe="${obuild_snovis_path}/${obuild_dir_bin}/obuild_find"
if ( "${obuild_find_exe}" == "" ) then
  echo "Variable obuild_find_exe not defined."
  exit
endif
set obuild_OnX_path=`"${obuild_find_exe}" OnX 'v17r*'`
if ( "${obuild_find_exe}" == "" ) then
  echo "Variable obuild_find_exe not defined."
  exit
endif
set obuild_G4Lab_path=`"${obuild_find_exe}" G4Lab 'v8r*'`

# Execute setup of used packages :
source "${obuild_OnX_path}/obuild/setup.csh"

source "${obuild_G4Lab_path}/obuild/setup.csh"

# Set environment variables of this package :
setenv SNOVISROOT "${obuild_snovis_path}"
setenv G4RADIOACTIVEDATA "${Geant4_home}/data/RadiativeDecay3.1"
setenv G4LEVELGAMMADATA "${Geant4_home}/data/PhotonEvaporation2.0"
setenv G4LEDATA "${Geant4_home}/data/G4EMLOW4.2"
setenv NeutronHPCrossSections "${Geant4_home}/data/G4NDL3.10"

if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
  if (  $?DYLD_LIBRARY_PATH ) then
    setenv DYLD_LIBRARY_PATH "${DYLD_LIBRARY_PATH}:${bhep_home}/Darwin"
  else
    setenv DYLD_LIBRARY_PATH "${bhep_home}/Darwin"
  endif
endif
unset obuild_platform_result
else
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
  if (  $?LD_LIBRARY_PATH ) then
    setenv LD_LIBRARY_PATH "${LD_LIBRARY_PATH}:${bhep_home}/Darwin"
  else
    setenv LD_LIBRARY_PATH "${bhep_home}/Darwin"
  endif
endif
unset obuild_platform_result
endif
unset obuild_platform_result

if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
  if (  $?DYLD_LIBRARY_PATH ) then
    setenv DYLD_LIBRARY_PATH "${DYLD_LIBRARY_PATH}:${snova_home}/Darwin"
  else
    setenv DYLD_LIBRARY_PATH "${snova_home}/Darwin"
  endif
endif
unset obuild_platform_result
else
if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
  if (  $?LD_LIBRARY_PATH ) then
    setenv LD_LIBRARY_PATH "${LD_LIBRARY_PATH}:${snova_home}/Darwin"
  else
    setenv LD_LIBRARY_PATH "${snova_home}/Darwin"
  endif
endif
unset obuild_platform_result
endif
unset obuild_platform_result

if ( "${obuild_platform_exe}" == "" ) then
  echo "Variable obuild_platform_exe not defined."
  exit
endif
set obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} Darwin`
if ( ${obuild_platform_result} == yes ) then
  if (  $?DYLD_LIBRARY_PATH ) then
    setenv DYLD_LIBRARY_PATH "${DYLD_LIBRARY_PATH}:${obuild_snovis_path}/${obuild_dir_bin}"
  else
    setenv DYLD_LIBRARY_PATH "${obuild_snovis_path}/${obuild_dir_bin}"
  endif
else
  if (  $?LD_LIBRARY_PATH ) then
    setenv LD_LIBRARY_PATH "${LD_LIBRARY_PATH}:${obuild_snovis_path}/${obuild_dir_bin}"
  else
    setenv LD_LIBRARY_PATH "${obuild_snovis_path}/${obuild_dir_bin}"
  endif
endif
unset obuild_platform_result

if (  $?PATH ) then
  setenv PATH "${PATH}:${obuild_snovis_path}/${obuild_dir_bin}"
else
  setenv PATH "${obuild_snovis_path}/${obuild_dir_bin}"
endif

unset obuild_snovis_path

#FIXME unset obuild_platform
#FIXME unset obuild_dir_bin
