//
//  All functions here should be OnX callbacks, that is to say
// functions with signature :
//   extern "C" {
//     void callback_without_arguments(Slash::UI::IUI&);
//     void callback_with_arguments(Slash::UI::IUI&,
//                                  const std::vector<std::string>&);
//   }
//

#include <OnX/Helpers/OnX.h>
#include <OnX/Helpers/Inventor.h>

#include <Inventor/nodes/SoOrthographicCamera.h>

// HEPVis :
#include <HEPVis/SbMath.h>
#include <HEPVis/nodekits/SoPage.h>
#include <HEPVis/nodekits/SoDisplayRegion.h>

extern "C" {

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
void snovis_scene_default(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
// Visualize same scene as snova_vis_example.mac.
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();
  
  session.setParameter("modeling.modeling","wire_frame");

  data_collect(session,"PV","name==\"WORLD\"");
  data_visualize(session);

  data_collect(session,"PV","name==\"DETECTOR\"");
  data_visualize(session);

  data_collect(session,"PV","name==\"[CALO:0.0.0]\"");
  data_visualize(session);

  data_collect(session,"PV","name==\"CHAMBER\"");
  data_visualize(session);

  data_collect(session,"PV","name==\"[SOURCE.STRIP:0.0]\"");
  data_visualize(session);

  data_collect(session,"PV","name==\"[TC.CELL:0.0.0]\"");
  data_visualize(session);

  data_collect(session,"PV","name==\"[TC.LAYER:1.0]\"");
  data_visualize(session);

}
//////////////////////////////////////////////////////////////////////////////
void snovis_layout_default(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //////////////////////////////////////////////////////////////////////////
  // Prepare the page :
  //////////////////////////////////////////////////////////////////////////
  SoPage* soPage = ui_SoPage(aUI);
  if(!soPage) return;

  soPage->deleteRegions();
  soPage->titleVisible.setValue(FALSE);
  soPage->createRegions("SoDisplayRegion",1,1,1);

  // Lonely region ; front view :
  soPage->setCurrentRegion(0);
  SoRegion* soRegion = soPage->currentRegion();
  if(!soRegion) return;
  SoRegion* fromRegion = soRegion;
  soRegion->color.setValue(SbColor(0,0,0));

  SoCamera* soCamera = soRegion->getCamera();
  if(soCamera->isOfType(SoOrthographicCamera::getClassTypeId()))
    ((SoOrthographicCamera*)soCamera)->height.setValue(5000);
  soCamera->position.setValue(0,0,5000);
  soCamera->orientation.setValue(SbRotation(SbVec3f(0,1,0),0));
  soCamera->nearDistance.setValue(1);
  soCamera->farDistance.setValue(100000);
  soCamera->focalDistance.setValue(5000);

  //////////////////////////////////////////////////////////////////////////
  // Scene :
  //////////////////////////////////////////////////////////////////////////
  soPage->setCurrentRegion(0);

  snovis_scene_default(aUI);
}
//////////////////////////////////////////////////////////////////////////////
void snovis_layout_front_top(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //////////////////////////////////////////////////////////////////////////
  // Prepare the page :
  //////////////////////////////////////////////////////////////////////////
  SoPage* soPage = ui_SoPage(aUI);
  if(!soPage) return;

  soPage->deleteRegions();
  soPage->titleVisible.setValue(FALSE);
  soPage->createRegions("SoDisplayRegion",1,2,1);

  // First region ; front view :
  soPage->setCurrentRegion(0);
  SoRegion* soRegion = soPage->currentRegion();
  if(!soRegion) return;
  SoRegion* fromRegion = soRegion;
  soRegion->color.setValue(SbColor(0,0,0));

  SoCamera* soCamera = soRegion->getCamera();
  if(soCamera->isOfType(SoOrthographicCamera::getClassTypeId()))
    ((SoOrthographicCamera*)soCamera)->height.setValue(5000);
  soCamera->position.setValue(0,0,5000);
  soCamera->orientation.setValue(SbRotation(SbVec3f(0,1,0),0));
  soCamera->nearDistance.setValue(1);
  soCamera->farDistance.setValue(100000);
  soCamera->focalDistance.setValue(5000);

  // Second region ; top view :
  soPage->setCurrentRegion(1);
  soRegion = soPage->currentRegion();
  if(!soRegion) return;
  soRegion->color.setValue(SbColor(0,0,0));
  soRegion->connectFrom(fromRegion);

  soCamera = soRegion->getCamera();
  if(soCamera->isOfType(SoOrthographicCamera::getClassTypeId()))
    ((SoOrthographicCamera*)soCamera)->height.setValue(5000);
  soCamera->position.setValue(0,5000,0);
  soCamera->orientation.setValue(SbRotation(SbVec3f(1,0,0),-1.57F));
  soCamera->nearDistance.setValue(1);
  soCamera->farDistance.setValue(100000);
  soCamera->focalDistance.setValue(5000);

  //////////////////////////////////////////////////////////////////////////
  // Scene :
  //////////////////////////////////////////////////////////////////////////

  soPage->setCurrentRegion(0);

  snovis_scene_default(aUI);
}
//////////////////////////////////////////////////////////////////////////////
void snovis_layout_CAD(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //////////////////////////////////////////////////////////////////////////
  // Prepare the page :
  //////////////////////////////////////////////////////////////////////////
  SoPage* soPage = ui_SoPage(aUI);
  if(!soPage) return;

  soPage->deleteRegions();
  soPage->titleVisible.setValue(FALSE);
  soPage->createRegions("SoDisplayRegion",2,2,1);

  // Connect the second, third, fourth region to the first one.

  // First region ; side view, +z at right :
  soPage->setCurrentRegion(0);
  SoRegion* soRegion = soPage->currentRegion();
  if(!soRegion) return;
  SoRegion* fromRegion = soRegion;
  soRegion->color.setValue(SbColor(0,0,0));

  float size = 5500;

  SoCamera* soCamera = soRegion->getCamera();
  if(soCamera->isOfType(SoOrthographicCamera::getClassTypeId()))
    ((SoOrthographicCamera*)soCamera)->height.setValue(size);
  soCamera->position.setValue(-size,0,0);
  soCamera->orientation.setValue(SbRotation(SbVec3f(0,1,0),-FM_PI_2));
  soCamera->nearDistance.setValue(1);
  soCamera->farDistance.setValue(100000);
  soCamera->focalDistance.setValue(size);

  // Second region ; front view :
  soPage->setCurrentRegion(1);
  soRegion = soPage->currentRegion();
  if(!soRegion) return;
  soRegion->color.setValue(SbColor(0,0,0));
  soRegion->connectFrom(fromRegion);

  soCamera = soRegion->getCamera();
  if(soCamera->isOfType(SoOrthographicCamera::getClassTypeId()))
    ((SoOrthographicCamera*)soCamera)->height.setValue(size);
  soCamera->position.setValue(0,0,size);
  soCamera->orientation.setValue(SbRotation(SbVec3f(0,1,0),0));
  soCamera->nearDistance.setValue(1);
  soCamera->farDistance.setValue(100000);
  soCamera->focalDistance.setValue(size);

  // Third region ; top view :
  soPage->setCurrentRegion(2);
  soRegion = soPage->currentRegion();
  if(!soRegion) return;
  soRegion->color.setValue(SbColor(0,0,0));
  soRegion->connectFrom(fromRegion);

  soCamera = soRegion->getCamera();
  if(soCamera->isOfType(SoOrthographicCamera::getClassTypeId()))
    ((SoOrthographicCamera*)soCamera)->height.setValue(size);
  soCamera->position.setValue(0,size,9);
  soCamera->orientation.setValue(SbRotation(SbVec3f(-1,-1,-1),2*FM_PI/3));
  soCamera->nearDistance.setValue(1);
  soCamera->farDistance.setValue(100000);
  soCamera->focalDistance.setValue(size);

  // Fourth region ; 3D view :
  soPage->setCurrentRegion(3);
  soRegion = soPage->currentRegion();
  if(!soRegion) return;
  soRegion->color.setValue(SbColor(0,0,0));
  soRegion->connectFrom(fromRegion);

  size = 2*size;

  soCamera = soRegion->getCamera();
  if(soCamera->isOfType(SoOrthographicCamera::getClassTypeId()))
    ((SoOrthographicCamera*)soCamera)->height.setValue(size);
  soCamera->position.setValue(-10866.0F,12873.0F,-8335.0F);
  soCamera->orientation.setValue
    (SbRotation(SbVec3f(-0.178F,-0.92F,-0.361F),2.27F));
  soCamera->nearDistance.setValue(1);
  soCamera->farDistance.setValue(100000);
  soCamera->focalDistance.setValue(size);

  ////////////////////////////////////////////////////////////////////////////
  // Scene :
  ////////////////////////////////////////////////////////////////////////////

  soPage->setCurrentRegion(0);

  snovis_scene_default(aUI);
}
//////////////////////////////////////////////////////////////////////////////
void snovis_InputLayout_ok(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::string layout;
  if(!aUI.parameterValue
    ("snovis_InputLayout_input_layout.value",layout)) return;

  aUI.executeScript("DLD","snovis snovis_layout_"+layout);

}

}
