#!/bin/sh -f

#
# File produced by the obuild tool version 1.0
# for the package snova with version v2r0p0.
#

#////////////////////////////////////////////////
# Usage :
#   sh> . setup.sh
#////////////////////////////////////////////////

#set -x  # uncomment this line to have full verbosity.

#////////////////////////////////////////////////
# Set the absolute path of this package.
# If in the below line there is the keyword :
#
#     @@absolute_dir@@
#
# then the package had not been installed.
#
#  Someone has to replace @@absolute_dir@@
# by the absolute path of the package.
# By "absolute path of the package", we mean that
# if the obuild directory of the package is 
# found under :
#    some_path/pack/vers/obuild
# then the "absolute path of the package" is :
#    some_path/pack/vers
#
#  This replacement can be done on the setup
# scripts of the package by using the sh/build 
# with the -i option.
#
#  This replacement can be done recursively
# on the setups of the used packages by using 
# the sh/build script with the -bci option 
# ("bci" for broadcast install).
#
#////////////////////////////////////////////////

obuild_snova_path="@@absolute_dir@@"

if [ "${obuild_snova_path}" = '@@absolute_dir@@' ] ; then
  echo '  The package snova had not been installed.'
  echo ''
  echo ' In the file :'
  echo '    snova/<vers>/obuild/setup.sh'
  echo ' someone has to replace '
  echo '    @@absolute_dir@@'
  echo ' by the absolute path of the package.'
  echo '  By "absolute path of the package", we mean that'
  echo ' if the obuild directory of the package is found under :'
  echo '    some_path/pack/vers/obuild'
  echo ' then the "absolute path of the package" is :'
  echo '    some_path/pack/vers'
  echo ''
  echo '  If having the write access, this replacement can be done'
  echo ' on the setup scripts of the package by using the sh/build'
  echo ' with the -i option. This replacement can be done recursively'
  echo ' on the setups of the used packages by using the sh/build script'
  echo ' with the -bci option ("bci" for broadcast install).'
  echo ''
  return
fi

if [  "${OBUILD_PLATFORM}" = "" ] ; then
  obuild_platform=`uname`
else
  obuild_platform=${OBUILD_PLATFORM}
fi

if [ "${obuild_platform}" = "" ] ; then
  echo "obuild_platform variable not defined."
  return
fi

if [  "${OBUILD_DIR_BIN}" = "" ] ; then
  obuild_dir_bin=${obuild_platform}_obuild
else
  obuild_dir_bin=${OBUILD_DIR_BIN}
fi

if [ "${obuild_dir_bin}" = "" ] ; then
  echo "obuild_dir_bin variable not defined."
  return
fi

if [ ! -e "${obuild_snova_path}/${obuild_dir_bin}/obuild_platform" ] ; then
  if [ ! -e "${obuild_snova_path}/obuild/cpp/obuild_platform.cpp" ] ; then
    echo "Program source obuild_platform.cpp not found."
    return
  fi
  if [ "${obuild_cxx_command}" = "" ] ; then 
    if [  "${OBUILD_CXX}" != "" ] ; then
      obuild_platform_compiler=${OBUILD_CXX}
    else
      obuild_platform_compiler=c++ 
    fi
  else
    obuild_platform_compiler=${obuild_cxx_command} 
  fi
  ${obuild_platform_compiler} -o "${obuild_snova_path}/${obuild_dir_bin}/obuild_platform" "${obuild_snova_path}/obuild/cpp/obuild_platform.cpp"
  unset obuild_platform_compiler
  if [ ! -e "${obuild_snova_path}/${obuild_dir_bin}/obuild_platform" ] ; then
    echo "Program obuild_platform not found."
    return
  fi
fi
obuild_platform_exe="${obuild_snova_path}/${obuild_dir_bin}/obuild_platform"
if [ "${obuild_platform_exe}" = "" ] ; then
  echo "Variable obuild_platform_exe not defined."
  return
fi
obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} 'UNIX'`
if [ ${obuild_platform_result} = yes ] ; then
CLHEP_home="/usr/local/CLHEP/2.0.3.1"
fi
unset obuild_platform_result
if [ "${obuild_platform_exe}" = "" ] ; then
  echo "Variable obuild_platform_exe not defined."
  return
fi
obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} 'UNIX'`
if [ ${obuild_platform_result} = yes ] ; then
Geant4_home="/usr/local/geant4/8.2"
fi
unset obuild_platform_result
# Set environment variables of this package :

if [ "${obuild_platform_exe}" = "" ] ; then
  echo "Variable obuild_platform_exe not defined."
  return
fi
obuild_platform_result=`"${obuild_platform_exe}" ${obuild_platform} 'Darwin'`
if [ ${obuild_platform_result} = yes ] ; then
  if [  "${DYLD_LIBRARY_PATH}" = "" ] ; then
    DYLD_LIBRARY_PATH="${obuild_snova_path}/${obuild_dir_bin}"
    export DYLD_LIBRARY_PATH
  else
    DYLD_LIBRARY_PATH="${DYLD_LIBRARY_PATH}:${obuild_snova_path}/${obuild_dir_bin}"
    export DYLD_LIBRARY_PATH
  fi
else
  if [  "${LD_LIBRARY_PATH}" = "" ] ; then
    LD_LIBRARY_PATH="${obuild_snova_path}/${obuild_dir_bin}"
    export LD_LIBRARY_PATH
  else
    LD_LIBRARY_PATH="${LD_LIBRARY_PATH}:${obuild_snova_path}/${obuild_dir_bin}"
    export LD_LIBRARY_PATH
  fi
fi
unset obuild_platform_result

unset obuild_snova_path

#FIXME unset obuild_platform
#FIXME unset obuild_dir_bin
