/* 
 * Version of prog_snova.cc to handle a G4Lab::UIOnX session
 */

#include <snova/snova_mgr.hh>

#include <SNvertex/base_VG_factory.h>
#include <SNvertex/CALO_basic_VG.h>
#include <SNvertex/source_simple_VG.h>

#include <G4Runmanager.hh>
#include <G4UImanager.hh>

// G4Lab :
#include <G4Lab/UIOnX.h> //UIOnX

#include "Environment.h"
#include <Lib/Out.h>
#include <Lib/sout.h>
#include <Lib/fmanip.h>
#include <Lib/dirmanip.h>
#include <Lib/smanip.h>

using namespace snova;

namespace snovis {
  class mgr : public snova::snova_mgr {
  public:
    mgr(){}
    virtual ~mgr(){}
  public:
    void run_sim(int argc , char** argv,const std::string& aTk = "") {
      G4UImanager* UI = G4UImanager::GetUIpointer();  

      UI->ApplyCommand("/control/shell cp currentEvent.rndm currentRun.rndm");
      UI->ApplyCommand("/random/setSavingFlag true");
      UI->ApplyCommand("/random/resetEngineFrom currentRun.rndm");
      UI->ApplyCommand("/tracking/storeTrajectory 1");
      //UI->ApplyCommand("/tracking/verbose 1");
  
      //G4RunManager* runManager = __runManager;
      G4RunManager* runManager = G4RunManager::GetRunManager();

      std::string gui = "$SNOVISROOT/scripts/OnX/snovis_session.onx"; //UIOnX
      G4Lab::UIOnX* session = 
        new G4Lab::UIOnX(*runManager,gui,argc,argv); //UIOnX
      session->createUI(aTk);
      session->SessionStart();
      delete session;
    }
  };
}

int main( int argc , char** argv ) 
{
  if(argc<=0) return 1;
  if(!check_envs(argv[0])) return 1;

  Lib::Printer printer;
  Lib::Out out(printer);

  std::string SNOVISROOT;
  if(!Lib::System::getenv("SNOVISROOT",SNOVISROOT)) {
    out << "snovis_session :"
	<< " Environment variable SNOVISROOT not defined."
	<< Lib::endl;
    return 1;
  }

  if(!Lib::dirmanip::goHome()) {
    out << "snovis_session : can't go home." << Lib::endl;
    return 1;
  } else if(!Lib::dirmanip::mkcd("OpenScientist")) {
    out << "snovis_session : can't mkcd OpenScientist." << Lib::endl;
    return 1;
  } else if(!Lib::dirmanip::mkcd("snovis")) {
    out << "snovis_session : can't mkcd snovis." << Lib::endl;
    return 1;
  } else if(!Lib::dirmanip::mkcd("session")) {
    out << "snovis_session : can't mkcd session." << Lib::endl;
    return 1;
  } else {
    std::string fs = Lib::System::fileSeparator();
    std::string from = SNOVISROOT+fs+"scripts"+fs+"snova";
    if(!Lib::fmanip::copy(from+fs+"snova.par",".")) {
      out << "snovis_session : can't copy snova.par." << Lib::endl;
      return 1;
    } else if(!Lib::fmanip::copy(from+fs+"snemo.geom",".")) {
      out << "snovis_session : can't copy snemo.geom." << Lib::endl;
      return 1;
    } else if(!Lib::fmanip::copy(from+fs+"example_Mo100.txt",".")) {
      out << "snovis_session : can't copy example_Mo100.txt." << Lib::endl;
      return 1;
    } else {
      //std::string pwd;
      //Lib::dirmanip::directory(pwd);
      //out << pwd << Lib::endl;
    }
  }

  bool is_Mac_app = Lib::main::isMacApp(argv[0]);

  int error_code=EXIT_SUCCESS;
  try {

    std::cout << "Hello, this is a sample program for class 'snova_mgr'!" << std::endl; 
  
    bool        debug           = false;
    std::string params_filename = snova::constants::DEF_PARAMS_FILENAME;
    //std::string params_filename = SNOVISROOT+"/scripts/snova.par";
    //G4String geom_filename = SNOVISROOT+"/scripts/snemo.geom";
    std::string G4_macro        = "";
    bool        visual_mode     = false;
    
    // A snova manager:
    snovis::mgr my_snova_mgr;

    // Configure some properties of the snova manager:
    my_snova_mgr.set_debug(debug);                     // debug verbosity
    my_snova_mgr.set_params_filename(params_filename); // the main simulation configuration file
    my_snova_mgr.set_visual_mode(visual_mode);         // use X11 display
    my_snova_mgr.set_G4_macro(G4_macro);               // run G4 macro

    // Use a dedicated vertex generator factory:
    snemo::base_VG_factory my_VG_factory;
    my_VG_factory.add("CALO_basic",    snemo::CALO_basic_VG::new_CALO_basic_VG );
    my_VG_factory.add("source_simple", snemo::source_simple_VG::new_source_simple_VG );
    // <here you may add more functors in the factory internal map... >
    //my_VG_factory.add("TC_nblocks", snemo::TC_nblocks_VG::new_TC_nblocks_VG ); // NOT AVAILABLE YET!

    my_VG_factory.init();
    if( debug ) my_VG_factory.dump(std::cerr);
    my_snova_mgr.set_VG_factory(my_VG_factory);

    // Build the guts of the simulation process within the snova manager:
    std::cerr << "prog_snova2: debug: " 
	      << "Build the guts" << std::endl; 
    my_snova_mgr.init(); // from this point 'set_XXXX' methods failed (manager is locked!)

    // Run the simulation:
    std::cerr << "prog_snova2: debug: " 
	      << "Run the simulation" << std::endl; 
    my_snova_mgr.run_sim(argc,argv,is_Mac_app?"Qt":"");

    // Clean the snova manager
    std::cerr << "prog_snova2: debug: " 
	      << "Clean the snova manager" << std::endl; 
    my_snova_mgr.reset(); // not mandatory for we do it in the d-tor.

    std::cerr << "prog_snova2: debug: " 
	      << "Done" << std::endl; 
  }
  catch(std::exception & x){
    std::cerr << "prog_snova2: error: " << x.what() << std::endl; 
    error_code=EXIT_FAILURE;
  }
  catch(...){
    std::cerr << "prog_snova2: error: " << "unexpected error!" << std::endl; 
    error_code=EXIT_FAILURE;
  }
  return error_code;
}
