/* 
 * Version of prog_snova.cc to handle a G4Lab::UIOnX session
 */

// snova :
#include <snova/snova_mgr.h>
#include <SNvertex/base_VG_factory.h>
#include <SNvertex/CALO_basic_VG.h>
#include <SNvertex/source_simple_VG.h>

// Geant4 :
#include <G4RunManager.hh>
#include <G4UImanager.hh>

// G4Lab :
#include <G4Lab/UIOnX.h> //UIOnX

// Lib :
#include <Lib/Out.h>
#include <Lib/sout.h>
#include <Lib/fmanip.h>
#include <Lib/dirmanip.h>
#include <Lib/smanip.h>

#include "Environment.h"

namespace snovis {
  class mgr : public snova::snova_mgr {
  public:
    mgr(){}
    virtual ~mgr(){}
  public:
    void run_sim(int argc , char** argv,const std::string& aTk = "") {
      G4UImanager* UI = G4UImanager::GetUIpointer();  

      UI->ApplyCommand("/control/shell cp currentEvent.rndm currentRun.rndm");
      UI->ApplyCommand("/random/setSavingFlag true");
      UI->ApplyCommand("/random/resetEngineFrom currentRun.rndm");
      UI->ApplyCommand("/tracking/storeTrajectory 1");
      //UI->ApplyCommand("/tracking/verbose 1");
  
      //G4RunManager* runManager = __runManager;
      G4RunManager* runManager = G4RunManager::GetRunManager();

      std::string gui = "$SNOVISROOT/scripts/OnX/snovis_session.onx"; //UIOnX
      G4Lab::UIOnX* session = 
        new G4Lab::UIOnX(*runManager,gui,argc,argv); //UIOnX
      session->createUI(aTk);
      session->SessionStart();
      delete session;
    }
  };
}

int main( int argc , char** argv ) 
{
  if(argc<=0) return EXIT_FAILURE;
  if(!check_envs(argv[0])) return EXIT_FAILURE;

  Lib::Printer printer;
  Lib::Out out(printer);

  std::string SNOVISROOT;
  if(!Lib::System::getenv("SNOVISROOT",SNOVISROOT)) {
    out << "snovis_session :"
	<< " Environment variable SNOVISROOT not defined."
	<< Lib::endl;
    return EXIT_FAILURE;
  }

  std::string params;

  // We cd to $HOME/snovis/session :
  if(!Lib::dirmanip::goHome()) {
    out << "snovis_session : can't go home." << Lib::endl;
    return EXIT_FAILURE;
  } else if(!Lib::dirmanip::mkcd("snovis")) {
    out << "snovis_session : can't mkcd snovis." << Lib::endl;
    return EXIT_FAILURE;
  } else if(!Lib::dirmanip::mkcd("session")) {
    out << "snovis_session : can't mkcd session." << Lib::endl;
    return EXIT_FAILURE;
  } else {
    // If there is a snova.par file found under 
    //    $HOME/snovis/session :
    // we take it, else we start with $SNOVISROOT/scripts/snova/snova.par
    if(Lib::fmanip::exists("snova.par")) {
      params = "snova.par";
    } else {
      params = "$SNOVISROOT/scripts/snova/snova.par";
    }
  }

  bool is_Mac_app = Lib::main::isMacApp(argv[0]);

  int error_code=EXIT_SUCCESS;
  try {
    //std::cerr << "snovis_session : startup" << std::endl; 
  
    // A snova manager:
    snovis::mgr mgr;

    // Configure some properties of the snova manager:
    mgr.set_debug(false);
    mgr.set_params_filename(params);
    //mgr.set_G4_macro(G4_macro);

    // Use a dedicated vertex generator factory:
    snemo::base_VG_factory VG_factory;
    VG_factory.add("CALO_basic",
                   snemo::CALO_basic_VG::new_CALO_basic_VG );
    VG_factory.add("source_simple",
                   snemo::source_simple_VG::new_source_simple_VG);
    // <here you may add more functors in the factory internal map... >
    // NOT AVAILABLE YET!
    //VG_factory.add("TC_nblocks",
    //               snemo::TC_nblocks_VG::new_TC_nblocks_VG );

    VG_factory.init();
    //if( debug ) my_VG_factory.dump(std::cerr);
    mgr.set_VG_factory(VG_factory);

    // Build the guts of the simulation process within the snova manager:
    //std::cerr << "snovis_session :" 
    //          << " mgr.init..." << std::endl; 
    mgr.init();

    // Run the simulation:
    mgr.run_sim(argc,argv,is_Mac_app?"Qt":"");

    //std::cerr << "snovis_session :" 
    //          << " mgr.reset..." << std::endl; 
    mgr.reset(); // not mandatory for we do it in the d-tor.

    //std::cerr << "snovis_session :" 
    //          << " end." << std::endl; 
  }
  catch(std::exception & x){
    std::cerr << "snovis_session : error : " << x.what() << std::endl; 
    error_code=EXIT_FAILURE;
  }
  catch(...){
    std::cerr << "snovis_session : error : unexpected error!" << std::endl; 
    error_code=EXIT_FAILURE;
  }
  return error_code;
}
