#ifndef G4Lab_GeometryVisitor_h
#define G4Lab_GeometryVisitor_h
 
#include <G4Transform3D.hh>

class G4VPhysicalVolume;
class G4LogicalVolume;
class G4VSolid;
class G4Material;

namespace G4Lab {

class IVisitedVolume {
public:
  enum Status {
    DAUGHTERS = 0,
    SIBLING = 1,
    STOP = 2
  };
  virtual ~IVisitedVolume() {}
  virtual Status beginVolume(G4VPhysicalVolume*,
                             G4VSolid*,G4Material*,
                             const G4Transform3D&,int) = 0; 
  virtual void endVolume(G4VPhysicalVolume*) = 0;
  virtual void beginDaughters(G4VPhysicalVolume*,int) = 0;
  virtual void endDaughters(G4VPhysicalVolume*,int) = 0;
};

class GeometryVisitor {
public:
  GeometryVisitor();
  ~GeometryVisitor();
  bool visit(G4VPhysicalVolume*,int,const G4Transform3D&,IVisitedVolume*); 
private:
  bool descend(G4VPhysicalVolume*,
               int,
               G4VSolid*,
               G4Material*,
               const G4Transform3D&,
               IVisitedVolume*);
private:
  int fIndex;
};

}

#endif
