#ifndef G4Lab_HitsCollectionAccessor_h
#define G4Lab_HitsCollectionAccessor_h

// Inheritance :
#include <OnX/Inventor/InventorAccessor.h>

#include <G4Transform3D.hh>

class G4VHitsCollection;
class G4VHit;
class G4LogicalVolume;
class G4Colour;

namespace Slash {namespace Core {class ISession;}}
namespace Slash {namespace Core {class IWriter;}}

#include <map>
#include <G4AttDef.hh>
#include <G4String.hh>

namespace G4Lab {

class HitsCollectionAccessor : public OnX::InventorAccessor {
public: //Slash::Data::IAccessor
  virtual std::string name() const;
  virtual Slash::Data::IIterator* iterator();
  virtual Slash::Core::IValue* findValue(Slash::Data::IAccessor::Data,const std::string&,void*);
public: //Slash::Data::IVisualizer
  virtual void beginVisualize();
  virtual void visualize(Slash::Data::IAccessor::Data,void*);
public:
  HitsCollectionAccessor(Slash::Core::ISession&,const std::string& = "");
  virtual ~HitsCollectionAccessor();
  const std::string& HCName() const;
protected:
  static G4LogicalVolume* hitLogicalVolume(const G4VHit&); 
  static G4Transform3D* hitTransform3D(const G4VHit&); 
  static bool hitColor(const G4VHit&,G4Colour&); 
  static G4VHitsCollection* getCollection(Slash::Core::IWriter&,const std::string&);
private:
  std::string fType;
  std::map<G4String,G4AttDef>* fAttDefs;
  std::string fHC;
};

}

#endif
