#ifndef IGeant4Manager_h
#define IGeant4Manager_h

#include <string>

class G4RunManager;
class G4SDManager;

class IGeant4Manager {
public:
  virtual ~IGeant4Manager() {}
public:
  virtual void executeG4Script(const std::string&) = 0;
  virtual std::string physicalVolumes() = 0;
  virtual std::string hitsCollections() = 0;
  virtual std::string digitsCollections() = 0;
  virtual void setRunBeginScript(const std::string&,const std::string&) = 0;
  virtual void setRunEndScript(const std::string&,const std::string&) = 0;
  virtual void setEventBeginScript(const std::string&,const std::string&) = 0;
  virtual void setEventEndScript(const std::string&,const std::string&) = 0;
  virtual std::string completeCommand(const std::string&) = 0;
  virtual bool initialize() = 0;
  
  virtual void beamOn(int) = 0;
  virtual void abortRun() = 0;
  virtual bool isRunning() = 0;
  virtual void particleTableDump() = 0;

  virtual G4RunManager* runManager() const = 0;
  virtual G4SDManager* sdManager() const = 0;
};

#endif
