#ifndef G4Lab_Manager_h
#define G4Lab_Manager_h

// Inheritance :
#include <Slash/Core/IManager.h>
#include <G4Lab/Interfaces/IGeant4Manager.h>

namespace Slash {namespace Core {class ISession;}}
namespace Slash {namespace Data {class IAccessor;}}
namespace Slash {namespace UI {class IScriptManager;}}

namespace AIDA {class IAnalysisFactory;}

namespace G4Lab {

class State;
class UIsession;

class Manager 
:public virtual Slash::Core::IManager 
,public virtual IGeant4Manager {
public: //Slash::Core::IManager
  virtual std::string name() const;
  virtual void* cast(const std::string&) const;
public: //IGeant4Manager
  virtual void executeG4Script(const std::string&);
  virtual std::string physicalVolumes();
  virtual std::string hitsCollections();
  virtual std::string digitsCollections(); 
  virtual void setRunBeginScript(const std::string&,const std::string&);
  virtual void setRunEndScript(const std::string&,const std::string&);
  virtual void setEventBeginScript(const std::string&,const std::string&);
  virtual void setEventEndScript(const std::string&,const std::string&);
  virtual std::string completeCommand(const std::string&);
  virtual bool initialize();

  virtual void beamOn(int);
  virtual void abortRun();
  virtual bool isRunning();
  virtual void particleTableDump();

  virtual G4RunManager* runManager() const;
  virtual G4SDManager* sdManager() const;
public:
  Manager(Slash::Core::ISession&,
          const std::string&,G4RunManager*,bool = false);
  virtual ~Manager();
  void addAccessor(Slash::Data::IAccessor*);
  AIDA::IAnalysisFactory* findAIDA();
public:
  static bool executeScript(const std::string&,void*);
private:
  Slash::Core::ISession& fSession;
  std::string fName;
  UIsession* fUIsession;
  State* fState;
  Slash::UI::IScriptManager* fScriptManager;
  G4RunManager* fRunManager;
  bool fDeleteRunManager;
};

}

#endif
