#ifndef G4Lab_PhysicsTableAccessor_h
#define G4Lab_PhysicsTableAccessor_h

// Inheritance :
#include <Lib/BaseAccessor.h>
#include <Slash/Data/IVisualizer.h>

class G4ParticleDefinition;
class G4VProcess;
class G4PhysicsTable;

namespace Slash {namespace Core {class ISession;}}

namespace AIDA {class IAnalysisFactory;}

namespace G4Lab {

class PhysicsTable;

class PhysicsTableAccessor 
:public Lib::BaseAccessor
,public Slash::Data::IVisualizer 
{
public: //Slash::Data::IAccessor
  virtual std::string name() const;
  virtual Slash::Data::IIterator* iterator();
  virtual Slash::Core::IValue* findValue(Slash::Data::IAccessor::Data,const std::string&,void*);
public: //Lib::IVisualizationType
  virtual void beginVisualize();
  virtual void visualize(Slash::Data::IAccessor::Data,void*);
  virtual void endVisualize();
public:
  PhysicsTableAccessor(Slash::Core::ISession&,AIDA::IAnalysisFactory*);
  virtual ~PhysicsTableAccessor();
private:
  bool findProcessTables(G4ParticleDefinition*,
                         G4VProcess*,
                         std::vector<std::string>&,
                         std::vector<G4PhysicsTable*>&);
private:
  Slash::Core::ISession& fSession;
  std::string fType;
  std::vector<PhysicsTable*> fTables;
  AIDA::IAnalysisFactory* fAIDA;
};

}

#endif
