#ifndef G4Lab_SoVisitedVolume_h
#define G4Lab_SoVisitedVolume_h

// Inheritance :
#include <G4Lab/GeometryVisitor.h>

class SoGroup;
class SoGC;

namespace G4Lab {

class SoVisitedVolume : public virtual IVisitedVolume {
public:
  SoVisitedVolume(SoGC&,SoGroup*,G4VPhysicalVolume*,int = 0);
  virtual ~SoVisitedVolume();
  virtual bool beginVolume(G4VPhysicalVolume*,G4VSolid*,G4Material*,
                           const G4Transform3D&,int); 
  virtual void endVolume(G4VPhysicalVolume*);
  virtual void beginDaughters(G4VPhysicalVolume*,int);
  virtual void endDaughters(G4VPhysicalVolume*,int);
private:
  SoGC& fGC;
  SoGroup* fParent;
  G4VPhysicalVolume* fPhysicalVolume;
  int fDepth;
  int fIndex;
};

}

#endif

