#ifndef G4Lab_SoG4Trajectories_h
#define G4Lab_SoG4Trajectories_h

// Inheritance :
#include <Inventor/nodes/SoShape.h>

#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFNode.h>

#include <vector>

class G4TrajectoryContainer;
class SoSensor;
class SoFieldSensor;

class PointIdentifier {
public:
  PointIdentifier(int aTrajectory,int aPoint)
    :fTrajectory(aTrajectory),fPoint(aPoint){}
public:
  int fTrajectory;
  int fPoint;
};

class SoG4Trajectories : public SoShape {
  SO_NODE_HEADER(SoG4Trajectories);
public:
  enum Model {
    ALL,
    TIMED
  };
  SoSFEnum model;

  SoSFFloat timeStart;
  SoSFFloat timeInterval;
  SoSFInt32 timeSteps;
  SoSFInt32 timeIndex;

  // Info nodes :
  SoSFFloat timeMin;
  SoSFFloat timeMax;
  SoSFBool verbose;

  SoSFNode alternateRep;
public:
  SoG4Trajectories();
  virtual void generateAlternateRep();
  virtual void clearAlternateRep();
public:
  static void initClass();
protected:
  virtual void GLRender(SoGLRenderAction*);
  virtual void rayPick(SoRayPickAction*);
  virtual void computeBBox(SoAction*,SbBox3f&,SbVec3f&);
  virtual void generatePrimitives(SoAction*);
  virtual void doAction(SoAction*);
protected:
  virtual ~SoG4Trajectories();
private:
  void flush();
  static void sensorCB(void*,SoSensor*);
  bool isG4LabTrajectories(G4TrajectoryContainer*);
  void timeOrder(G4TrajectoryContainer*);
private:
  G4TrajectoryContainer* fContainer;
  std::vector< std::vector<PointIdentifier> > fTimeOrderedPoints;
  SoFieldSensor* fSensor;
};

#endif
