#ifndef G4Lab_State_h
#define G4Lab_State_h 

#include <G4VStateDependent.hh>
#include <G4UIsession.hh>

namespace Slash {namespace UI {class IScriptManager;}}

namespace G4Lab {

class State : public G4VStateDependent, public G4UIsession {
public:
  State(Slash::UI::IScriptManager*);
  virtual ~State();
  G4bool Notify(G4ApplicationState);
  void PauseSessionStart(G4String);
  void setRunBeginScript(const std::string&,const std::string&);
  void setRunEndScript(const std::string&,const std::string&);
  void setEventBeginScript(const std::string&,const std::string&);
  void setEventEndScript(const std::string&,const std::string&);
  bool isRunning() const;
private:
  Slash::UI::IScriptManager* fScriptManager;
  bool fIsRunning;

  std::string fRunBeginInterp;
  std::string fRunBeginScript;
  std::string fRunEndInterp;
  std::string fRunEndScript;

  std::string fEventBeginInterp;
  std::string fEventBeginScript;
  std::string fEventEndInterp;
  std::string fEventEndScript;
};

}

#endif

