#ifndef G4Lab_Trajectory_h
#define G4Lab_Trajectory_h

#include <G4Trajectory.hh>

#include <vector>

#include <Lib/Debug.h>

namespace G4Lab {

class TrajectoryPoint;

class Trajectory : public G4Trajectory {
public: // G4Trajectory:
  virtual void ShowTrajectory(std::ostream& = G4cout) const;
  virtual void DrawTrajectory(G4int =0) const;
  virtual void AppendStep(const G4Step*);
  virtual int GetPointEntries() const;
  virtual G4VTrajectoryPoint* GetPoint(G4int) const; 
  virtual void MergeTrajectory(G4VTrajectory*);
public:
  Trajectory(const G4Track*);
  Trajectory(Trajectory&);
  virtual ~Trajectory();
  /*inline*/ void* operator new(size_t);
  /*inline*/ void operator delete(void*);
  /*inline*/ int operator == (const Trajectory&) const;
  G4double GetKineticEnergy() const;
  G4double GetTotalEnergy() const;
  G4double GetGlobalTime() const;
  G4double GetPointGlobalTime(G4int) const;
private:
  std::vector<TrajectoryPoint*> fPoints;
  G4double fKineticEnergy;
  G4double fTotalEnergy;
  G4double fGlobalTime;
  Lib::Debug fDebug;
};

}

#endif

