#ifndef G4Lab_TrajectoryAccessor_h
#define G4Lab_TrajectoryAccessor_h

// Inheritance :
#include <OnX/Inventor/InventorAccessor.h>

class SoGroup;
class SoSeparator;
class SoCoordinate3;
class SbName;
class SbVec3f;
class SbColor; 
class IOut;

namespace G4Lab {

class TrajectoryAccessor : public OnX::InventorAccessor {
public: //Slash::Data::IAccessor
  virtual std::string name() const;
  virtual Slash::Data::IIterator* iterator();
  virtual Slash::Core::IValue* findValue(Slash::Data::IAccessor::Data,const std::string&,void*);
public: //Slash::Data::IVisualizer
  virtual void beginVisualize();
  virtual void visualize(Slash::Data::IAccessor::Data,void*);
  virtual void endVisualize();
public:
  TrajectoryAccessor(Slash::Core::ISession&);
  virtual ~TrajectoryAccessor();
private:
  void addPolyline(SoGroup*,const SbName&,
                   int,SbVec3f*,const SbColor&,const SbColor&,IOut&); 
  bool isG4LabTrajectory();
private:
  std::string fType;
  std::string fModeling;
  bool fG4Lab;
  SoSeparator* fSeparator;
  SoCoordinate3* fCoordinate;
  int fIndex;
};

}

#endif
