#ifndef G4Lab_UIOnX_h
#define G4Lab_UIOnX_h 

// Inheritance :
#include <G4UIsession.hh>

namespace Slash {namespace Data {class IAccessor;}}
namespace OnX {class Main;}
namespace AIDA {class IAnalysisFactory;}

namespace Slash {namespace UI {class IUI;}}
namespace Slash {namespace Core {class ISession;}}
namespace Slash {namespace Core {class IWriter;}}
namespace Slash {namespace Core {class IManager;}}

class G4RunManager;

namespace G4Lab {

class Manager;

// Avoid establishing a relationship with G4interfaces (by inheriting
// G4VBasicShell). This library may be reconstructed with various GUI drivers.

class UIOnX : public G4UIsession {
public: //G4UIsession
  virtual G4UIsession* SessionStart();
  virtual void PauseSessionStart(G4String);
public:
  /**
   * Create an OnX session.
   * @param aRunManager : User G4RunManager.
   * @param aGUI : OnX GUI file.
   * @param aArgc : Pass the argument coming from "main" or give 0.
   * @param aArgv : Pass the argument coming from "main" or give NULL.
   */
  UIOnX(G4RunManager& aRunManager,
        const std::string& aGUI = "",
        int aArgc = 0,char** aArgv = NULL);
  virtual ~UIOnX();
  bool isValid() const;
  Slash::Core::ISession* session();
  Slash::Core::IWriter* printer();
  void addManager(Slash::Core::IManager*);
  void addAccessor(Slash::Data::IAccessor*);
  AIDA::IAnalysisFactory* findAIDA();
  bool createUI(const std::string& driver = "",
                const std::string& file = "",
                bool = true);
private:
  OnX::Main* fOnX;
  Slash::UI::IUI* fUI;
  Manager* fManager;
};

}

#endif

