// There is no explicit dependancy to G4 libs
// due to the fact that we can't have DLLs for them
// on Windows and Darwin. We pass through the
// IGeant4Manager interface and the Lib type manager 
// to access Geant4 from the GUI callbacks.

#include <OnX/Helpers/OnX.h>

// Lib :
#include <Slash/Core/ISession.h>
#include <Lib/Manager.h>
#include <Lib/smanip.h>
#include <Lib/Printer.h>
#include <Lib/Out.h>

// OnX :
#include <Slash/UI/IUI.h>

// G4Lab :
#include <G4Lab/Interfaces/IGeant4Manager.h>

// AIDA :
#include <AIDA/IAnalysisFactory.h>
#include <AIDA/IPlotterFactory.h>
#include <AIDA/IPlotter.h>
#include <AIDA/IPlotterRegion.h>

// From Lab/Callbacks/AIAA.h
//////////////////////////////////////////////////////////////////////////////
static AIDA::IAnalysisFactory* find_aida(
 Slash::Core::ISession& aSession
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return  Lib_findManager(aSession,"AnalysisFactory",AIDA::IAnalysisFactory);
}

extern "C" {

//////////////////////////////////////////////////////////////////////////////
void data_PV_dump(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();

  data_collect(session,"PV");

  std::string svalue;
  session.parameterValue("AccessorManager.dumpMode",svalue);
  data_dump(session,svalue);

}
//////////////////////////////////////////////////////////////////////////////
void data_PhysicsTable_dump(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();

  data_collect(session,"PhysicsTable");

  std::string svalue;
  session.parameterValue("AccessorManager.dumpMode",svalue);
  data_dump(session,svalue);

}
//////////////////////////////////////////////////////////////////////////////
void data_CrossSestion_annihil_positron_vis(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();

  data_collect(session,"PhysicsTable",
               "table==\"CrossSection\" and process==\"annihil\" and particle==\"e+\"");
  data_visualize(session);
}
//////////////////////////////////////////////////////////////////////////////
void G4_dump_ParticleTables(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  IGeant4Manager* g4Manager = 
    Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
  if(!g4Manager) {
    Lib::Out out(aUI.session().printer());
    out << "G4Lab_dump_ParticleTables :"
        << " Geant4Manager not found." 
        << Lib::endl;
    return;
  }
  g4Manager->particleTableDump();
}
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
void G4Lab_consolePrompt_complete(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  IGeant4Manager* g4Manager = 
    Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
  if(!g4Manager) {
    Lib::Out out(aUI.session().printer());
    out << "G4Lab_consolePrompt_complete :"
        << " Geant4Manager not found." 
        << Lib::endl;
    return;
  }

  std::string prompt;
  if(!aUI.parameterValue("consolePrompt.value",prompt)) return;
  if(prompt=="G4") {
    aUI.setParameter("consoleCommandLine.value",
                     g4Manager->completeCommand(aUI.callbackValue()));
  }
}
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
void G4Lab_exit(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  IGeant4Manager* g4Manager = 
    Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
  if(!g4Manager) return;
  if(g4Manager->isRunning()) {
    g4Manager->abortRun();
    aUI.exit();
    aUI.executeScript("DLD bg","OnX ui_exit");
  } else {
    aUI.exit();
  }
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab_nextEvent(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  IGeant4Manager* g4Manager = 
    Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
  if(!g4Manager) return;
  if(!g4Manager->isRunning()) {
    aUI.warn("No run started.");
  } else {
    aUI.exit();
  }
}
//////////////////////////////////////////////////////////////////////////////
/// G4Lab/scripts/OnX ////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
void G4Lab_InputRun_ok(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//FIXME : have a better exit ! (Handle properly the case
// where we exit whilst in a run.
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::string action;
  if(!aUI.parameterValue("G4Lab_InputRun_input_action.value",action)) return;

  IGeant4Manager* g4Manager = 
    Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
  if(!g4Manager) {
    Lib::Out out(aUI.session().printer());
    out << "G4Lab_InputRun_ok :"
        << " Geant4Manager not found." 
        << Lib::endl;
    return;
  }

  if(action=="Start run") {
    std::string snumber;
    if(!aUI.parameterValue("G4Lab_InputRun_input_number.value",snumber)) 
      return;
    int number;
    if(!Lib::smanip::toint(snumber,number)) return;

    g4Manager->beamOn(number);
    
  } else if(action=="Abort run") {
    g4Manager->executeG4Script("/run/abort");

  } else if(action=="Next event") {
    aUI.exit();
  }
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab_InputGun_ok(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::string direction;
  if(!aUI.parameterValue("G4Lab_InputGun_input_direction.value",direction)) return;

  std::string energy;
  if(!aUI.parameterValue("G4Lab_InputGun_input_energy.value",energy)) return;

  std::string particle;
  if(!aUI.parameterValue("G4Lab_InputGun_input_particle.value",particle)) return;

  IGeant4Manager* g4Manager = 
    Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
  if(!g4Manager) {
    Lib::Out out(aUI.session().printer());
    out << "G4Lab_InputGun_ok :"
        << " Geant4Manager not found." 
        << Lib::endl;
    return;
  }

  g4Manager->executeG4Script("/gun/particle "+particle);
  g4Manager->executeG4Script("/gun/direction "+direction);
  g4Manager->executeG4Script("/gun/energy "+energy);

}
//////////////////////////////////////////////////////////////////////////////
/// For a standard tree widget ///////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
void G4Lab_tree_option(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::string item = aUI.callbackValue();
  if(item=="PhysicalVolumes") {

    IGeant4Manager* g4Manager = 
      Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
    if(!g4Manager) {
      Lib::Out out(aUI.session().printer());
      out << "G4Simple_tree_option :"
          << " Geant4Manager not found." 
          << Lib::endl;
      return;
    }

    tree_set(aUI,"mainTree.items",g4Manager->physicalVolumes());

  } else if(item=="PhysicsTables") {

    data_collect(aUI.session(),"PhysicsTable");
    std::vector<std::string> vs = data_values(aUI.session(),"name");
    tree_set(aUI,"mainTree.items",Lib::smanip::tostring(vs,"\n"));

  } else if(item=="HitsCollections") {

    IGeant4Manager* g4Manager = 
      Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
    if(!g4Manager) {
      Lib::Out out(aUI.session().printer());
      out << "G4Simple_tree_option :"
          << " Geant4Manager not found." 
          << Lib::endl;
      return;
    }

    tree_set(aUI,"mainTree.items",g4Manager->hitsCollections());

  } else if(item=="DigitsCollections") {

    IGeant4Manager* g4Manager = 
      Lib_findManager(aUI.session(),"Geant4Manager",IGeant4Manager);
    if(!g4Manager) {
      Lib::Out out(aUI.session().printer());
      out << "G4Simple_tree_option :"
          << " Geant4Manager not found." 
          << Lib::endl;
      return;
    }

    tree_set(aUI,"mainTree.items",g4Manager->digitsCollections());

  } else {

    aUI.executeScript("DLD","OnXLab OnXLab_tree_option");

  }
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab_tree_select(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::string what;
  if(!aUI.parameterValue("optionTree.value",what)) return;

  if(what == "AIDA trees") {
    aUI.executeScript("DLD","OnXLab OnXLab_mainTree_selection");
  } else {
    std::string selection;
    if(!aUI.parameterValue("mainTree.selection",selection)) return;
    std::vector<std::string> items;
    Lib::smanip::lines(selection,items);
    if(!items.size()) return;
    if(what=="PhysicalVolumes") {
      what = "PV";
      data_collect(aUI.session(),what,"name==\""+items[items.size()-1]+"\"");
      data_visualize(aUI.session());
    } else if( (what=="HitsCollections") || 
               (what=="DigitsCollections") ) {
      what = items[items.size()-1];
      data_collect(aUI.session(),what);
      data_visualize(aUI.session());
    } else if(what=="PhysicsTables") {
      what = "PhysicsTable";
      // Clear current region :
      AIDA::IAnalysisFactory* aida = find_aida(aUI.session());
      if(aida) {
        AIDA::IPlotterFactory* fac = aida->createPlotterFactory();
        if(fac) {
          AIDA::IPlotter* plotter = fac->create();
          delete fac;
          if(plotter) {
            AIDA::IPlotterRegion& region = plotter->currentRegion();
            region.clear();
            delete plotter;
          }
        }
      }
      data_collect(aUI.session(),what,"name==\""+items[items.size()-1]+"\"");
      data_visualize(aUI.session());
    }
  }
}

} // extern "C"
